#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/TimeUtils.pm,v 1.2 2001/11/12 09:49:35 slhullier Exp $
##******************************************************************************
## Class TimeUtils
##  Description  : A package for time utils
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: TimeUtils.pm,v $
#Revision 1.2  2001/11/12 09:49:35  slhullier
#Flexibility for absolute time format.
#
#Revision 1.1  2001/11/09 13:42:42  slhullier
#Duration/Interval/StartStop modification
#

package LogTrend::Visu::TimeUtils;

use strict;
use Exporter;
use Time::Local;
use vars qw( @ISA @EXPORT );

use LogTrend::Common::Duration;

@ISA = qw(Exporter);
@EXPORT = qw( &TimeInterval &StartStop );

##******************************************************************************
## Function TimeInterval  public
##  Description  : return the boundaries in seconds from 1970 for a time-interval
##  Parameters   : the time-interval string
##  Return value : the start and stop boundaries
##******************************************************************************
sub TimeInterval
{
   my ($interval) = @_;
   my ($start, $stop);

   $interval =~ s/[ \n\t]//g;

   if( $interval !~ /^(last|current)([0-9]+)?(week|month|year)(s|es)?$/ )
   {
      die("Bad Interval expression $interval");
   }

   ##===========================================================================
   my ($lastCurrent) = ( $interval =~ /^(last|current)/ );
   $interval =~ s/^(last|current)//;

   $interval =~ s/(s|es)?$//;
   my ($timeUnit) = ( $interval =~ /(week|month|year)$/ );
   $interval =~ s/(week|month|year)$//;

   $interval = 1 if( $interval eq "" );
   my $number = $interval;
   die("The number is 0 in $interval") if( $number == 0 );

   ##===========================================================================
   my $now = time();
   my ($actualMonth, $actualYear)= (localtime($now))[4, 5];

   ##===========================================================================
   if( $timeUnit eq "month" )
   {
      if( $lastCurrent eq "last" )
      {
         $stop = timelocal(0, 0, 0, 1, $actualMonth, $actualYear) - 1;
         $actualMonth = $actualMonth - $number;
      }
      else # $lastCurrent eq "current"
      {
         $stop = $now + Duration("1M1d");
         $actualMonth = $actualMonth - $number + 1;
      }
      $actualYear += int(($actualMonth+1) / 12 -1);
      $actualMonth = $actualMonth % 12;
      $start = timelocal(0, 0, 0, 1, $actualMonth, $actualYear);
   }
   ##===========================================================================
   elsif( $timeUnit eq "year" )
   {
      if( $lastCurrent eq "last" )
      {
         $stop = timelocal(0, 0, 0, 1, 0, $actualYear) - 1;
         $actualYear -= $number;
      }
      else # $lastCurrent eq "current"
      {
         $stop = $now + Duration("1y1w");
         $actualYear -= $number + 1;
      }
      $start = timelocal(0, 0, 0, 1, 0, $actualYear);
   }

   ##===========================================================================
   return ($start,$stop);
}

##******************************************************************************
## Function AbsoluteTime  public
##  Description  : return the seconds from 1970 for an absotute-time
##  Parameters   : the absotute-time string "dd/mm/yyyy (hh/mm/ss)?"
##  Return value : the value in seconds
##******************************************************************************
sub AbsoluteTime
{
   my ($time) = @_;
   if( $time =~ /^(\d{1,2})\/(\d{1,2})\/(\d\d\d\d)(\s+(\d{1,2})\:(\d{1,2})(\:(\d{1,2}))?)?$/ )
   {
      if( defined ($4) )
      {
         my $s = $8 || 0;
         return timelocal( $s, $6, $5, $1, $2-1, $3 );
      }
      else
      {
         return timelocal( 0, 0, 0, $1, $2-1, $3 );
      }
   }
   else
   {
      return undef;
   }
}

##******************************************************************************
## Function StartStop  public
##  Description  : manage Start and Stop attributes in XML tags
##  Parameters   : the value of Start and Stop attributes
##  Return value : the start and stop boundaries, the absolute-time flag
##******************************************************************************
sub StartStop
{
   my ($start,$stop) = @_;
   my $absFlag;

   my $startSeconds = AbsoluteTime( $start );
   my $stopSeconds;
   if( !defined( $startSeconds ) )
   {
      $startSeconds = Duration( $start );
      $stopSeconds = Duration( $stop );
      return( $startSeconds, $stopSeconds, 0 );
   }
   else
   {
      $stopSeconds = AbsoluteTime( $stop );
      die("Bad AbsoluteTime representation $stopSeconds")
         if( !defined( $stopSeconds ) );
      return( $startSeconds, $stopSeconds, 1 );
   }
}

##******************************************************************************
1;
