#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Utils.pm,v 1.14 2001/12/05 16:32:36 slhullier Exp $
##******************************************************************************
## Class Utils
##  Description  : A package for utils (e.g. colors ...)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Utils.pm,v $
#Revision 1.14  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.13  2001/11/28 17:29:05  slhullier
#No more session ...
#
#Revision 1.12  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.11  2001/11/19 12:24:24  slhullier
#Accents ok for 5.5.3 and 5.6.1
#
#Revision 1.10  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.9  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.8  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.7  2001/11/09 13:42:42  slhullier
#Duration/Interval/StartStop modification
#
#Revision 1.6  2001/11/02 10:32:18  slhullier
#Strings color-format
#
#Revision 1.5  2001/10/30 15:02:52  lsimonneau
#utf8 bug with old perl version fixed.
#
#Revision 1.4  2001/10/24 09:28:15  slhullier
#*** empty log message ***
#
#Revision 1.3  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.2  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.1  2001/06/25 11:14:40  slhullier
#
#Customisation ...
#

package LogTrend::Visu::Utils;

use strict;
use Exporter;
use Unicode::String qw(utf8 latin1 utf16);
use vars qw( @ISA @EXPORT );
use POSIX qw(strftime);
use LogTrend::Common::Duration;
use LogTrend::Visu::Constants;

@ISA = qw(Exporter);
@EXPORT = qw( &TextToRGB &RGBtoInt
              &AccentsXML2Text &AccentsText2HTML
              &dateHTMLString $Utils_WarningMessage $Utils_CurrentFile );

my $Utils_CurrentFile = "";
my $Utils_WarningMessage = "";

my %ColorValues = ();

##******************************************************************************
## Function TextToRGB  public
##  Description  : transforms a text color to a #RRGGBB color
##  Parameters   : the text color
##  Return value : its coresponding #RRGGBB color
##******************************************************************************
sub TextToRGB
{
   my ($colorName) = @_;

   if( $colorName =~ /^#([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})$/ )
   {
      return $colorName;
   }

   TextToRGB_init() if( int(keys(%ColorValues)) == 0 );
   if( defined( $ColorValues{$colorName} ) )
   {
      my ($r,$g,$b) = ( $ColorValues{$colorName} =~ /(.*),(.*),(.*)/ );
      return sprintf "#%02lX%02lX%02lX", $r, $g, $b;
   }

   die( "Bad color name or format '$colorName'" );

}

##******************************************************************************
## Function RGBtoInt  public
##  Description  : retrun decimal color value
##  Parameters   : a string in #RRGGBB format where RR GG and BB are in hexa
##  Return value : a list of 3 integers
##******************************************************************************
sub RGBtoInt
{
   my ($colorName) = @_;

   if( $colorName =~ /^#([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})$/ )
   {
      return (hex($1),hex($2),hex($3));
   }

   die( "Bad color name or format '$colorName'" );
}

##******************************************************************************
## Function TextToRGB_init private
##  Description  : initialization of the hash table for text colors
##******************************************************************************
sub TextToRGB_init
{
   my $fileName = $CstRGBPath;
   open(FILE,"<$fileName") or die("open $fileName: $!");

   while( my $l = <FILE> )
   {
      next if( $l =~ /^!/ );
      my ($r,$g,$b,$name) = ($l =~ /^[ \t]*([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+(.*)$/ );
      $ColorValues{$name} = "$r,$g,$b";
   }

   close(FILE);
}

##******************************************************************************
## Function AccentsXML2Text  public
##******************************************************************************
sub AccentsXML2Text
{
   return utf8($_[0])->latin1();
}

##******************************************************************************
## Function AccentsText2HTML  public
##******************************************************************************
sub AccentsText2HTML
{
   my $return = $_[0];
   $return =~ s//&Agrave;/g;
   $return =~ s//&Aacute;/g;
   $return =~ s//&Acirc;/g;
   $return =~ s//&Atilde;/g;
   $return =~ s//&Auml;/g;
   $return =~ s//&Aring;/g;
   $return =~ s//&AElig;/g;
   $return =~ s//&Ccedil;/g;
   $return =~ s//&Egrave;/g;
   $return =~ s//&Eacute;/g;
   $return =~ s//&Ecirc;/g;
   $return =~ s//&Euml;/g;
   $return =~ s//&Igrave;/g;
   $return =~ s//&Iacute;/g;
   $return =~ s//&Icirc;/g;
   $return =~ s//&Iuml;/g;
   $return =~ s//&ETH;/g;
   $return =~ s//&Ntilde;/g;
   $return =~ s//&Ograve;/g;
   $return =~ s//&Oacute;/g;
   $return =~ s//&Ocirc;/g;
   $return =~ s//&Otilde;/g;
   $return =~ s//&Ouml;/g;
   $return =~ s//&Ugrave;/g;
   $return =~ s//&Uacute;/g;
   $return =~ s//&Ucirc;/g;
   $return =~ s//&Uuml;/g;
   $return =~ s//&Yacute;/g;
   $return =~ s//&szlig;/g;
   $return =~ s//&agrave;/g;
   $return =~ s//&aacute;/g;
   $return =~ s//&acirc;/g;
   $return =~ s//&atilde;/g;
   $return =~ s//&auml;/g;
   $return =~ s//&aring;/g;
   $return =~ s//&aelig;/g;
   $return =~ s//&ccedil;/g;
   $return =~ s//&egrave;/g;
   $return =~ s//&eacute;/g;
   $return =~ s//&ecirc;/g;
   $return =~ s//&euml;/g;
   $return =~ s//&igrave;/g;
   $return =~ s//&iacute;/g;
   $return =~ s//&icirc;/g;
   $return =~ s//&iuml;/g;
   $return =~ s//&eth;/g;
   $return =~ s//&ntilde;/g;
   $return =~ s//&ograve;/g;
   $return =~ s//&oacute;/g;
   $return =~ s//&ocirc;/g;
   $return =~ s//&otilde;/g;
   $return =~ s//&ouml;/g;
   $return =~ s//&divide;/g;
   $return =~ s//&oslash;/g;
   $return =~ s//&ugrave;/g;
   $return =~ s//&uacute;/g;
   $return =~ s//&ucirc;/g;
   $return =~ s//&uuml;/g;
   $return =~ s//&yacute;/g;
   $return =~ s//&yuml;/g;
   return $return;
}

##******************************************************************************
## Function dateHTMLString  public
##******************************************************************************
sub dateHTMLString
{
   my $str = strftime('%c', localtime());
   $str = AccentsText2HTML($str);
   return "<FONT SIZE=\"-1\">&lt;$str&gt;</FONT>";
}

##******************************************************************************
1;
