#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/SystemLeaf.pm,v 1.6 2001/11/15 16:08:57 slhullier Exp $
##******************************************************************************
## Class SystemLeaf  isa LogTrend::Visu::SystemLeaf isa ArchitectureNode
##  Description  : class for system (correspond to System XML tag)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: SystemLeaf.pm,v $
#Revision 1.6  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.5  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.4  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.3  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.2  2001/10/24 12:00:39  slhullier
#First version for report-generation
#
#Revision 1.1  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#

package LogTrend::Visu::Web::SystemLeaf;

use strict;

use LogTrend::Visu::Canvas;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Web::VisuClass;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::SystemLeaf");

##******************************************************************************
## Constructor  public
##  Parameters   : the data number, the position (x,y), the size (w,h)
##                 the start, the stop and the duration
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$systemsDeclaration);

   return undef if( !defined($self) ); # some systems are not wanted for reports or web

   bless($self, $classname);
   return $self;
}

##******************************************************************************
sub newVisuClass
{
   my ($self,$kid,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Web::VisuClass( $kid, $systemsDeclaration );
}

##******************************************************************************
## Method buildTree  public >LogTrend::Visu::SystemLeaf >ArchitectureNode
##  Description  : put this object in an HTML tree
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{
   my ($self,$dir) = @_;

   my $here;
   if( $dir ne "" ) { $here = $dir."/".$self->ident(); }
   else             { $here = $self->ident(); }

   my $result = "<LI><A HREF=\"".$here."/s000/\" TARGET=\"right\">$self->{NAME}</A>";
   if( $self->{DESCRIPTION} ne "" )
   {
      $result .= "<BR>\n$self->{DESCRIPTION}";
   }
   $result .= "\n";

   return $result;
}

##******************************************************************************
## Method treat  public >LogTrend::Visu::SystemLeaf >ArchitectureNode
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();
   my $screen;

   ##===========================================================================
   ## Request with screen
   ##===========================================================================
   if( $request->firstNodeExists() )
   {
      return $self->{CLASS}->treat( $request );
   }
   ##===========================================================================
   ## Request without screen
   ##===========================================================================
   else
   {
      $response->contentType("text/html");
      $response->print( "<HTML>\n" );
      $response->print( "<BODY BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\"".
                                " TEXT=\"".$self->{SYSTEMSDECLARATION}->getColor('Text')."\"".
                                " LINK=\"".$self->{SYSTEMSDECLARATION}->getColor('Links')."\"".
                               " VLINK=\"".$self->{SYSTEMSDECLARATION}->getColor('VisitedLinks')."\">\n" );
      $response->print( "<B>Error</B><BR>You are in a SystemLeaf<BR><BR>\n" );
      $response->print( "</BODY></HTML>\n" );
      return $response;
   }
}

##******************************************************************************
1;
