#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/SystemsDeclaration.pm,v 1.11 2001/11/27 16:04:51 slhullier Exp $
##******************************************************************************
## Class SystemsDeclaration isa LogTrend::Visu::SystemsDeclaration
##  Description  : correspond to the root of the XML file
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: SystemsDeclaration.pm,v $
#Revision 1.11  2001/11/27 16:04:51  slhullier
#User added in URL
#
#Revision 1.10  2001/11/26 15:52:31  slhullier
#User inclusion for admin user seems to be ok
#
#Revision 1.9  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.8  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.7  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.6  2001/11/14 13:14:13  slhullier
#*** empty log message ***
#
#Revision 1.5  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.4  2001/10/29 14:06:03  slhullier
#Stable but non-realy working report via the web
#
#Revision 1.3  2001/10/26 13:29:51  slhullier
#Little bug fix $self->{REFERENCE}
#
#Revision 1.2  2001/10/25 14:25:41  slhullier
#First working version for reports
#
#Revision 1.1  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#

package LogTrend::Visu::Web::SystemsDeclaration;

use strict;
use XML::DOM;
use LogTrend::Visu::Entity;
use LogTrend::Visu::SystemLeaf;
use LogTrend::Visu::Constants;
use LogTrend::Visu::SystemsDeclaration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Web::NetworkNode;
use LogTrend::Visu::Web::ReportGenerator;
use LogTrend::Visu::Web::UserNode;
use LogTrend::DataBaseAccess::PostgreSQLDataBase;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::SystemsDeclaration");

##******************************************************************************
## Constructor  public >LogTrend::Visu::SystemsDeclaration
##  Parameters   : the user, the XML root node
##******************************************************************************
sub new
{
   my ($classname,$user) = @_;
   my $self = $classname->SUPER::new( $user );
   bless($self, $classname);

   ##===========================================================================
   ## Report-generator adding
   ##===========================================================================
   NODE: foreach my $node (keys %{$self->{ARCHITECTURENODE}})
   {
      if( ref($self->{ARCHITECTURENODE}->{$node}) =~ /NetworkNode/ or
          ref($self->{ARCHITECTURENODE}->{$node}) =~ /SystemLeaf/ )
      {
         my $rg = new LogTrend::Visu::Web::ReportGenerator( $self->{USER}, $self );
         ${$self->{ARCHITECTURENODE}}{$rg->ident()} = $rg;
         last NODE;
      }
   }

   return $self;
}

##******************************************************************************
## Method newNetworkNode  protected
##******************************************************************************
sub newNetworkNode
{
   my ($self,$node,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Web::NetworkNode( $node, $systemsDeclaration );
}

##******************************************************************************
## Method newSystemLeaf  protected
##******************************************************************************
sub newSystemLeaf
{
   my ($self,$node,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Web::SystemLeaf( $node, $systemsDeclaration );
}

##******************************************************************************
## Method newUserNode  protected
##******************************************************************************
sub newUserNode
{
   my ($self,$node,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Web::UserNode( $node, $systemsDeclaration );
}

##******************************************************************************
## Method treat  public
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $architectureNode = $self->{ARCHITECTURENODE};
   my $response = new LogTrend::Visu::Response();
   my $node;

   ##===========================================================================
   ## Request with nodes
   ##===========================================================================
   if( $request->firstNodeExists() )
   {
      ##------------------------------------------------------------------------
      ## Image ?
      ##------------------------------------------------------------------------
      for( my $i=0; defined( $request->{NODES}->[$i] ); $i++ )
      {
         $node = $request->{NODES}->[$i];
         if( $node eq "images" )
         {
            $response->contentType("image/png");
            if( !$request->firstNodeExists() )
            {
               $! = 2; # No such file or directory
               $response->contentType("text/html");
               $response->print( "<B>Error</B><BR>$!" );
               return $response;
            }

            if( !open( FILE, "<$CstImagesPath/".$request->{NODES}->[$i+1] ) )
            {
               $response->contentType("text/html");
               $response->print( "<B>Error</B><BR>$!" );
               return $response;
            }
            $response->print($_) while(<FILE>);
            close FILE;
            return $response;
         }
      }


      ##------------------------------------------------------------------------
      ## Existing node
      ##------------------------------------------------------------------------
      $node = $request->firstNode();

      if( defined( $architectureNode->{$node} ) )
      {
         $request->shiftNodes();
         return $architectureNode->{$node}->treat( $request );
      }

      ##------------------------------------------------------------------------
      ## Not existing node : perhaps it was identified by it's name ?
      ##------------------------------------------------------------------------

      $node = $request->firstNode();
      foreach my $node_ident (keys %$architectureNode)
      {
          if($architectureNode->{$node_ident}->getName eq $node)
          {
              $request->shiftNodes;
              return $architectureNode->{$node_ident}->treat( $request );
          }
      }


      ##------------------------------------------------------------------------
      ## Not existing node : perhaps a special node ?
      ##------------------------------------------------------------------------
      if( $node eq "tree" )
      {
         $response->contentType("text/html");
         $response->print( $self->buildTree() );
         return $response;
      }
      elsif( $node eq "home" )
      {
         $response->contentType("text/html");
         $response->print( "<HTML>\n" );
         $response->print( "<BODY BGCOLOR=\"".$self->getColor('BackGround')."\"".
                                   " TEXT=\"".$self->getColor('Text')."\"".
                                   " LINK=\"".$self->getColor('Links')."\"".
                                  " VLINK=\"".$self->getColor('VisitedLinks')."\">\n" );
         $response->print( "<BR><BR><CENTER><H2>$self->{NAME}</H2>\n" );
         if( defined($self->{REFERENCE}) and $self->{REFERENCE} ne "" )
         { $response->print( "--- $self->{REFERENCE} ---\n" ); }
         $response->print( "</CENTER><BR><BR>\n\n" );
         my $contact = $self->{CONTACT};
         $response->print( "<UL>\n" );
         $response->print( "<LH>Contact" );
         if( @$contact > 1 )
         { $response->print( "s" ); }
         $response->print( "&nbsp;:</LH>" );
         foreach my $var (@$contact)
         {
            $response->print( "<LI><A HREF=\"mailto:$var->{EMAIL}\">$var->{FIRSTNAME} $var->{SURNAME}</A>\n" );
         }
         $response->print( "</UL>\n" );
         $response->print( "</BODY>\n</HTML>\n" );
         return $response;
      }
      elsif( $node eq "quit" )
      {
         $response->contentType("text/html");
         $response->print( "<HTML>\n" );
         $response->print( "<BODY BGCOLOR=\"".$self->getColor('BackGround')."\"".
                                   " TEXT=\"".$self->getColor('Text')."\"".
                                   " LINK=\"".$self->getColor('Links')."\"".
                                  " VLINK=\"".$self->getColor('VisitedLinks')."\">\n" );
         $response->print( "<CENTER>\n" );
         $response->print( "<BR><HR WIDTH=\"50%\">\n" );
         $response->print( "You are disconnected from $CstVisuName<BR>\n" );
         $response->print( "<HR WIDTH=\"50%\"><BR>\n" );
         $response->print( "<FONT SIZE=\"+2\">-&gt; <A HREF=\"/$CstVisuName/\" TARGET=\"_top\">New connection</A> &lt;-</FONT><BR>\n" );
         $response->print( "</CENTER>\n" );
         $response->print( "</BODY>\n</HTML>\n" );
         $response->quit(1);
         return $response;
      }

      $response->contentType("text/html");
      $response->print( "<B>Error</B><BR>No such node $node" );
      return $response;

   }

   ##===========================================================================
   ## Request without node
   ##===========================================================================
   $response->contentType("text/html");
   $response->print("<HTML>\n");
   $response->print("<HEAD>\n");
   $response->print("<TITLE>".$CstVisuName." : $self->{NAME}</TITLE>\n");
   $response->print("</HEAD>\n");
   $response->print("   <FRAMESET COLS=\"20%,*\" BORDER=\"0\">\n");
   $response->print("      <FRAME SRC=\"tree\" NAME=\"left\" marginwidth=\"0\">\n");
   $response->print("      <FRAME SRC=\"home\" NAME=\"right\">\n");
   $response->print("   </FRAMESET>\n");
   $response->print("<NOFRAMES>\n");
   $response->print("   <HR><BR>Your navigator can not display frames.<BR><HR>\n");
   $response->print("</NOFRAMES>\n");
   $response->print("</HTML>\n");
   return $response;
}

##******************************************************************************
## Method buildTree  public
##  Description  : put this object in an HTML tree
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{
   my ($self) = @_;
   my $result = "";

   $result .= "<HTML>\n";
   $result .= "<HEAD>\n";
   $result .= "<TITLE>".$CstVisuName." : $self->{NAME}</TITLE>\n";
   $result .= "</HEAD>\n";
   $result .= "<BODY BGCOLOR=\"".$self->getColor('BackGround')."\"".
                      " TEXT=\"".$self->getColor('Text')."\"".
                      " LINK=\"".$self->getColor('Links')."\"".
                     " VLINK=\"".$self->getColor('VisitedLinks')."\">\n";
   $result .= "&nbsp;<BR>\n";
   $result .= "<CENTER><A HREF=\"http://www.logtrend.org/\" TARGET=\"_top\">";
   $result .= "<IMG SRC=\"images/logtrend.png\" BORDER=\"0\"></A></CENTER><BR>\n";
   $result .= "<UL>\n";
   my $architectureNode = $self->{ARCHITECTURENODE};
   foreach my $var (sort keys %$architectureNode)
   {
      $result .= $architectureNode->{$var}->buildTree("");
   }
   $result .= "</UL>\n";
   $result .= "&nbsp; <A HREF=\"home\" TARGET=\"right\">Contacts</A><BR>\n";
##    $result .= "&nbsp; <A HREF=\"quit\" TARGET=\"_top\">Close the session</A><BR>\n"; ##
   $result .= "&nbsp; ";
   {
      use locale;
      $result .= LogTrend::Visu::Utils::dateHTMLString();
   }
   $result .= "\n";
   $result .= "</BODY>\n";
   $result .= "</HTML>\n";

   return $result;
}

##******************************************************************************
1;
