#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/Graph.pm,v 1.15.2.2 2002/02/13 10:40:41 lsimonneau Exp $
##******************************************************************************
## Class Graph  isa Zone
##  Description  : class from which inherit (Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Christophe Najar c.najar@atrid.fr
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Graph.pm,v $
#Revision 1.15.2.2  2002/02/13 10:40:41  lsimonneau
#*** empty log message ***
#
#Revision 1.15.2.1  2002/02/11 11:07:29  lsimonneau
#Bug fixe in graph zoom
#
#Revision 1.16  2002/02/11 10:59:14  lsimonneau
#Bug fixe in graph zoom.
#
#Revision 1.15  2002/01/04 13:53:14  slhullier
#Attribute Kilo of tag *Graph
#
#Revision 1.14  2002/01/03 12:24:17  slhullier
#bin prefix is /usr/bin
#
#Revision 1.13  2001/12/28 16:32:48  slhullier
#Graph extractor plugin engine works
#
#Revision 1.12  2001/12/27 17:10:25  slhullier
#Plugins 1st step
#
#Revision 1.11  2001/12/07 09:16:34  slhullier
#TooBigGap attribute
#
#Revision 1.10  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.9  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.8  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.7  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.6  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.5  2001/11/09 13:42:42  slhullier
#Duration/Interval/StartStop modification
#
#Revision 1.4  2001/11/06 14:30:50  slhullier
#Zoom feature seems to be ok
#
#Revision 1.3  2001/11/02 16:04:27  slhullier
#Moving in the graph by wrinting limit in boxes
#
#Revision 1.2  2001/10/25 13:40:59  lsimonneau
#Average Graph improvement.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.2  2001/10/23 12:54:13  slhullier
#Duration augmentation
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.37  2001/10/05 11:11:09  slhullier
#Some french texts to english
#
#Revision 1.36  2001/10/02 08:29:22  lsimonneau
#*** empty log message ***
#
#Revision 1.35  2001/10/02 08:18:35  lsimonneau
#Minor Bugfixes.
#
#Revision 1.34  2001/09/25 08:07:22  slhullier
#Text changing
#
#Revision 1.33  2001/09/18 15:11:03  slhullier
#no link for save
#
#Revision 1.32  2001/09/18 08:09:17  slhullier
#Using GetDataInRelativeTimeInterval
#
#Revision 1.31  2001/09/17 13:19:53  slhullier
#
#values rounded
#
#Revision 1.30  2001/09/05 09:00:22  slhullier
#
#LabelsPerLine done
#
#Revision 1.29  2001/09/05 08:13:10  lsimonneau
#Addo margins to top and bottom of the LineGraph.
#
#Revision 1.28  2001/08/22 08:36:24  slhullier
#
#Zoom modifications
#
#Revision 1.27  2001/08/21 09:11:18  slhullier
#
#Correct negativ values printing
#
#Revision 1.26  2001/08/21 08:45:07  slhullier
#
#Colors personnalisable + dial mis en place
#
#Revision 1.25  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.24  2001/08/17 09:29:35  slhullier
#
#Zoom navigation work for value-boundaries not set
#
#Revision 1.23  2001/08/14 15:13:10  slhullier
#
#Lovely pictures for zoom navigation.
#
#Revision 1.22  2001/08/14 14:25:22  slhullier
#
#Graph zoom : navigation is possible
#
#Revision 1.21  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.20  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#
#Revision 1.19  2001/07/26 14:50:21  slhullier
#
#Zoom on Graph works
#
#Revision 1.18  2001/06/29 13:18:50  slhullier
#
#Petite retouches avant premiere version 'stable'
#
#Revision 1.17  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.16  2001/06/26 10:00:12  slhullier
#
#Heritage BarGraph LineGraph
#
#Revision 1.15  2001/06/26 08:58:54  slhullier
#
#BarGraph ok. Avant fusion Graph/BarGraph avec heritage
#
#Revision 1.14  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.13  2001/06/25 11:14:40  slhullier
#
#Customisation ...
#
#Revision 1.12  2001/06/25 08:03:30  slhullier
#
#Utilisation de Graduation + affichage des dates bornes
#
#Revision 1.11  2001/06/22 15:24:49  slhullier
#
#Graph personalisable : le debut
#
#Revision 1.10  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.9  2001/06/20 14:22:10  slhullier
#*** empty log message ***
#
#Revision 1.8  2001/06/20 10:02:05  slhullier
#
#Bug, pour Laurent
#
#Revision 1.7  2001/06/19 16:23:53  slhullier
#
#Les graphs fonctionnent dans la visu (encore 1 petit pb de nom de variable)
#
#Revision 1.6  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.5  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Web::Zone::Graph;

use strict;

use GD;
use POSIX qw(strftime);
use Error qw(:try);

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Zone::Graph;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Web::Zone::GraphPlugin;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone::Graph");

use constant normalMode => 0;
use constant   zoomMode => 1;
use constant   demoMode => 2;

##******************************************************************************
## Constructor  public
##  Description  : creat a new Graph object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   ##===========================================================================
   return $self;
}

##******************************************************************************
## Method treat public >Zone::Graph
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;

   $self->{START}           = $self->{ORIGINAL_START};
   $self->{STOP}            = $self->{ORIGINAL_STOP};
   $self->{Y_LOWERBOUNDARY} = $self->{ORIGINAL_Y_LOWERBOUNDARY};
   $self->{Y_UPPERBOUNDARY} = $self->{ORIGINAL_Y_UPPERBOUNDARY};

   ##===========================================================================
   ## In-normal-screen request
   ##===========================================================================
   if( ! $request->firstNodeExists() )
   {
      ##------------------------------------------------------------------------
      ## HTML for a in-normal-screen request
      ##------------------------------------------------------------------------
      my $response = new LogTrend::Visu::Response();
      $response->contentType("text/html");
      $response->print( "      <A HREF=\"".$self->ident()."/zoom/".
         "?start=$self->{START}".
         "&stop=$self->{STOP}" );
      $response->print( "&yLower=$self->{Y_LOWERBOUNDARY}" )
         if( defined($self->{Y_LOWERBOUNDARY}) );
      $response->print( "&yUpper=$self->{Y_UPPERBOUNDARY}" )
         if( defined($self->{Y_UPPERBOUNDARY}) );
      $response->print( "\">" );
      $response->print( "<IMG BORDER=\"0\" ALT=\"Zoom\" SRC=\"".$self->ident()."/graph.png\">" );
      $response->print( "</A>\n" );
      return $response;
   }
   else
   {
      my $node = $request->shiftNodes();

      ##------------------------------------------------------------------------
      ## Picture for a in-normal-screen request
      ##------------------------------------------------------------------------
      if( $node eq "graph.png" )
      {
         return $self->generatePicture( $self->{COLSIZE}*$self->{WIDTH},
                                        $self->{PIXELHEIGHT},
                                        normalMode );
      }
      ##========================================================================
      ## Zoom request
      ##========================================================================
      elsif( $node eq "zoom" )
      {
         $self->{START} = Duration( $request->param('start'), 1 );
         return $self->htmlError("Start time: $self->{START}")
            if( $self->{START} !~ /^[0-9]+$/ );

         $self->{STOP} = Duration( $request->param('stop'), 1 );
         return $self->htmlError("Stop time: $self->{STOP}")
            if( $self->{STOP} !~ /^[0-9]+$/ );

         $self->{Y_LOWERBOUNDARY}          = $request->param('yLower');
         $self->{Y_UPPERBOUNDARY}          = $request->param('yUpper');
         $self->{ORIGINAL_Y_LOWERBOUNDARY} = $request->param('yLowerOrig');
         $self->{ORIGINAL_Y_UPPERBOUNDARY} = $request->param('yUpperOrig');

         ##---------------------------------------------------------------------
         ## HTML for zoom request
         ##---------------------------------------------------------------------
         if( !$request->firstNodeExists() )
         {
            return $self->zoomPage();
         }
         ##---------------------------------------------------------------------
         ## Picture for zoom request
         ##---------------------------------------------------------------------
         my $node = $request->shiftNodes();
         if( $node eq "zoom.png" )
         {
            return $self->generatePicture( 2* $self->{COLSIZE}*$self->{WIDTH},
                                           2* $self->{PIXELHEIGHT},
                                           zoomMode );
         }
      }
      ##========================================================================
      ## Export request
      ##========================================================================
      elsif( $node eq "export" )
      {
         $self->{START} = Duration( $request->param('start'), 1 );
         return $self->htmlError("Start time: $self->{START}")
            if( $self->{START} !~ /^[0-9]+$/ );

         $self->{STOP} = Duration( $request->param('stop'), 1 );
         return $self->htmlError("Stop time: $self->{STOP}")
            if( $self->{STOP} !~ /^[0-9]+$/ );

         return $self->exportsData( $request );
      }

   }

   my $response = new LogTrend::Visu::Response("text/html");
   $response->print( "<B>Error</B><BR>bad URL for ".$self->ident() );
   return $response;

}

##******************************************************************************
## Method zoomPage  protected
##  Description  : generate the HTML code for zoom page
##  Parameters   : none
##  Return value : a Response
##******************************************************************************
sub zoomPage
{
   my ($self) = @_;
   my $response = new LogTrend::Visu::Response();

   ##===========================================================================
   ## Boundary from data ??
   ##===========================================================================
   if( !defined($self->{Y_LOWERBOUNDARY}) or
       !defined($self->{Y_UPPERBOUNDARY}) or
       !defined($self->{ORIGINAL_Y_LOWERBOUNDARY}) or
       !defined($self->{ORIGINAL_Y_UPPERBOUNDARY}) )
   {
      my ($u,$l) = $self->generatePicture( 1000, 1000, # stupid size
                                           demoMode );
      $self->{Y_LOWERBOUNDARY} = $l if( !defined($self->{Y_LOWERBOUNDARY}) );
      $self->{Y_UPPERBOUNDARY} = $u if( !defined($self->{Y_UPPERBOUNDARY}) );
      $self->{ORIGINAL_Y_LOWERBOUNDARY} = $l if( !defined($self->{ORIGINAL_Y_LOWERBOUNDARY}) );
      $self->{ORIGINAL_Y_UPPERBOUNDARY} = $u if( !defined($self->{ORIGINAL_Y_UPPERBOUNDARY}) );
   }

   ##===========================================================================
   ## HTML generation
   ##===========================================================================
   $response->contentType("text/html");
   $response->print( "<HTML>\n" );
   $response->print( "<BODY BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\"".
                             " TEXT=\"".$self->{SYSTEMSDECLARATION}->getColor('Text')."\"".
                             " LINK=\"".$self->{SYSTEMSDECLARATION}->getColor('Links')."\"".
                            " VLINK=\"".$self->{SYSTEMSDECLARATION}->getColor('VisitedLinks')."\">\n" );
   $response->print( "&nbsp;<BR>\n" );
   $response->print( "<CENTER>\n" );
   $response->print( "<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"8\">\n" );
   ##===========================================================================
   ## Asking for actual picture
   ##===========================================================================
   $response->print( "<TR>\n" );
   $response->print( "   <TD COLSPAN=\"3\" ROWSPAN=\"3\" ALIGN=\"center\" VALIGN=\"middle\">\n" );
   $response->print( "      <IMG BORDER=\"0\" SRC=\"zoom.png".
      "?start=$self->{START}".
      "&stop=$self->{STOP}".
      "&yLower=$self->{Y_LOWERBOUNDARY}".
      "&yUpper=$self->{Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\">\n" );
   $response->print( "   </TD>\n" );
   ##===========================================================================
   ## Changing Y max value
   ##===========================================================================
   $response->print( "   <TD ALIGN=\"center\" VALIGN=\"top\">\n" );
   $response->print( "      <FORM METHOD=\"get\" ACTION=\"../zoom/\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"start\" VALUE=\"$self->{START}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"stop\" VALUE=\"$self->{STOP}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yLower\" VALUE=\"$self->{Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"text\" SIZE=\"10\" NAME=\"yUpper\" VALUE=\"$self->{Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yLowerOrig\" VALUE=\"$self->{ORIGINAL_Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yUpperOrig\" VALUE=\"$self->{ORIGINAL_Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      </FORM>\n" );
   $response->print( "   </TD>\n" );
   $response->print( "</TR>\n" );

   ##===========================================================================
   ## Changing Y values
   ##===========================================================================
   my $yDelta10 = ($self->{Y_UPPERBOUNDARY}-$self->{Y_LOWERBOUNDARY})/10;
   my $yDelta8  = ($self->{Y_UPPERBOUNDARY}-$self->{Y_LOWERBOUNDARY})/8;

   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"center\" VALIGN=\"middle\">\n" );
   $response->print( "      <TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"1\">\n" );
   ##---------------------------------------------------------------------------
   ## Move up
   ##---------------------------------------------------------------------------
   $response->print( "      <TR>\n" );
   $response->print( "         <TD ALIGN=\"right\" VALIGN=\"bottom\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=$self->{START}&stop=$self->{STOP}".
      "&yLower=".($self->{Y_LOWERBOUNDARY}+$yDelta10).
      "&yUpper=".($self->{Y_UPPERBOUNDARY}+$yDelta10).
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/move_up.png\" BORDER=\"0\" ALT=\"Move up\"></A>" );
   $response->print( "</TD>\n" );
   ##---------------------------------------------------------------------------
   ## Zoom +
   ##---------------------------------------------------------------------------
   $response->print( "         <TD ALIGN=\"left\" VALIGN=\"bottom\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=$self->{START}&stop=$self->{STOP}".
      "&yLower=".($self->{Y_LOWERBOUNDARY}+$yDelta10).
      "&yUpper=".($self->{Y_UPPERBOUNDARY}-$yDelta10).
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/zoom_plus.png\" BORDER=\"0\" ALT=\"Zoom +\"></A>" );
   $response->print( "</TD>\n" );
   $response->print( "      </TR>\n" );
   $response->print( "      <TR>\n" );
   ##---------------------------------------------------------------------------
   ## Move down
   ##---------------------------------------------------------------------------
   $response->print( "         <TD ALIGN=\"right\" VALIGN=\"top\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=$self->{START}&stop=$self->{STOP}".
      "&yLower=".($self->{Y_LOWERBOUNDARY}-$yDelta10).
      "&yUpper=".($self->{Y_UPPERBOUNDARY}-$yDelta10).
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/move_down.png\" BORDER=\"0\" ALT=\"Move down\"></A>" );
   $response->print( "</TD>\n" );
   ##---------------------------------------------------------------------------
   ## Zoom +
   ##---------------------------------------------------------------------------
   $response->print( "         <TD ALIGN=\"left\" VALIGN=\"top\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=$self->{START}&stop=$self->{STOP}".
      "&yLower=".($self->{Y_LOWERBOUNDARY}-$yDelta8).
      "&yUpper=".($self->{Y_UPPERBOUNDARY}+$yDelta8).
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/zoom_minus.png\" BORDER=\"0\" ALT=\"Zoom -\"></A>" );
   $response->print( "</TD>\n" );
   $response->print( "      </TR>\n" );
   ##---------------------------------------------------------------------------
   ## Reset
   ##---------------------------------------------------------------------------
   $response->print( "      <TR>\n" );
   $response->print( "         <TD COLSPAN=\"2\" ALIGN=\"center\" VALIGN=\"top\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=$self->{START}&stop=$self->{STOP}".
      "&yLower=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpper=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/reset.png\" BORDER=\"0\" ALT=\"Reset for Y\"></A>" );
   $response->print( "</TD>\n" );
   $response->print( "      </TR>\n" );
   $response->print( "      </TABLE>\n" );
   $response->print( "   </TD>\n" );
   $response->print( "</TR>\n" );

   ##===========================================================================
   ## Changing Y min value
   ##===========================================================================
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"center\" VALIGN=\"bottom\">\n" );
   $response->print( "      <FORM METHOD=\"get\" ACTION=\"../zoom/\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"start\" VALUE=\"$self->{START}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"stop\" VALUE=\"$self->{STOP}\">\n" );
   $response->print( "      <INPUT TYPE=\"text\" SIZE=\"10\" NAME=\"yLower\" VALUE=\"$self->{Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yUpper\" VALUE=\"$self->{Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yLowerOrig\" VALUE=\"$self->{ORIGINAL_Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yUpperOrig\" VALUE=\"$self->{ORIGINAL_Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      </FORM>\n" );
   $response->print( "   </TD>\n" );
   $response->print( "</TR>\n" );

   ##===========================================================================
   ## Changing X min value
   ##===========================================================================
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"left\" VALIGN=\"middle\">\n" );
   $response->print( "      <FORM METHOD=\"get\" ACTION=\"../zoom/\">\n" );
   $response->print( "      <INPUT TYPE=\"text\" SIZE=\"10\" NAME=\"start\" VALUE=\"".ReverseDuration($self->{START})."\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"stop\" VALUE=\"$self->{STOP}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yLower\" VALUE=\"$self->{Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yUpper\" VALUE=\"$self->{Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yLowerOrig\" VALUE=\"$self->{ORIGINAL_Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yUpperOrig\" VALUE=\"$self->{ORIGINAL_Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      </FORM>\n" );
   $response->print( "   </TD>\n" );

   ##===========================================================================
   ## Changing X values
   ##===========================================================================
   my $xDelta10 = int( 0.5 + ($self->{START}-$self->{STOP})/10 );
   my $xDelta8  = int( 0.5 + ($self->{START}-$self->{STOP})/8 );

   $response->print( "   <TD ALIGN=\"center\" VALIGN=\"middle\">\n" );
   $response->print( "      <TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"1\">\n" );
   ##---------------------------------------------------------------------------
   ## Move left
   ##---------------------------------------------------------------------------
   $response->print( "      <TR>\n" );
   $response->print( "         <TD ALIGN=\"right\" VALIGN=\"bottom\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=".($self->{START}+$xDelta10).
      "&stop=".($self->{STOP}+$xDelta10).
      "&yLower=$self->{Y_LOWERBOUNDARY}&yUpper=$self->{Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/move_left.png\" BORDER=\"0\" ALT=\"Move left\"></A>" );
   $response->print( "</TD>\n" );
   ##---------------------------------------------------------------------------
   ## Move right
   ##---------------------------------------------------------------------------
   $response->print( "         <TD ALIGN=\"left\" VALIGN=\"bottom\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=".($self->{START}-$xDelta10).
      "&stop=".($self->{STOP}-$xDelta10).
      "&yLower=$self->{Y_LOWERBOUNDARY}&yUpper=$self->{Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/move_right.png\" BORDER=\"0\" ALT=\"Move right\"></A>" );
   $response->print( "</TD>\n" );
   $response->print( "      </TR>\n" );
   ##---------------------------------------------------------------------------
   ## Zoom +
   ##---------------------------------------------------------------------------
   $response->print( "      <TR>\n" );
   $response->print( "         <TD ALIGN=\"right\" VALIGN=\"top\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=".($self->{START}-$xDelta10).
      "&stop=".($self->{STOP}+$xDelta10).
      "&yLower=$self->{Y_LOWERBOUNDARY}&yUpper=$self->{Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/zoom_plus.png\" BORDER=\"0\" ALT=\"Zoom +\"></A>" );
   $response->print( "</TD>\n" );
   ##---------------------------------------------------------------------------
   ## Zoom -
   ##---------------------------------------------------------------------------
   $response->print( "         <TD ALIGN=\"left\" VALIGN=\"top\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=".($self->{START}+$xDelta8).
      "&stop=".($self->{STOP}-$xDelta8).
      "&yLower=$self->{Y_LOWERBOUNDARY}&yUpper=$self->{Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/zoom_minus.png\" BORDER=\"0\" ALT=\"Zoom -\"></A>" );
   $response->print( "</TD>\n" );
   $response->print( "      </TR>\n" );
   ##---------------------------------------------------------------------------
   ## Reset
   ##---------------------------------------------------------------------------
   $response->print( "      <TR>\n" );
   $response->print( "         <TD COLSPAN=\"2\" ALIGN=\"center\" VALIGN=\"top\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=$self->{ORIGINAL_START}".
      "&stop=$self->{ORIGINAL_STOP}".
      "&yLower=$self->{Y_LOWERBOUNDARY}&yUpper=$self->{Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/reset.png\" BORDER=\"0\" ALT=\"Reset for X\"></A>" );
   $response->print( "</TD>\n" );
   $response->print( "      </TR>\n" );
   $response->print( "      </TABLE>\n" );
   $response->print( "   </TD>\n" );

   ##===========================================================================
   ## Changing X max value
   ##===========================================================================
   $response->print( "   <TD ALIGN=\"right\" VALIGN=\"middle\">\n" );
   $response->print( "      <FORM METHOD=\"get\" ACTION=\"../zoom/\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"start\" VALUE=\"$self->{START}\">\n" );
   $response->print( "      <INPUT TYPE=\"text\" SIZE=\"10\" NAME=\"stop\" VALUE=\"".ReverseDuration($self->{STOP})."\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yLower\" VALUE=\"$self->{Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yUpper\" VALUE=\"$self->{Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yLowerOrig\" VALUE=\"$self->{ORIGINAL_Y_LOWERBOUNDARY}\">\n" );
   $response->print( "      <INPUT TYPE=\"hidden\" NAME=\"yUpperOrig\" VALUE=\"$self->{ORIGINAL_Y_UPPERBOUNDARY}\">\n" );
   $response->print( "      </FORM>\n" );
   $response->print( "   </TD>\n" );

   ##===========================================================================
   ## Reset
   ##===========================================================================
   $response->print( "   <TD ALIGN=\"center\" VALIGN=\"middle\">" );
   $response->print( "<A HREF=\"../zoom/".
      "?start=$self->{ORIGINAL_START}".
      "&stop=$self->{ORIGINAL_STOP}".
      "&yLower=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpper=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "&yLowerOrig=$self->{ORIGINAL_Y_LOWERBOUNDARY}".
      "&yUpperOrig=$self->{ORIGINAL_Y_UPPERBOUNDARY}".
      "\"><IMG SRC=\"images/reset.png\" BORDER=\"0\" ALT=\"Reset\"></A>" );
   $response->print( "</TD>\n" );
   $response->print( "</TR>\n" );
   $response->print( "</TABLE><BR>\n" );

   ##===========================================================================
   ## Export
   ##===========================================================================
   $response->print( "<FORM METHOD=\"GET\" ACTION=\"../export/\">\n" );
   $response->print( "<INPUT TYPE=\"hidden\" name=\"start\" value=\"$self->{START}\">\n" );
   $response->print( "<INPUT TYPE=\"hidden\" name=\"stop\"  value=\"$self->{STOP}\">\n" );
   $response->print( "<TABLE BORDER=\"1\" CELLPADDING=\"0\" CELLSPACING=\"0\">\n" );
   $response->print( "<TR><TD>\n" );
   $response->print( "   <TABLE BORDER=\"0\" CELLSPACING=\"5\">\n" );
   $response->print( "   <TR><TD ALIGN=\"center\" VALIGN=\"middle\" COLSPAN=\"2\">\n" );
   $response->print( "      Exporter&nbsp;:\n" );
   $response->print( "   </TD></TR>\n" );
   $response->print( "   <TR><TD ALIGN=\"center\" VALIGN=\"middle\">\n" );
   $response->print( "      <SELECT NAME=\"exporter\">\n" );
   $response->print( "      <OPTION SELECTED VALUE=\"none\"> Format\n" );
   my %exporters = LogTrend::Visu::Web::Zone::GraphPlugin->availableExporters();
   foreach my $k (keys(%exporters))
   {
      $response->print( "      <OPTION VALUE=\"$k\"> $exporters{$k}\n" );
   }
   $response->print( "      </SELECT>\n" );
   $response->print( "   </TD>\n" );
   $response->print( "   <TD ALIGN=\"center\" VALIGN=\"middle\">" );
   $response->print( "      <INPUT TYPE=\"image\" SRC=\"images/save.png\" NAME=\"export\" ALT=\"Export\" BORDER=\"0\">\n" );
   $response->print( "</TD></TR>\n" );
   $response->print( "   </TABLE>\n" );
   $response->print( "</TD></TR>\n" );
   $response->print( "</TABLE>\n" );
   $response->print( "</FORM>\n" );
   $response->print( "</CENTER>\n" );
   $response->print( "</BODY>\n" );
   $response->print( "</HTML>\n" );
   return $response;

}

##******************************************************************************
## Method generatePicture  protected
##  Description  : generate the picture for the graph
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub generatePicture
{
   my ($self,$xSize,$ySize,$mode) = @_;

   ##===========================================================================
   ## Variables
   ##===========================================================================
   my $xMin = 40;
   my $xMax = $xSize - 10;

   ##---------------------------------------------------------------------------
   ## Legend variables
   ##---------------------------------------------------------------------------
   my ($colSize,$colNb,$truncSize);

   if( defined( $self->{LABELSPERLINE} ) )
   {
      $colNb = $self->{LABELSPERLINE};
      $colSize = int( ($xMax-$xMin+5) / $colNb );
      $truncSize = int( $colSize / gdSmallFont->width() ) - 1;
   }
   else
   {
      $truncSize = 14;
      $colSize = ($truncSize+1) * gdSmallFont->width();
      $colNb = int( ($xMax-$xMin+5) / $colSize );
   }

   ##---------------------------------------------------------------------------
   if( $colNb <= 0 &&
       $mode != demoMode )
   {
      my $response = new LogTrend::Visu::Response();
      my $image = new GD::Image($xSize,$ySize);
      if( !defined($image) )
      {
         $response->contentType("text/html");
         $response->print( "<HTML><BODY><CENTER>\n" );
         $response->print( "Error in <CODE>new GD::Image</CODE>&nbsp;: $!<BR>\n" );
         $response->print( "Furthermore, the image size is too small<BR>\n" );
         $response->print( "</CENTER></BODY></HTML>\n" );
         return $response;
      }

      $image->interlaced('true');
      $image->colorAllocate(255,255,255);
      my $textColor = $image->colorAllocate(0,0,0);
      $image->string( gdTinyFont, 0, 0, "TOO SMALL", $textColor );
      $response->contentType("image/png");
      $response->print( $image->png() );
      return $response;
   }
   my $linSize = gdSmallFont->height;

   ##===========================================================================
   ## Data pre-treatment
   ##===========================================================================
   my @data;
   my $time = time();
   my ($timeMin, $timeMax) = (undef,undef);
   my $valMax = undef;
   my @varName;
   my $yFact;
   my $xFact;

   my $data = $self->evalExpression($self->{START}, $self->{STOP});

   foreach my $e (keys %$data)
   {
       next if( $data->{$e} eq "0" );
       ##------------------------------------------------------------------------
       ## Searching value min/max
       ##------------------------------------------------------------------------
       if( defined( $self->{Y_UPPERBOUNDARY} ) )
       {
           $valMax = $self->{Y_UPPERBOUNDARY};
       }
       else
       {
           if( defined( $data->{$e}->[0]->[0] ) )
           {
               if( !defined($valMax) or $data->{$e}->[0]->[0] > $valMax )
               {
                   $valMax = $data->{$e}->[0]->[0];    # For optimisation of the next loop
               }

               foreach my $data (@{$data->{$e}})
               {
                   if( $data->[0] > $valMax ) { $valMax = $data->[0]; }
               }
           }
       }

      ##------------------------------------------------------------------------
      ## Looking for time min/max
      ##------------------------------------------------------------------------
      my $length = @{$data->{$e}} - 1;

      if( !defined($timeMin) or $data->{$e}->[0]->[1] < $timeMin )
      {
         $timeMin = $data->{$e}->[0]->[1];
      }
      if( !defined($timeMax) or $data->{$e}->[$length]->[1] > $timeMax )
      {
         $timeMax = $data->{$e}->[$length]->[1];
      }
   }

   ##---------------------------------------------------------------------------
   my $expressionsNb = keys %$data;
   my $lin = 1 + int( ($expressionsNb-1) / $colNb );

   my $yMin = 30;
   my $yMax = $ySize - $linSize*$lin - 6;

   ##===========================================================================
   ## Picture declaration
   ##===========================================================================
   my $image;
   my $colors;
   if( $mode != demoMode )
   {
      $image = new GD::Image($xSize,$ySize);
      if( !defined($image) )
      {
         my $response = new LogTrend::Visu::Response();
         $response->contentType("text/html");
         $response->print( "<HTML><BODY><CENTER>\n" );
         $response->print( "Error in <CODE>new GD::Image</CODE>&nbsp;: $!<BR>\n" );
         $response->print( "</CENTER></BODY></HTML>\n" );
         return $response;
      }

      $image->interlaced('true');

      $colors = $self->colorDeclaration( $image );

      $colors->{pictureBG} = $image->colorAllocate( @{$self->{PICTUREBGCOLOR}} );
      $colors->{graphBG}   = $image->colorAllocate( @{$self->{GRAPHBGCOLOR}} );
      $colors->{grid}      = $image->colorAllocate( @{$self->{GRIDCOLOR}} );
      $colors->{text}      = $image->colorAllocate( @{$self->{TEXTCOLOR}} );

      ##========================================================================
      ## Some widgets
      ##========================================================================
      $image->filledRectangle( 0, 0, $xSize, $ySize, $colors->{pictureBG} );
      $image->filledRectangle( $xMin, $yMin, $xMax, $yMax, $colors->{graphBG} );
      $image->rectangle( $xMin, $yMin, $xMax, $yMax, $colors->{grid} );
      $image->string( gdMediumBoldFont, 7, 5, $self->{TITLE}, $colors->{text} );
   }


   if( !defined( $valMax ) || !defined($timeMin) || !defined($timeMax) )
   {
      if( $mode != demoMode )
      {
         $image->string( gdMediumBoldFont, $xMin+3, $yMin+3, "No data", $colors->{text} );
         my $response = new LogTrend::Visu::Response();
         $response->contentType("image/png");
         $response->print( $image->png() );
         return $response;
      }
      else
      {
         return (0,1);
      }
   }

   ##---------------------------------------------------------------------------
   ## Calculating value graduation
   ##---------------------------------------------------------------------------
   my $valMin = 1e-5;
   $valMin = $self->{Y_LOWERBOUNDARY} if( defined( $self->{Y_LOWERBOUNDARY} ) );

   my $valPeriod;
   if( defined( $self->{Y_GRADUATION} ) &&
       $mode != zoomMode )
   {
      $valPeriod = $self->{Y_GRADUATION};
   }
   else
   {
      my $valDuration = $valMax-$valMin;
      my $log = log($valDuration*5) / log(10);
      if( $log < 0 ) { $log--; }
      $valPeriod   = ( 10 ** int( $log ) )/10;

      if( $self->{KILO} == 1024 )
      {
         my $fact1024 = 1;
         while( $valPeriod >= 1000 )
         {
            $valPeriod = $valPeriod/1000;
            $fact1024  *= 1024
         }
         $valPeriod *= $fact1024;
      }

   }

   if( !defined( $self->{Y_UPPERBOUNDARY} ) )
   {
      my $start = (int( ($valMax+$valPeriod) /$valPeriod))*$valPeriod;
      $valMax = $start;
   }
   if( !defined( $self->{Y_LOWERBOUNDARY} ) )
   {
      my $start = (int( ($valMin-$valPeriod) /$valPeriod))*$valPeriod;
      $valMin = $start;
   }

   ##---------------------------------------------------------------------------
   if( $mode == demoMode )
   {
      return ($valMax, $valMin);
   }

   ## yMaxReal and $yMinReal are the Y min and max Values including
   ## top and bottom margins.
   ## yMax and yMin became min and max Y coordinates without margin.
   $self->{Y_MARGIN} = 0 if ! exists($self->{Y_MARGIN});

   my $yMaxReal=$yMax;
   my $yMinReal=$yMin;

   $yMin+=($yMax-$yMin)*$self->{Y_MARGIN}/100;
   $yMax*=1-$self->{Y_MARGIN}/100;

   $yFact = ($yMax - $yMin) / ($valMax  - $valMin);
   my $yFactReal=($yMaxReal - $yMinReal) / ($valMax  - $valMin);

   $xFact = ($xMax - $xMin) / ($timeMax - $timeMin);

   ##===========================================================================
   ## Time graduations
   ##===========================================================================
   my $timeDuration = $timeMax - $timeMin;
   my ($timePeriod,$format);
   my $delta = 12;
   if( defined( $self->{X_GRADUATION} ) &&
       $mode != zoomMode )
   {
      $timePeriod = $self->{X_GRADUATION};
   }
   else
   {
      if(    $timeDuration <= Duration("1h") ) { $timePeriod = Duration("10m"); }
      elsif( $timeDuration <= Duration("6h") ) { $timePeriod = Duration("30m"); }
      elsif( $timeDuration <= Duration("1d") ) { $timePeriod = Duration("2h"); }
      elsif( $timeDuration <= Duration("3d") ) { $timePeriod = Duration("6h"); }
      elsif( $timeDuration <= Duration("1w") ) { $timePeriod = Duration("1d"); }
      elsif( $timeDuration <= Duration("3w") ) { $timePeriod = Duration("2d"); }
      elsif( $timeDuration <= Duration("2m") ) { $timePeriod = Duration("1w"); }
      else                                     { $timePeriod = Duration("1M"); }
   }

   if( $timePeriod < Duration("1h") )
   {
      $format = "%H:%M";
   }
   elsif( $timeDuration <= Duration("2d") )
   {
      $format = "%Hh";
      $delta = 7;
   }
   else
   {
      $format = "%d/%m";
   }

   my $phase = $timeMin % $timePeriod;
   for(my $i = $timeMin+$timePeriod-$phase; $i<$timeMax; $i+=$timePeriod )
   {
      my $str = strftime( $format, localtime($i) );
      my $x = $xMin+$xFact*($i-$timeMin);
      $image->string( gdTinyFont, $x-$delta, 20, $str, $colors->{text} );
      $image->line( $x, $yMinReal, $x, $yMaxReal, $colors->{grid} );
   }

   ##---------------------------------------------------------------------------
   my $timeFormat = '%c';
   $delta = 147;
   if( $xSize < 300 )
   {
      $timeFormat = '%d %b %H:%M';
      $delta = 60;
   }

   my ($printedTimeMin, $printedTimeMax) = ($timeMin, $timeMax);

   if(defined $self->{FORCE_PRINTED_TIME_MIN}) {
       $printedTimeMin = $self->{FORCE_PRINTED_TIME_MIN};
   }

   if(defined $self->{FORCE_PRINTED_TIME_MAX}){
       $printedTimeMax = $self->{FORCE_PRINTED_TIME_MAX};
   }

   $image->string( gdTinyFont, $xSize-$delta, 0,
                   strftime( $timeFormat, localtime($printedTimeMin) ), $colors->{text} );

   $image->string( gdTinyFont, $xSize-$delta, 8,
                   strftime( $timeFormat, localtime($printedTimeMax) ), $colors->{text} );

   ##===========================================================================
   ## Value graduations
   ##===========================================================================
   for(my $i = $valMin; $i<=$valMax; $i+=$valPeriod )
   {
      my ($j,$i2);
      if( $i<0 ) { $i2 = -$i; } else { $i2 =  $i; }

      if( $self->{KILO} == 1000 )
      {
         if(    $i2 >= 1000000000000 ) { $j = substr($i/1000000000000, 0, 5). "t"; }
         elsif( $i2 >= 1000000000    ) { $j = substr($i/1000000000   , 0, 5). "g"; }
         elsif( $i2 >= 1000000       ) { $j = substr($i/1000000      , 0, 5). "m"; }
         elsif( $i2 >= 1000          ) { $j = substr($i/1000         , 0, 5). "k"; }
         elsif( $i2 >= 1 or $i == 0  ) { $j = substr($i              , 0, 5);      }
         elsif( $i2 < 0.0000000001   ) { $j = substr($i*1000000000000, 0, 5)."-t"; }
         elsif( $i2 < 0.0000001      ) { $j = substr($i*1000000000   , 0, 5)."-g"; }
         elsif( $i2 < 0.0001         ) { $j = substr($i*1000000      , 0, 5)."-m"; }
         elsif( $i2 < 0.1            ) { $j = substr($i*1000         , 0, 5)."-k"; }
         else                          { $j = substr($i              , 0, 5);      }
         $j = sprintf "%5s", $j;
      }
      else # $self->{KILO} == 1024
      {
         if(    $i2 >= 1099511627776 ) { $j = substr($i/1099511627776, 0, 5). "T"; }
         elsif( $i2 >= 1073741824    ) { $j = substr($i/1073741824   , 0, 5). "G"; }
         elsif( $i2 >= 1048576       ) { $j = substr($i/1048576      , 0, 5). "M"; }
         elsif( $i2 >= 1024          ) { $j = substr($i/1024         , 0, 5). "K"; }
         elsif( $i2 >= 1 or $i == 0  ) { $j = substr($i              , 0, 5);      }
         elsif( $i2 < 0.0000000001   ) { $j = substr($i*1000000000000, 0, 5)."-t"; }
         elsif( $i2 < 0.0000001      ) { $j = substr($i*1000000000   , 0, 5)."-g"; }
         elsif( $i2 < 0.0001         ) { $j = substr($i*1000000      , 0, 5)."-m"; }
         elsif( $i2 < 0.1            ) { $j = substr($i*1000         , 0, 5)."-k"; }
         else                          { $j = substr($i              , 0, 5);      }
         $j = sprintf "%5s", $j;
      }

      my $y = $yMax - $yFact * ($i-$valMin);
      $image->string( gdTinyFont, 10, $y-3, $j, $colors->{text} );
      $image->line( $xMin-2, $y, $xMax+2, $y, $colors->{grid} );
   }

   ##===========================================================================
   ## Data printing
   ##===========================================================================

   my $expr_colors = $self->expressionColors;
   my $colorNb = 0;
   foreach my $e (keys %$data)
   {
       my $color;
       my $colorName = $expr_colors->{$e};
       if( defined( $colorName ) )
       { $color = $image->colorAllocate( RGBtoInt( $colorName ) ); }
       else
       {
           $color = $colors->{$colorNb % $colors->{nb}};
       }

       ##------------------------------------------------------------------------
       ## Lines
       ##------------------------------------------------------------------------
       if( $data->{$e} ne "0" )
       {
           my %old = ();
           $old{x} = undef;
           $old{y} = undef;
           $old{time} = 0;
           $old{value} = undef;

           foreach my $data (@{$data->{$e}})
           {
               if( $data->[0] > $valMax or
                   $data->[0] < $valMin )
               {
                   $old{x} = undef;
                   next;
               }

               my $x = $xMin + $xFact * ($data->[1]-$timeMin);
               my $y = $yMax - $yFact * ($data->[0]-$valMin );
               if( defined($old{x}) and
                   ($data->[1]-$old{time} < $self->{X_TOOBIGGAP} ) )
               {
                   $self->drawValue( $image, $x, $y, \%old, $color, $colors, $yMax);
               }
               $old{x} = $x;
               $old{y} = $y;
               $old{time} = $data->[1];
               $old{value} = $data->[0];
           }
       }

       ##------------------------------------------------------------------------
       ## Legend
       ##------------------------------------------------------------------------
       my $col = $colorNb % $colNb;
       my $lin = int( $colorNb / $colNb );
       my $xPos = $xMin + 1 + $colSize*$col;
       my $yPos = $yMaxReal + 3 + $linSize*$lin;
       $image->filledRectangle( $xPos-2, $yPos+2, $xPos+$colSize-5, $yPos+$linSize, $colors->{graphBG} );
       my $label = substr( $e, 0, $truncSize );
       $image->string( gdSmallFont, $xPos, $yPos, $label, $color );

       $colorNb++;
   }

   ##===========================================================================
   ## Responding
   ##===========================================================================
   my $response = new LogTrend::Visu::Response();
   $response->contentType("image/png");
   $response->print( $image->png() );
   return $response;
}

##******************************************************************************
## Method exportsData  protected
##  Description  : exports the data into the asked format
##******************************************************************************
sub exportsData
{
   my ($self,$request) = @_;

   my $exporterName = $request->param('exporter');
   return $self->htmlError("First, choose a format.")
      if( $exporterName eq "none" );

   my $module = LogTrend::Visu::Web::Zone::GraphPlugin->getExporterFullName( $exporterName );

   my $response;
   try
   {
      die( $! )  if( ! eval "require $module" );
      $module->import();
      my $data = $self->evalExpression($self->{START}, $self->{STOP});
      my $exporter = $module->new();
      $response = $exporter->export( $data, $self->{EXPRESSIONS}, $self->{TITLE} );
   }
   otherwise
   {
      return $self->htmlError("Error in exporting");
   };  # ; very important

   return $response;
}

##******************************************************************************
## Method htmlError  public
##  Description  : generate an html-Response for an error
##******************************************************************************
sub htmlError
{
   my ($self,$message) = @_;
   my $response = new LogTrend::Visu::Response("text/html");
   $response->print( "<HTML>\n" );
   $response->print( "<HEAD><TITLE>Error</TITLE></HEAD>\n" );
   $response->print( "<META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\">\n" );
   $response->print( "<BODY BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\"".
                             " TEXT=\"".$self->{SYSTEMSDECLARATION}->getColor('Text')."\"".
                             " LINK=\"".$self->{SYSTEMSDECLARATION}->getColor('Links')."\"".
                            " VLINK=\"".$self->{SYSTEMSDECLARATION}->getColor('VisitedLinks')."\">\n" );
   $response->print( "<CENTER>\n" );
   $response->print( "<BR><HR WIDTH=\"50%\">\n" );
   $response->print( "<B>$message</B><BR>\n" );
   $response->print( "<HR WIDTH=\"50%\"><BR>\n" );
   $response->print( "<A HREF=\"javascript:history.back()\">Return to the previous page</A>\n" );
   $response->print( "</CENTER>\n" );
   $response->print( "</BODY>\n" );
   $response->print( "</HTML>\n" );
   return $response;
}

##******************************************************************************
## Method colorDeclaration  protected
##  Description  : declare specific colors for picture
##  Parameters   : the image
##  Return value : a reference on an hash-table
##******************************************************************************
sub colorDeclaration
{
   # To be defined in inheriting objects
}

##******************************************************************************
## Method drawValue  protected
##  Description  : draw a value according to the type of Graph
##  Parameters   : the image, x, y, old values, color for drawing (, table
##                 of colors, yMax)
##  Return value : none
##******************************************************************************
sub drawValue
{
   # To be defined in inheriting objects
}

##******************************************************************************
1;
