#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/GraphPlugin/Fake.pm,v 1.1 2001/12/28 16:32:48 slhullier Exp $
##******************************************************************************
## Class Fake > GraphPlugin
##  Description  : Fake exporter
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Fake.pm,v $
#Revision 1.1  2001/12/28 16:32:48  slhullier
#Graph extractor plugin engine works
#

package LogTrend::Visu::Web::Zone::GraphPlugin::Fake;

use strict;
use POSIX qw(strftime);
use LogTrend::Visu::Response;
use LogTrend::Visu::Web::Zone::GraphPlugin;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Web::Zone::GraphPlugin");

##******************************************************************************
## Constructor  public
##  Parameters   : none
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new( "Fake / not a real exporter",
                                      "fak" );
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Method export  public > GraphPlugin
##  Description  : treat a request
##  Parameters   : a reference to a hash table containing the data,
##                 a reference to the list containing the expressions name,
##                 the title of the graph
##  Return value : a Response object
##******************************************************************************
sub export
{
   my ($self,$data,$expressions,$title) = @_;
   my $response = new LogTrend::Visu::Response();
   $response->contentType("application/octet-stream");
   $response->print("Fake\n");
   $response->fileName( $self->getFileName( $title ) );
   return $response;
}

##******************************************************************************
1;
