#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/Label.pm,v 1.3 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Label  isa Zone
##  Description  : class for tests
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Label.pm,v $
#Revision 1.3  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.2  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.5  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.4  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.3  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.2  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.1  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.2  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Web::Zone::Label;

use strict;

use LogTrend::Common::Duration;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Label object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   return $self;
}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();

   $response->contentType("text/html");
   if( $self->{TITLE} ne " " )
   {
      $response->print("      $self->{TITLE}\n");
   }
   else
   {
      $response->print("      &nbsp;\n");
   }
   return $response;
}

##******************************************************************************
1;
