#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/LineGraph.pm,v 1.4 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class LineGraph  isa Graph isa Zone
##  Description  : class for drawing curves
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Christophe Najar c.najar@atrid.fr
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: LineGraph.pm,v $
#Revision 1.4  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.3  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.2  2001/10/26 09:29:01  lsimonneau
#Minor bugfixes with graph colors.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.5  2001/09/05 08:13:10  lsimonneau
#Addo margins to top and bottom of the LineGraph.
#
#Revision 1.4  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.3  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.2  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.1  2001/06/26 10:00:12  slhullier
#
#Heritage BarGraph LineGraph
#

package LogTrend::Visu::Web::Zone::LineGraph;

use strict;

use GD;
use POSIX qw(strftime);

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Web::Zone::Graph;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Web::Zone::Graph");

##******************************************************************************
## Constructor  public
##  Description  : creat a new LineGraph object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   ## Set top and bottom margin to 5 %
   $self->{Y_MARGIN} = 5;

   return $self;
}

##******************************************************************************
## Method colorDeclaration  protected >Graph
##  Description  : declare specific colors for picture
##  Parameters   : the image
##  Return value : a reference on an hash-table
##******************************************************************************
sub colorDeclaration
{
   my ($self,$image) = @_;

   my %colors;
   $colors{0} = $image->colorAllocate(255,  0,  0); #red
   $colors{1} = $image->colorAllocate(  0,192,  0); #green
   $colors{2} = $image->colorAllocate(  0,  0,255); #blue
   $colors{3} = $image->colorAllocate(255,255,  0); #yellow
   $colors{4} = $image->colorAllocate(255,128,255); #pink
   $colors{5} = $image->colorAllocate(192,  0,255); #purple
   $colors{6} = $image->colorAllocate(  0,224,224); #green/blue

   $colors{nb} = 7;
   my $colorsNb = 7;

   return \%colors;

}

##******************************************************************************
## Method drawValue  protected >Graph
##  Description  : draw a value according to the type of Graph
##  Parameters   : the image, x, y, old values, color for drawing (, table
##                 of colors, yMax)
##  Return value : none
##******************************************************************************
sub drawValue
{
   my ($self,$image,$x,$y,$old,$color) = @_;

   $image->line( $x, $y, $old->{x}, $old->{y}, $color );
}

##******************************************************************************
1;
