#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Zone/BarGraph.pm,v 1.10 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class ReportGraph  isa Zone
##  Description  : class from which inherit Report(Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Christophe Najar c.najar@atrid.fr
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: BarGraph.pm,v $
#Revision 1.10  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.9  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.8  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.7  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.6  2001/10/23 12:18:37  lsimonneau
#Now, LogTrend::Visu::Zone contains generic classes for Report/Web Zone.
#

package LogTrend::Visu::Zone::BarGraph;

use strict;

use POSIX qw(strftime tmpnam);

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;


use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone::Graph");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Graph object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   return $self;
}



##******************************************************************************
## parseXML  protected (>Graph)
##  Description  : parse bar graph specific xml entry
##  Parameters   :
##******************************************************************************
sub parseXML {
   my ($self,$rootnode,$realrootnode) = @_;
   my ($list,$node,$attributes,$attrnode);

   $self->SUPER::parseXML($rootnode, $realrootnode);

   ##===========================================================================
   ## Thresholds tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Thresholds");
   $node = $list->item(0);
   $self->{WARNING}  = undef;
   $self->{CRITICAL} = undef;
   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Thresholds\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Warning");
      if( defined( $attrnode ) )
      {  $self->{WARNING} = $attrnode->getValue(); }
      # default = 0

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Critical");
      if( defined( $attrnode ) )
      {  $self->{CRITICAL} = $attrnode->getValue(); }
   }

   ##===========================================================================
   ## Colors3 tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Colors3");
   $node = $list->item(0);
   my @warningColor  = (255, 93,  0);
   my @criticalColor = (255,  0,  0);
   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Colors3\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Warning");
      if( defined( $attrnode ) )
      { @warningColor = RGBtoInt( TextToRGB( $attrnode->getValue() ) ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Critical");
      if( defined( $attrnode ) )
      { @criticalColor = RGBtoInt( TextToRGB( $attrnode->getValue() ) ); }

   }
   $self-> {WARNINGCOLOR} =  \@warningColor;
   $self->{CRITICALCOLOR} = \@criticalColor;
}

##******************************************************************************
1;
