#!/bin/sh
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: install_logwatch.sh 
# Author: Mike Tremaine [mgt /at/ stellarcore.net]
# Maintainer:
# Version: 1.0.1
#
#Note: This script is provided for the non-RPM installs.
#It is preferred that logwatch be packaged by a distribution
#specifically for your installation. But since that is not always
#possible we have included this script.

#Set PATH for solaris /usr/ucb/install
PATH=/usr/ucb:$PATH:
export PATH

#Get to install base
#cd `dirname $0`

#Edit these to configure your preferred defaults
#Defaults
BASEDIR="/usr/share/logwatch"
CONFIGDIR="/etc/logwatch"
TEMPDIR="/var/cache/logwatch"
PERLEXE="/usr/bin/perl"
MANDIR="/usr/share/man"


#Talk to user
printf "#################################\n"
printf "Preparing to install Logwatch\n"
printf "Enter the path to the Logwatch BaseDir [$BASEDIR] : "
read base

if [ "$base" = "" ]; then
 printf "### Using $BASEDIR\n"
else
 BASEDIR="$base"
 #Set munge flag
 munge_base=1
 printf "### Using $BASEDIR [will modify logwatch.pl]\n"
fi

printf "Enter the path for the Logwatch ConfigDir [$CONFIGDIR] : "
read config  

if [ "$config" = "" ]; then
 printf "### Using $CONFIGDIR\n"
else
 CONFIGDIR="$config" 
 munge_conf=1
 printf "### Using $CONFIGDIR [will modify logwatch.pl]\n"
fi

printf "Enter the dir name to be used for temp files [$TEMPDIR] : "
read temp

if [ "$temp" = "" ]; then
 printf "### Using $TEMPDIR\n"
else
 TEMPDIR="$temp"
 munge_temp=1
 printf "### Using $TEMPDIR [will write to $CONFIGDIR/conf/logwatch.conf]\n"
fi

printf "Enter the location of perl [$PERLEXE] : "
read perlexe

if [ "$perlexe" = "" ]; then
 printf "### Using $PERLEXE\n"
else
 PERLEXE="$perlexe"
 munge_perl=1
 printf "### Using $PERLEXE [will modify logwatch.pl]\n"
fi

echo "### Installing"

#BASE
install -m 0755 -d $BASEDIR
install -m 0755 -d $BASEDIR/dist.conf
install -m 0755 -d $BASEDIR/dist.conf/logfiles
install -m 0755 -d $BASEDIR/dist.conf/services
install -m 0755 -d $BASEDIR/default.conf
install -m 0755 -d $BASEDIR/default.conf/logfiles
install -m 0755 -d $BASEDIR/default.conf/services
install -m 0755 -d $BASEDIR/scripts
install -m 0755 -d $BASEDIR/scripts/logfiles
install -m 0755 -d $BASEDIR/scripts/services
install -m 0755 -d $BASEDIR/scripts/shared
install -m 0755 -d $BASEDIR/lib
install -m 0644 README $BASEDIR/README
install -m 0644 HOWTO-Customize-LogWatch $BASEDIR/HOWTO-Customize-LogWatch
install -m 0644 conf/*.conf $BASEDIR/default.conf
install -m 0644 conf/logfiles/* $BASEDIR/default.conf/logfiles
install -m 0644 conf/services/* $BASEDIR/default.conf/services
install -m 0755 scripts/logwatch.pl $BASEDIR/scripts/logwatch.pl
for i in scripts/logfiles/* ; do
   if [ `ls $i | wc -l` -ne 0 ] ; then
      install -m 0755 -d $BASEDIR/$i
      install -m 0644 $i/* $BASEDIR/$i
   fi
done
install -m 0644 scripts/shared/* $BASEDIR/scripts/shared
install -m 0644 scripts/services/* $BASEDIR/scripts/services
install -m 0644 lib/* $BASEDIR/lib

if [ $munge_base ]; then
	perl -pi -e "s%/usr/share/logwatch%$BASEDIR%" $BASEDIR/scripts/logwatch.pl
fi

#CONFIG
install -m 0755 -d $CONFIGDIR
install -m 0755 -d $CONFIGDIR/scripts
install -m 0755 -d $CONFIGDIR/conf
install -m 0755 -d $CONFIGDIR/conf/logfiles
install -m 0755 -d $CONFIGDIR/conf/services

if [ $munge_conf ]; then
	perl -pi -e "s%/etc/logwatch/conf%$CONFIGDIR/conf%" $BASEDIR/scripts/logwatch.pl
fi

touch $CONFIGDIR/conf/logwatch.conf
touch $CONFIGDIR/conf/ignore.conf
touch $CONFIGDIR/conf/override.conf

#TEMP
#Using sanity check incase someone uses /tmp.
#The install would destory the perms on /tmp
if [ ! -d $TEMPDIR ]; then
	#Should this be 0700 -d $TEMPDIR ??
	install -m 0755 -d $TEMPDIR
fi
if [ $munge_temp ]; then
	echo "TmpDir = $TEMPDIR" >> $CONFIGDIR/conf/logwatch.conf
fi

#PERL
if [ $munge_perl ]; then
	perl -pi -e "s%/usr/bin/perl%$PERLEXE%" $BASEDIR/scripts/logwatch.pl
fi

#Man page
if [ -d $MANDIR/man8 ]; then
	#Should exist in BSD and Linux
	install -m 0644 logwatch.8 $MANDIR/man8
	makewhatis -u -s 8 $MANDIR
else
 if [ `uname -s` = "SunOS" ]; then
	#Go for the safe install rather then editing man.cf
	install -m 0644 logwatch.8 $MANDIR/man1m
	catman -w -M /usr/share/man/man1m
 else
	install -m 0755 -d $MANDIR/man8
	install -m 0644 logwatch.8 $MANDIR/man8
	printf "Installed manpage in $MANDIR/man8.\n"
	printf "Check your man.cf or man.conf to enable MANSECTS 8\n"
 fi
fi

#Symlink
ln -s $BASEDIR/scripts/logwatch.pl /usr/sbin/logwatch
printf "Created symlink for /usr/sbin/logwatch \n"

#Cron
if [ -d /etc/cron.daily ]; then
	rm -f /etc/cron.daily/0logwatch
	ln -s $BASEDIR/scripts/logwatch.pl /etc/cron.daily/0logwatch
	printf "Created /etc/cron.daily/0logwatch \n" 
else
	printf "You need to setup your cron job for logwatch, something like \n"
	printf "2 0 * * * /etc/logwatch/scripts/logwatch.pl >/dev/null 2>&1 \n"

fi

exit
