/* Copyright (C) 2000-2003 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef LOPSTER_H_
#define LOPSTER_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <sys/time.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>

#include "buffer.h"

#ifdef HAVE_ZLIB
#include <zlib.h>
#endif

#define INTERN_MICRO_VERSION   0

#define ADVANCED_CONNECTION

#define CU_VOICE        0x01
#define CU_OP           0x02
#define CU_CREATOR      0x04
#define CU_BANNED       0x08
#define CU_MUZZLED      0x10

#define TREE_MARKED     0x01
#define LIB_DELETE      0x02  
#define LIB_VIRTUAL     0x04
#define LIB_SHARED      0x08
#define LIB_REMOVE      0x10
#define LIB_NEW         0x20
#define LIB_OLD         0x40

#define MODE_ERROR	 0
#define MODE_BAN	 1
#define MODE_CHANGE	 2
#define MODE_KILL	 3
#define MODE_LEVEL	 4
#define MODE_SERVER	 5
#define MODE_MUZZLE	 6
#define MODE_PORT	 7
#define MODE_WALLOP	 8
#define MODE_CLOAK	 9
#define MODE_FLOOD	 10
#define MODE_PING	 11
#define MODE_MSG	 12
#define	MODE_WHOIS	 13
// slavanap only
#define MODE_ANNOUNCE    14
#define MODE_BROWSE      15
#define MODE_MOTD        16
#define MODE_FRIEND      17
#define MODE_CHANNEL     18
#define MODE_REGISTER    19
#define MODE_VAR         20
// opennap-ng only
#define MODE_ABUSE       21
#define MODE_NUMBER      22

#define EVENT_IM              0
#define EVENT_UPLOAD_REQUEST  1
#define EVENT_DL_FINISHED     2
#define EVENT_USER_ONLINE     3
#define EVENT_USER_OFFLINE    4
#define EVENT_UPLOAD_START    5
#define EVENT_DOWNLOAD_START  6
#define EVENT_MESSAGE_REPLY   7
#define EVENT_DIRECT_BROWSE   8
#define EVENT_WHOIS_REQUEST   9
#define EVENT_FIRST_DOWNLOAD 10
#define EVENT_LAST_DOWNLOAD  11
#define EVENT_NUMBER         12
#define EVENT_MASK       0xFFFF

#define TEXT_UNKNOWN          0
#define TEXT_USER             1
#define TEXT_URL              2
#define TEXT_FILE             3
#define TEXT_SERVER           4
#define TEXT_CHANNEL          5

#define SEARCH_TIMEOUT       20
#define SEARCH_TO_IVAL     5000 // msec
#define SEARCH_UPDATE_IVAL 5000 // msec

#define SERVER_TIMEOUT      500

// server flags
#define SERVER_REMOVE      0x01
#define SERVER_PERMANENT   0x02
#define SERVER_IGNORE      0x04
#define SERVER_ONETIME     0x08
#define SERVER_REDIRECT    0x10

// server status
#define SERVER_OFFLINE        0
#define SERVER_CANCELED       1
#define SERVER_RESOLVING      2
#define SERVER_CONNECTING     3
#define SERVER_ONLINE         4

// network flags
#define NETWORK_NO_WINMX   0x02
#define NETWORK_MESSAGES   0x04
#define NETWORK_IGN_GLOBAL 0x08
#define NETWORK_CONNECTING 0x10
#define NETWORK_DONT_SHARE 0x20

// net group flags
#define NG_STARTUP_CONNECT    0x2
#define NG_NEVER_CONNECT      0x4

// network types
#define NETWORK_NAPSTER       1
#define NETWORK_GNUTELLA      2
#define NETWORK_EDONKEY       3
#define NETWORK_IRC           4

#define PRI_NONE              0
#define PRI_SHARE             1
#define PRI_DOWNLOAD          2
#define PRI_FRIEND            3

#define CMODE_TOPIC      0x0001 // nap irc
#define CMODE_REGISTERED 0x0002 // nap
#define CMODE_NOOUTSIDE  0x0004 //     irc
#define CMODE_SECRET     0x0008 //     irc
#define CMODE_PRIVATE    0x0010 // nap irc
#define CMODE_INVITE     0x0020 // nap irc
#define CMODE_MODERATED  0x0040 // nap irc
#define CMODE_REOP       0x0080 //     irc
#define CMODE_QUIET      0x0100 //     irc
#define CMODE_ANONYMOUS  0x0200 //     irc
#define CMODE_ALL        0x03ff //
#define CMODE_NUMBER         10
 
#define PATTERN_IGNORE      0
#define PATTERN_TEMPORARY   1
#define PATTERN_SAVE        2
#define PATTERN_SEARCH      3
#define PATTERN_TEMPLATE    4

#define LIST_HIGHLIGHT      0
#define LIST_FRIEND         1
#define LIST_ENEMY          2
#define LIST_IGNORE         3
#define LIST_BANREASON      4
#define LIST_NODOWNLOAD     5
#define LIST_AFKREASON      6
#define STRING_LIST_NO      7

#define BROWSER_NONE        0
#define BROWSER_NETSCAPE    1
#define BROWSER_MOZILLA     2
#define BROWSER_LYNX        3
#define BROWSER_W3M         4
#define BROWSER_OPERA       5
#define BROWSER_DILLO       6
#define BROWSER_GALEON      7
#define BROWSER_KONQUEROR   8
#define BROWSER_NO          9

#define PIPE_AWAY_LOG    0x01
#define PIPE_CHWALLOP    0x02
#define PIPE_WALLOP      0x04
#define PIPE_GLOBAL      0x08
#define PIPE_SERVER      0x10
#define PIPE_PRIVATE     0x20
#define PIPE_DOWNLOAD    0x40
#define PIPE_UPLOAD      0x80

#define NOPIPE_IGNORE    0x01
#define NOPIPE_DOWNLOAD  0x02
#define NOPIPE_PROTOCOL1 0x04
#define NOPIPE_PROTOCOL2 0x08
#define NOPIPE_UPLOAD    0x10

#define C_UNKNOWN           0
#define C_OTHER             1
#define C_WINMX_26          2
#define C_WINMX             3
#define C_LOPSTER_ADV       4

#define HOT_UNKNOWN     0x01
#define HOT_OFFLINE     0x02
#define HOT_ONLINE      0x03

#define TAB_ICON        0x01
#define TAB_TEXT        0x02

#define WHOIS_NONE      0x00
#define WHOIS_SHOW      0x01
#define WHOIS_TEXT      0x02

#define SPEED_NONE      0x00
#define SPEED_SHOW      0x01
#define SPEED_UPLOAD    0x02
#define SPEED_DOWNLOAD  0x04
#define SPEED_ALL       0x07

// Weasel75
// default values if loading fails
#define SPEED_RED       2048
#define SPEED_YELLOW    8196
#define SPEED_GREEN    30720
#define SPEED_RED2      1024
#define SPEED_YELLOW2   4096
#define SPEED_GREEN2   10240

#define G_SIZE            10
#define G_SIZE_ADD         2

#define TIME_NONE          0
#define TIME_HOUR_MIN      1
#define TIME_HOUR_MIN_SEC  2
#define TIME_BEATTIME      3

// mode for user popup
#define M_ONLINE           0
#define M_SEARCH           1
#define M_HOTLIST          2
#define M_DOWNLOAD         3
#define M_GLOBAL           4
#define M_WHOIS            5
#define M_TEXT             6
#define M_IGNORE           7
#define M_BROWSE           8
#define M_ACCESS           9
#define M_STRING_LIST     10
#define M_SUBSCRIPTION    11
#define M_UPLOAD          12
#define M_REPLY           13
#define M_SHARE           14

// gtk styles for some lopster widgets
#define STYLE_NUMBER       4
#define STYLE_TAB1         0
#define STYLE_TAB2         1
#define STYLE_LABEL        2
#define STYLE_PREF         3

// user status
#define STATUS_INACTIVE    0
#define STATUS_ACTIVE      1
#define STATUS_REMOTE      2
#define STATUS_CLOAKED     3
#define STATUS_LEECHED     4
#define STATUS_MUZZLED     5
#define STATUS_UNKNOWN     6

// major media types
#define MIME_NONE          0
#define MIME_MP3           1
#define MIME_AUDIO         2
#define MIME_VIDEO         3
#define MIME_APPLICATION   4
#define MIME_IMAGE         5
#define MIME_TEXT          6
#define MIME_SIZE          7

// debugging output control
//#define SHARE_DEBUG
//#define RESUME_DEBUG
//#define BROWSE_DEBUG
//#define GLOBAL_DEBUG
//#define SEARCH_DEBUG
//#define TRANSFER_DEBUG
//#define CONNECTION_DEBUG
#define PROTOCOL_DEBUG
//#define STAT_DEBUG

// server type
#define N_UNKNOWN          0
#define N_OPENNAP          1
#define N_OPENNAP_NG       2
#define N_SLAVANAP         3
#define N_UNUSED           4
#define N_IRC              5
#define N_NUMBER           6

// socket type
#define S_UNKNOWN          0
#define S_SHARE            1
#define S_BROWSE           2
#define S_DOWNLOAD         3
#define S_UPLOAD           4
#define S_SERVER           5
#define S_HTTP             6
#define S_DATA             7
#ifdef ENABLE_WHITE_BOARD
 #define S_WHITEBOARD       8
#endif

// exit mode
#define E_NONE             0
#define E_SAFE             1

// chat page type
#define P_CHANNEL          0
#define P_PRIVATE          1
#define P_PUBLIC           2
#define P_SERVER           3
#define P_OTHER            4

// transfer status
#define S_REQUESTED        0
#define S_CONNECTING       1
#define S_INFO             2
#define S_PART             3
#define S_FINISHED         4
#define S_DOWNLOADING      5
#define S_UPLOADING        6
#define S_TIMEOUT          7
#define S_REJECT           8
#define S_INCOMPLETE       9
#define S_CANCELED        10
#define S_WAITING         11
#define S_FIREWALL        12
#define S_CONERROR        13
#define S_QUEUED          14
#define S_REMOTE          15
#define S_UNAVAILABLE     16
#define S_RESUME_ERR      17
#define S_DELETE          18
#define S_IO              19
#define S_NUMBER          20

// transfer types
#define T_UNKNOWN          0
#define T_DOWNLOAD         1
#define T_UPLOAD           2

#define TRANSFER_HISTORY_TIME         30	// seconds

// transfer major types
#define T_NONE             0	// inactive
#define T_CURRENT          1	// connecting..downloading
#define T_STOPPED          2	// active, but stopped (queue)
#define T_TRANSFER         3	// transfering

// download retry flags
#define RETRY_TIMEOUT         0x01
#define RETRY_REJECT          0x02
#define RETRY_INCOMPLETE      0x04
#define RETRY_CONERROR        0x08
#define RETRY_REMOTE          0x10

// download remove flags
#define REMOVE_D_FINISHED    0x001

// upload remove flags
#define REMOVE_U_FINISHED    0x001
#define REMOVE_U_ABORTED     0x002

// search status
#define SEARCH_ACTIVE            0
#define SEARCH_QUEUED            1
#define SEARCH_FINISHED          2

// destination for search
#define DEST_NAPSTER          0x01
#define DEST_BROWSE           0x02
#define DEST_LIBRARY          0x04
#define DEST_SEARCH           0x08

#define RESUME_DEACTIVATED    0x01
#define RESUME_FINISHED       0x02
#define RESUME_INACTIVE       (RESUME_DEACTIVATED|RESUME_FINISHED)
#define RESUME_FREE_SEGMENT   0x04
#define RESUME_DONT_MSOURCE   0x08

// user level
typedef enum {
  L_LEECH,
  L_USER,
  L_MOD,
  L_ADMIN,
  L_ELITE
} user_level_t;

typedef struct _geometry_t geometry_t;
typedef struct _word_info_t word_info_t;
typedef struct _text_info_t text_info_t;
typedef struct _chat_page_t chat_page_t;
typedef struct _afk_t afk_t;
typedef struct _clone_t clone_t;
typedef struct _client_t client_t;
typedef struct _suffix_t suffix_t;
typedef struct _mime_t mime_t;
typedef struct _user_t user_t;
typedef struct _link_t link_t;
typedef struct _network_t network_t;
typedef struct _limit_t limit_t;
typedef struct _option_t option_t;
typedef struct _status_t status_t;
typedef struct _file_t file_t;
typedef struct _pix_t pix_t;
typedef struct _bandwidth_t bandwidth_t;
typedef struct _napigator_t napigator_t;
typedef struct _global_t global_t;
typedef struct _download_t download_t;
typedef struct _upload_t upload_t;
typedef struct _share_t share_t;
typedef struct _resume_t resume_t;
typedef struct _user_info_t user_info_t;
typedef struct _search_t search_t;
typedef struct _search_pattern_t search_pattern_t;
typedef struct _net_command_t net_command_t;
typedef struct _server_t server_t;
typedef struct _net_t net_t;
typedef struct _socket_t socket_t;
typedef struct _style_t style_t;
typedef struct _scheme_t scheme_t;
typedef struct _user_timestamp_t user_timestamp_t;
typedef struct _statistic_t statistic_t;
typedef struct _band_t band_t;
typedef struct _hot_t hot_t;
typedef struct _whois_t whois_t;
typedef struct _speed_t speed_t;
typedef struct _file_tips_t file_tips_t;
typedef struct _access_t access_t;
typedef struct _browse_t browse_t;
typedef struct _file_tree_t file_tree_t;
typedef struct _subscription_t subscription_t;
typedef struct _lib_node_t lib_node_t;
typedef struct _library_t library_t;
typedef struct _shared_folder_t shared_folder_t;
typedef struct _channel_entry_t channel_entry_t;
typedef struct _server_net_t server_net_t;
typedef struct _transfer_data_t transfer_data_t;
typedef struct _exec_t exec_t;
typedef struct _file_segment_t file_segment_t;
typedef struct _search_info_t search_info_t;
typedef struct _bannetworks_t bannetworks_t;
typedef struct _net_group_t net_group_t;
typedef struct _download_layout_t download_layout_t;
typedef struct _browse_node_t browse_node_t;
typedef struct _file_node_t file_node_t;
typedef struct _sarray_t sarray_t;

struct _subscription_t {
  char* user;
  int friend_while_subs;
  GList* files;
};

struct _buffer_t {
  char *data;            /* allocated data */
  int   datasize;        /* total bytes used in `data' */
  int   datamax;         /* size of allocated memory block */
  int   consumed;        /* already processed data */
};

#define FILE_TREE(obj) ((file_tree_t*)obj)
#define BROWSE_TREE(obj) ((browse_t*)obj)
#define LIB_TREE(obj) ((library_t*)obj)

struct _file_tree_t {
  char *name;
  char *description;
  time_t last_refreshed;
  double fsi[MIME_SIZE+1][3+1];
  int fci[MIME_SIZE+1][3+1];
  GtkWidget *main_link;
  GtkCTree *ctree;
  GtkCList *clist;
  GtkWidget* label;
  GtkWidget *progress;
  GtkWidget* resize_cont;
  GtkWidget* button[2];
  GtkWidget* blabel[2];

  file_node_t* files;
  file_node_t* current_node;
  int show_mime;
  int show_time;
  int mark_timeout;
  int search_timeout;

  char* search_token;
  GtkWidget* search_entry;

  // functions
  file_node_t* (*node_new)(char* name);
  int  (*node_status)(file_tree_t* tree, file_node_t* node);
  void (*update_user)(file_tree_t* tree);
  void (*node_free)(file_node_t* node);
  void (*node_init)(file_node_t* node);
  time_t (*next_mark)(file_tree_t* tree, file_node_t* node);
  int signal[7];
};

struct _library_t {
  file_tree_t info;

  int status;
  time_t mark;
  GList *shared_folder;
  FILE* fd;
  int timeout;
};

struct _access_t {
  char *name;
  time_t last;
  int accesses;
  GList **access_list;
  access_t* parent;
  double temp;
  double done;
};

struct _speed_t {
  char *user;
  net_t* net;
  int speed;
  time_t sent;
};

struct _whois_t {
  int flag;
  time_t received;
  time_t sent;
  int online;
  int advanced;
  int yourself;

  char *user;
  user_level_t level;
  time_t online_time;
  char *channels;
  char *status;
  int shared;
  int downloads;
  int uploads;
  int link;
  char *client;

  // advanced
  int total_down;
  int total_up;
  char *ip;
  int server_port;
  int data_port;
  char *email;
  char* where;
  net_t* net;
};

struct _geometry_t
{
  int x;
  int y;
  int width;
  int height;
};

struct _word_info_t 
{
  char* word;
  int type;
  void* data;
  gint start_pos;
  gint length;
};

struct _text_info_t {
  word_info_t** info;
  int alloc;
  int pos;
};

struct _server_net_t  {
  server_t* server;
  net_t* net;
};

struct _chat_page_t {
  char* name;
  char* vname;
  GtkWidget *window;		// window, if present
  GtkWidget *header;		// topic text
  GtkWidget *wallop;		// wallop text
  GtkWidget *main;		// main text
  GtkWidget *tlabel;		// label text widget
  GtkWidget *tmain;		// label widget
  GtkWidget *tclose;		// label close button
  GtkWidget *online;		// online clist
  GtkWidget *no;		// online number widget
  GtkWidget *toplevel;		// toplevel widget
  GtkWidget *paned;		//
  int snap;
  int modified;
  int timeout;
  int type;
  int lines;
  int chmode;
  int limit;
  user_level_t level;
  net_t* net;
  char active;
  char close_on_part;
  char opped;
  char part_request;
  char join_request;
};

struct _afk_t {
  char *message;
  time_t since;
  int auto_afk;
  int warn_afk;
};

struct _clone_t
{
  GList *nicks;
  char *ip;
};

struct _client_t
{
  char *info;
  int logins;
  int cnt;
};

struct _suffix_t
{
  char *suffix;
  char *application;
  int as_mp3;
};

struct _mime_t
{
  char *download;
  GList *suffixes;
};

struct _user_t {
  char username[100];
  char password[100];
  user_level_t level;
  int status;
};

struct _link_t {
  char *server;
  GList *links;
  char *ping;
};

struct _network_t {
  int port;
  int firewall;
  int transfer_delay;
  int transfer_timeout_up;
  int transfer_timeout_down;
};

struct _limit_t {
  int max_searches;
  int max_downloads;
  int max_uploads;
  int max_large;
  int large_size;
  int default_uploads;
  int default_downloads;
  int cur_uploads;
  int cur_downloads;
  int cur_large;
  int cur_real_downloads;
  int cur_real_uploads;
  int download_percent;
  int min_segment_size;
  int max_seek_add;
  int download_abort_number;
  unsigned long download_abort_limit;
};

struct _option_t {
  unsigned char show_joins;
  unsigned char show_parts;
  unsigned char real_ignore;
  unsigned char parse_colors;
  unsigned char strip_colors;
  unsigned char timestamps;
  int dummy_md5;

  char colored_nicks;
  char colored_nicks2;
  char channel_rejoin;
  int allow_dcc;
  int check_lib_for_download;
  int auto_search;
  char confirm_delete;
  int auto_resume;
  int ping_search;
  int search_show_folder;

  int recent_timeout;
  char log_expire;
  int logging;
  int auto_retry;
  int dl_autoremove;
  int ul_autoremove;
  int resume_abort[4];
  unsigned int popup_create;
  unsigned int server_motd;
  int tab_style;
  int access_timeout;
  int access_save;
  int check_version;
  int piping;
  int no_piping;
  int resume_timeout;
  int access_transferring;
  int rejoin_when_kicked;
  int time_display;
  char *config_dir;
  char *config_file;
  int browser;
  int retry_timeout[6];
  int upload_priority[4];
  //Weasel75
  int down_speed[3];
  int up_speed[3];
  int emulate_winmx;
  int lib_mark_val;
  int graph_smooth[2];
  int graph_interval[2];
  int graph_mode[2];
  int graph_show[2];
  int use_iconv;
  char *dest_codeset;
  int search_timeout;
  int autoconnect_sendqueue_limit;
  int max_chat_buffer;
};

struct _status_t {
  char exiting;
  char rc_read;
  char search_read;
  char access_read;
  char geometry_read;
};

struct _file_t {
  char *longname;		// local long name
  char *winname;		// web long name
  char *shortname;		// local short name
  char *filename;		// local file name
  char *user;
  char *md5;
  net_t* net;
  unsigned long ip;		// for search response
  long size;
  int bitrate;
  int frequency;
  int duration;
  int ping;
  unsigned char linespeed;
  unsigned char vbr;
  unsigned char visible;
  unsigned char media_type;
};

struct _file_tips_t {
  GtkWidget *widget;
  GtkWidget *tips;
  file_t *file;
  int row;
  int col;
  int timeout;
};

struct _statistic_t {
  double incomplete[2];
  double total[2];
  band_t *band[2];
  int access_format;
  access_t *file_access;
};

struct _pix_t {
  GdkPixmap *sgray;
  GdkBitmap *sgrayb;
  GdkPixmap *sgreen;
  GdkBitmap *sgreenb;
  GdkPixmap *syellow;
  GdkBitmap *syellowb;
  GdkPixmap *sred;
  GdkBitmap *sredb;
  
  GdkPixmap *folder;
  GdkBitmap *folderb;
  GdkPixmap *folder_open;
  GdkBitmap *folder_openb;
  GdkPixmap *user1;
  GdkBitmap *user1b;
  GdkPixmap *user2;
  GdkBitmap *user2b;
  GdkPixmap *ignore;
  GdkBitmap *ignoreb;
  GdkPixmap *enemy;
  GdkBitmap *enemyb;
  GdkPixmap *enemy2;
  GdkBitmap *enemy2b;
  GdkPixmap *friend;
  GdkBitmap *friendb;
  GdkPixmap *dummy;
  GdkBitmap *dummyb;
  GdkPixmap *share_none;
  GdkBitmap *share_noneb;
  GdkPixmap *share_part;
  GdkBitmap *share_partb;
  GdkPixmap *share_all;
  GdkBitmap *share_allb;
  GdkPixmap *server_con;
  GdkBitmap *server_conb;
  GdkPixmap *server_ign;
  GdkBitmap *server_ignb;
};

struct _bandwidth_t {
  GdkPixmap* pixmap;
  long limit;
  long value;
  long maxval;
  GtkWidget *area;
  GtkWidget *label_max;
  GtkWidget *label_cur;
  long bytes[2];
};

struct _napigator_t
{
  int use_proxy;
  char *proxy_url;
  int proxy_port;
};

typedef struct {
  char* user;
  net_t* net;
} net_user_t;

struct _download_layout_t {
  char ctree_position[4];
  char transfer_position[4];
};

struct _global_t {
  //wins
  GtkWidget *progressbar;
  GtkWidget *win;
  GtkWidget *connect_win;
  GtkWidget *whois_win;
  GtkWidget *options_win;
  GtkWidget *ban_win;
  GtkWidget *usermode_win;
  GtkWidget *client_win;
  GtkWidget *user_win;
  GtkWidget *socket_win;
  GtkWidget *splash_win;
  GtkWidget *string_win;
  GtkWidget *file_win;
  GtkWidget *queue_win;
  GtkWidget *subscription_win;

  char* username;
  char* password;
  char* email;
  int linespeed;
  int usermode;

  time_t current_time;
  socket_t *upload_socket;	// listen socket file transfer
  mime_t mimetype[MIME_SIZE];
  status_t status;
  pix_t pix;			// pix for intern use

  GList *string_list[STRING_LIST_NO];
  GList *commands;		// the list of commands
  GList *chat_history;		// history of input line
  int history_pos;
  GList *hotlist;		// users in hot list
  GList *incomplete;		// list of incomplete downloads
  GList *client_list;
  GList *clones;
  GList *search_pattern;
  GList *searches;
  GList *chat_pages;
  chat_page_t *current_page;
  GList *browses;
  GList *sockets;

  bandwidth_t down_width;
  bandwidth_t up_width;
  int popup_row;
  GtkWidget *popup_list;
  int timer;
  afk_t afk;
  net_user_t user_reply;
  chat_page_t* reply_page;
  char *session_start;
  time_t start_time;
  GList *server_links;
  GtkStyle *styles[STYLE_NUMBER];
  GdkColor color_table[16];
  // some temp geometry info
  geometry_t geometry[G_SIZE];
  int extra_win;
  char *incomplete_path;
  int search_width[9];
  int search_show[9];
  int browse_width[5];
  int browse_show[5];
  int channel_width[5];
  int channel_show[5];
  int online_width[3];
  int online_show[3];
  int server_paned;
  int channel_paned;
  int browse_paned;

  //options
  network_t network;		// network options
  limit_t limit;		// limit options
  option_t options;		// other options
  statistic_t statistic;
  napigator_t napigator;	// napigator options

  char *rainbow_colors;
  GList *allowed_ports;
  scheme_t *scheme;
  char *auto_save;
  GList *pings;
  char *ping_command;
  GList *appearance;
  GList *userstamp;
  GList *whois_requests;
  GList *speed_requests;
  GList *userinfo;
  int reconnect_timer;
  int resume_timer;
  unsigned long my_ip;
  int path_warned;
  GList* subscriptions;
#ifdef ENABLE_WHITE_BOARD
  GList* whiteboards;
#endif
  library_t* lib;
  GList* net_groups;
  GList* net_active;
  int server_check;
  int resume_saver;
  char *external_handler;
  unsigned int external_events;
  GList* bannet;
  download_layout_t dl_layout;
  int lnumber;
  GList* urls;
};

struct _user_info_t {
  char *nick; 
  char *last_server;
  // up/download
  int real_cur[2];   // dl, ul
  int cur[2];   // dl, ul
  int max[2];
  long bytes[2];
  long limit[2];
  int ignore_global[2];
  time_t timestamp;
  time_t last_seen;
  // additional upload
  int shares;
  int remotes;
  unsigned char linespeed;
  unsigned char client;
};

struct _transfer_data_t {
  user_info_t *user_info;
  double rate;
  int timeleft;
  time_t start_time;
  time_t stop_time;
  int status;
  int is_dcc;
  int transferred;
  char needs_update;

  long history[TRANSFER_HISTORY_TIME];
  int hist_cnt;
  int hist_pos;
};

struct _download_t {
  transfer_data_t* data;
  resume_t *resume;
  int queue;
  GList* csegment;
  int fd;
  GList* nets;
  file_t* file;
#ifdef ADVANCED_CONNECTION
  char advanced;
#endif
};

struct _share_t {
  transfer_data_t* data;
  net_user_t nu;
  buffer_t* buffer;
};

struct _browse_t {
  file_tree_t info;

  int status;
  net_t* net;
  user_info_t* userinfo;
  buffer_t* buffer;
};

struct _upload_t {
  transfer_data_t* data;
  FILE* fd;
  file_segment_t* segment;
  net_user_t nu;
  access_t* access;
  GtkCTreeNode* node;   // node in access list
  char offline;
  file_t* file;
#ifdef ADVANCED_CONNECTION
  char advanced;
#endif
};

struct _resume_t {
  char *filename;
  char *dirname;
  long comp_size;
  long inc_size;
  search_t *search;
  char *search_string;
  int active;
  int flags;
  time_t last_access;
  GList *downloads;
  int tree_no;
  GtkCTreeNode* node;
  int is_dcc;
  GList* parts;
  char needs_update;
};

struct _search_pattern_t {
  char *name;
  char *include;
  char *exclude;
  int max_results;
  unsigned char media_type;
  int destination;
  int bitrate_lo;
  int bitrate_hi;
  int freq_lo;
  int freq_hi;
  int speed_lo;
  int speed_hi;
  long size_lo;
  long size_hi;
  int duration_lo;
  int duration_hi;
  int id;
  int level;
};

struct _search_t {
  search_pattern_t *pattern;
  sarray_t* results;
  int type;
  int resume;
  int local;
  gint updater;
  void *link;
  GList* net_info;
  int invisible;
};

struct _socket_t {
  unsigned long ip_long;
  gint16 port;
  int fd;
  int input;
  int output;
  int timer;
  int cnt;			// intern counter
  int max_cnt;			// max count for timeout
  void *data;
  int type;

#ifdef HAVE_ZLIB
  z_stream *zin;		/* input stream decompressor */
  z_stream *zout;		/* output stream compressor */
  buffer_t *zbuf;		/* temporary decompression buffer */
  buffer_t *zcom;		/* temporary compression buffer */
#endif

};

struct _server_t {
  char *address;
  unsigned long ip;
  int port;
  int users, files, gigs;
  int linespeed;
  int flags;
  int status;
  int timeout;
  time_t last_resolved;
  net_t* net;
};

struct _net_t {
  user_t user;
  char* name;
  GList* servers;
  server_t* active_server;
  GList* auto_join;
  int flags;
  int type;
  int subtype;
  int major, minor, micro;
  char* codeset;
  net_group_t* group;

  buffer_t* out_buffer;
  buffer_t* in_buffer;
  socket_t* socket;
  GList* queued_searches;
  GList* active_searches;
  time_t search_stamp;
  int search_cnt;     // counter for searches per minute
  int max_searches_pm;// max searches per minute allowed
  int cur_searches;   // currently active searches
  int max_searches;   // max concurrent searches allowed
  int skip_search_end;// true if we skip next search_end tag

  gint16 c_type;
  gint16 c_length;
  char* c_message;
  link_t *links;
  GList* temp_list;
  GList *logs;			// list of open logfiles

#ifdef HAVE_ZLIB
  int compress;
#endif
  double sent_compressed;
  double sent_uncompressed;
  double rcvd_compressed;
  double rcvd_uncompressed;

  int  (*success)        (net_t* net);
  int  (*consume_command)(net_t* net);
  void (*login)          (socket_t* socket);
  void (*command_pack)   (net_t* net, gint16 type, va_list ap);
  void (*channel_setup)  (chat_page_t* page);
  void (*handle_command) (net_t* net);
};

struct _net_command_t {
  gint16 type;
  unsigned char *data;
};

struct _scheme_t
{
  char *name;
  GList *colors;		// the color scheme
  char *server_prefix;
  char *client_prefix;
  char *join_prefix;
  char *part_prefix;
  GtkStyle* style;
};

struct _style_t {
  char *name;
  char *n_fore;
  char *n_back;
  char *n_font;
  GdkFont *font;
  GdkColor *fore;
  GdkColor *back;
};

struct _user_timestamp_t {
  char *user;
  struct timeval tv;
};

struct _hot_t {
  char *user;
  char *description;
  int speed;
  int visible;
  GList* nets;
};

struct _shared_folder_t {
  int type;
  char* name;
};

typedef struct {
  struct dirent* dent;
  char* folder;
  DIR* dir;
} dir_pos_entry_t;

typedef struct {
  library_t* lib;
  int type;
  GList* stack;
  char* base;
} dir_position_t;

struct _channel_entry_t {
  char* name;
  char* topic;
  int limit;
  int level;
  int online;
  net_t* net;
};

typedef struct {
  char* user;
  int files;
  int speed;
  int flags;
  chat_page_t* page;
} channel_user_t;

typedef struct {
  char* net;
  char* server1;
  char* server2;
  time_t link_time;
} server_link_t;

struct _exec_t {
  char *command;
  char *who;
  net_t* net;
  chat_page_t* page;
  void (*exit_cb)(void *data, int status);
  void *exit_cb_data;
  int verbose;
  int fd;
  int fd_watch;
  int output;
  int id;
  pid_t pid;
  int timerid;
  buffer_t* buffer;
};

#define PART_CHECK_ERROR 0x01

struct _file_segment_t {
  int start;
  int size;
  int stop;
  int flags;
  int merge_cnt;
  socket_t* socket;
};

struct _search_info_t {
  net_t* net;
  int timeout;
  int last_result;
  int timer;
  int active;
};

struct _bannetworks_t {
  unsigned long ip_from;
  unsigned long ip_to;
};

struct _net_group_t {
  char* name;
  int flags;
  int how_many;
  GList* nets;
};

#define FILE_NODE(obj) ((file_node_t*)obj)
#define LIB_NODE(obj) ((lib_node_t*)obj)
#define BROWSE_NODE(obj) ((browse_node_t*)obj)

struct _file_node_t {
  char* name;
  file_node_t* parent;
  file_node_t* child;
  file_node_t* next;
  file_node_t* prev;
  file_t* file;
  double fsi[MIME_SIZE+1][3+1];
  int fci[MIME_SIZE+1][3+1];
  int flags;
};

struct _lib_node_t {
  file_node_t info;
  
  GList* nets;      // list of server already shared on
  time_t mod_time;
};

struct _browse_node_t {
  file_node_t info;
  
  time_t first_seen;
  time_t last_seen;
};

#endif
