/* Generated by GOB (v2.0.11) on Thu Aug 25 02:26:27 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "loqui-socket-ipmsg.gob"

/*
 * libloqui -- Chat/IM client library for GLib <http://loqui.good-day.net/>
 * Copyright (C) 2004 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 30 "loqui-socket-ipmsg.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "loqui-socket-ipmsg.h"

#include "loqui-socket-ipmsg-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "loqui-socket-ipmsg.gob"

#include <libloqui-intl.h>
#include "loqui-utils.h"

#include "ipmsg_packet.h"
#include <gnet.h>
#include "ipmsg.h"

#include <stdlib.h>
#include <locale.h>
#include "loqui-static-core.h"
#include "loqui-account-ipmsg.h"
#include "loqui-receiver-ipmsg.h"

#line 66 "loqui-socket-ipmsg.c"

#line 45 "loqui-socket-ipmsg.gob"

#define SELF_GET_ACCOUNT(self) (self->account)
#define SELF_GET_ACCOUNT_IPMSG(self) (LOQUI_ACCOUNT_IPMSG(SELF_GET_ACCOUNT(self)))

#line 73 "loqui-socket-ipmsg.c"
/* self casting macros */
#define SELF(x) LOQUI_SOCKET_IPMSG(x)
#define SELF_CONST(x) LOQUI_SOCKET_IPMSG_CONST(x)
#define IS_SELF(x) LOQUI_IS_SOCKET_IPMSG(x)
#define TYPE_SELF LOQUI_TYPE_SOCKET_IPMSG
#define SELF_CLASS(x) LOQUI_SOCKET_IPMSG_CLASS(x)

#define SELF_GET_CLASS(x) LOQUI_SOCKET_IPMSG_GET_CLASS(x)

/* self typedefs */
typedef LoquiSocketIPMsg Self;
typedef LoquiSocketIPMsgClass SelfClass;

/* here are local prototypes */
static void loqui_socket_ipmsg_init (LoquiSocketIPMsg * o) G_GNUC_UNUSED;
static void loqui_socket_ipmsg_class_init (LoquiSocketIPMsgClass * c) G_GNUC_UNUSED;
static gboolean loqui_socket_ipmsg_watch_in_cb (GIOChannel * ioch, GIOCondition condition, Self * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_watch_in_cb loqui_socket_ipmsg_watch_in_cb
#define self_bind loqui_socket_ipmsg_bind
#define self_unbind loqui_socket_ipmsg_unbind
#define self_send_packet_with_inetaddr loqui_socket_ipmsg_send_packet_with_inetaddr
#define self_send_packet loqui_socket_ipmsg_send_packet
#define self_send_packet_to_default loqui_socket_ipmsg_send_packet_to_default
#define self_get_current_port loqui_socket_ipmsg_get_current_port
#define self_new loqui_socket_ipmsg_new
GType
loqui_socket_ipmsg_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LoquiSocketIPMsgClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) loqui_socket_ipmsg_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LoquiSocketIPMsg),
			0 /* n_preallocs */,
			(GInstanceInitFunc) loqui_socket_ipmsg_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LoquiSocketIPMsg", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LoquiSocketIPMsg *)g_object_new(loqui_socket_ipmsg_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LoquiSocketIPMsg * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LoquiSocketIPMsg *
GET_NEW_VARG (const char *first, ...)
{
	LoquiSocketIPMsg *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LoquiSocketIPMsg *)g_object_new_valist (loqui_socket_ipmsg_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::dispose"
	LoquiSocketIPMsg *self G_GNUC_UNUSED = LOQUI_SOCKET_IPMSG (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#define udpsock (self->_priv->udpsock)
#define VAR udpsock
	{
#line 52 "loqui-socket-ipmsg.gob"
	
		self_unbind(self);
	}
#line 161 "loqui-socket-ipmsg.c"
	memset(&udpsock, 0, sizeof(udpsock));
#undef VAR
#undef udpsock
#line 56 "loqui-socket-ipmsg.gob"
	if(self->_priv->inetaddr_broadcast) { gnet_inetaddr_unref ((gpointer) self->_priv->inetaddr_broadcast); self->_priv->inetaddr_broadcast = NULL; }
#line 167 "loqui-socket-ipmsg.c"
#line 58 "loqui-socket-ipmsg.gob"
	if(self->_priv->codeconv) { g_object_unref ((gpointer) self->_priv->codeconv); self->_priv->codeconv = NULL; }
#line 170 "loqui-socket-ipmsg.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::finalize"
	LoquiSocketIPMsg *self G_GNUC_UNUSED = LOQUI_SOCKET_IPMSG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
loqui_socket_ipmsg_init (LoquiSocketIPMsg * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,LoquiSocketIPMsgPrivate);
}
#undef __GOB_FUNCTION__
static void 
loqui_socket_ipmsg_class_init (LoquiSocketIPMsgClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LoquiSocketIPMsgPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 65 "loqui-socket-ipmsg.gob"
static gboolean 
loqui_socket_ipmsg_watch_in_cb (GIOChannel * ioch, GIOCondition condition, Self * self)
#line 213 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::watch_in_cb"
{
#line 66 "loqui-socket-ipmsg.gob"
	
#define MAXBUF 65536
		gchar buf[MAXBUF+1];
		gsize len;
		IPMsgPacket *packet;
		GInetAddr *addr;
		gchar *local, *local_group;
		gint len2zero;
		LoquiAccount *account;
		GString *string;
		GError *error = NULL;

		account = SELF_GET_ACCOUNT(self);

		len = gnet_udp_socket_receive(selfp->udpsock, buf, MAXBUF, &addr);
		if (len < 0) {
			loqui_account_warning(account, "Error: receiving.");
			selfp->in_watch = 0;
			return FALSE;
		} else if (len == 0) {
			loqui_account_warning(account, "No characters is arrived.");
			return TRUE;
		}
		buf[len] = '\0';

		/* group message exists after '\0' */
		if ((local = loqui_codeconv_to_local(selfp->codeconv, buf, &error)) == NULL) {
			loqui_account_warning(account, _("Failed to convert codeset: %s"), error->message);
			g_error_free(error);
			return TRUE;
		}
		string = g_string_new(local);
		g_free(local);

		len2zero = strlen(buf);
		if (len2zero + 1 < len) {
			if ((local_group = loqui_codeconv_to_local(selfp->codeconv, buf + len2zero + 1, &error)) == NULL) {
				loqui_account_warning(account, _("Failed to convert codeset of group: %s"), error->message);
				g_error_free(error);
				g_string_free(string, TRUE);
				return TRUE;
			}
			g_string_append_c(string, '\0');
			g_string_append(string, local_group);
			g_free(local_group);
		}

		packet = ipmsg_packet_parse(string->str, string->len);
		if (!packet) {
			loqui_account_warning(account, _("Invalid packet: '%s'"), string->str);
			g_string_free(string, TRUE);
			return TRUE;
		}
		g_string_free(string, TRUE);

		ipmsg_packet_set_inetaddr(packet, addr);
		gnet_inetaddr_unref(addr);
		if (loqui_core_get_show_msg_mode(loqui_get_core())) {
			gchar *tmp = ipmsg_packet_inspect(packet);
			loqui_account_print_communication(SELF_GET_ACCOUNT(self), TRUE, tmp);
			g_free(tmp);
		}

		loqui_receiver_ipmsg_handle(LOQUI_RECEIVER_IPMSG(SELF_GET_ACCOUNT(self)->receiver), packet);
		g_object_unref(packet);

		return TRUE;
	}}
#line 286 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__

#line 135 "loqui-socket-ipmsg.gob"
gboolean 
loqui_socket_ipmsg_bind (LoquiSocketIPMsg * self)
#line 292 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::bind"
#line 135 "loqui-socket-ipmsg.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 135 "loqui-socket-ipmsg.gob"
	g_return_val_if_fail (LOQUI_IS_SOCKET_IPMSG (self), (gboolean )0);
#line 299 "loqui-socket-ipmsg.c"
{
#line 135 "loqui-socket-ipmsg.gob"
	
		GIOChannel *ioch;

		selfp->udpsock = gnet_udp_socket_new_with_port(IPMSG_DEFAULT_PORT);

		if (!selfp->udpsock)
			return FALSE;

		ioch = gnet_udp_socket_get_io_channel(selfp->udpsock);
		selfp->in_watch = g_io_add_watch(ioch, G_IO_IN | G_IO_ERR | G_IO_HUP | G_IO_NVAL,
						(GIOFunc) self_watch_in_cb, self);

		selfp->inetaddr_broadcast = gnet_inetaddr_new_nonblock("255.255.255.255", IPMSG_DEFAULT_PORT);

		return TRUE;
	}}
#line 318 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__

#line 152 "loqui-socket-ipmsg.gob"
void 
loqui_socket_ipmsg_unbind (LoquiSocketIPMsg * self)
#line 324 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::unbind"
#line 152 "loqui-socket-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 152 "loqui-socket-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SOCKET_IPMSG (self));
#line 331 "loqui-socket-ipmsg.c"
{
#line 152 "loqui-socket-ipmsg.gob"
	
		if (!selfp->udpsock)
			return;

		if (selfp->in_watch) {
			g_source_remove(selfp->in_watch);
			selfp->in_watch = 0;
		}

		gnet_udp_socket_delete(selfp->udpsock);
		selfp->udpsock = NULL;
	}}
#line 346 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__

#line 164 "loqui-socket-ipmsg.gob"
void 
loqui_socket_ipmsg_send_packet_with_inetaddr (LoquiSocketIPMsg * self, IPMsgPacket * packet, GInetAddr * inetaddr)
#line 352 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::send_packet_with_inetaddr"
#line 164 "loqui-socket-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 164 "loqui-socket-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SOCKET_IPMSG (self));
#line 359 "loqui-socket-ipmsg.c"
{
#line 164 "loqui-socket-ipmsg.gob"
	
		gchar *buf, *serv_str;
		gint len;
		GError *error = NULL;

		if (!selfp->udpsock)
			return;

		if ((buf = ipmsg_packet_to_string(packet, &len)) == NULL) {
			g_warning("Failed to send a packet.");
			return;
		}

		if ((serv_str = loqui_codeconv_to_server(selfp->codeconv, buf, &error)) == NULL) {
			loqui_account_warning(SELF_GET_ACCOUNT(self), "Failed to convert codeset(%s): %s.", error->message, buf);
			g_error_free(error);
			g_free(buf);
			return;
		}
		g_free(buf);

		gnet_udp_socket_send(selfp->udpsock, serv_str, len, inetaddr);

		if (loqui_core_get_show_msg_mode(loqui_get_core())) {
			gchar *tmp = ipmsg_packet_inspect(packet);
			loqui_account_print_communication(SELF_GET_ACCOUNT(self), FALSE, tmp);
			g_free(tmp);
		}

		g_free(serv_str);
	}}
#line 393 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__

#line 196 "loqui-socket-ipmsg.gob"
void 
loqui_socket_ipmsg_send_packet (LoquiSocketIPMsg * self, IPMsgPacket * packet, const gchar * ip_addr, gint port)
#line 399 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::send_packet"
#line 196 "loqui-socket-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 196 "loqui-socket-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SOCKET_IPMSG (self));
#line 406 "loqui-socket-ipmsg.c"
{
#line 196 "loqui-socket-ipmsg.gob"
	
		GInetAddr *inetaddr;

		inetaddr = gnet_inetaddr_new_nonblock(ip_addr, port);
		self_send_packet_with_inetaddr(self, packet, inetaddr);
		gnet_inetaddr_unref(inetaddr);
	}}
#line 416 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__

#line 204 "loqui-socket-ipmsg.gob"
void 
loqui_socket_ipmsg_send_packet_to_default (LoquiSocketIPMsg * self, IPMsgPacket * packet)
#line 422 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::send_packet_to_default"
#line 204 "loqui-socket-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 204 "loqui-socket-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SOCKET_IPMSG (self));
#line 429 "loqui-socket-ipmsg.c"
{
#line 204 "loqui-socket-ipmsg.gob"
	
		g_return_if_fail(selfp->inetaddr_broadcast);

		self_send_packet_with_inetaddr(self, packet, selfp->inetaddr_broadcast);
	}}
#line 437 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__

#line 224 "loqui-socket-ipmsg.gob"
gint 
loqui_socket_ipmsg_get_current_port (LoquiSocketIPMsg * self)
#line 443 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::get_current_port"
#line 224 "loqui-socket-ipmsg.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 224 "loqui-socket-ipmsg.gob"
	g_return_val_if_fail (LOQUI_IS_SOCKET_IPMSG (self), (gint )0);
#line 450 "loqui-socket-ipmsg.c"
{
#line 224 "loqui-socket-ipmsg.gob"
	
		if (!selfp->udpsock)
			return 0;

		return gnet_inetaddr_get_port(gnet_udp_socket_get_local_inetaddr(selfp->udpsock));
	}}
#line 459 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__

#line 231 "loqui-socket-ipmsg.gob"
LoquiSocketIPMsg * 
loqui_socket_ipmsg_new (LoquiAccount * account)
#line 465 "loqui-socket-ipmsg.c"
{
#define __GOB_FUNCTION__ "Loqui:Socket:IPMsg::new"
{
#line 232 "loqui-socket-ipmsg.gob"
	
		Self *self;

		self = GET_NEW;
		self->account = account;

		selfp->codeconv = loqui_codeconv_new();
		loqui_codeconv_set_table(selfp->codeconv, loqui_protocol_get_codeconv_table(loqui_account_get_profile(account)->protocol));
		loqui_codeconv_set_mode(selfp->codeconv, LOQUI_CODECONV_MODE_AUTOMATIC);
		g_assert(loqui_codeconv_update(selfp->codeconv, NULL));

		return self;
	}}
#line 483 "loqui-socket-ipmsg.c"
#undef __GOB_FUNCTION__
