#!/usr/bin/env python

# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import sys

from shutil import move
from os.path import join, dirname

from lottanzb.core import App
from lottanzb.util import _

App().load_config()

success = sys.argv[1] == "SUCCESS"
archive_name = sys.argv[2]
dest_dir = sys.argv[3]
elapsed_time = sys.argv[4]

#if len(sys.argv) == 6:
#	par_message = sys.argv[5] 

separator = App().config.plugins.categories.separator

try:
    category, name = archive_name.split(separator)
except ValueError:
    pass
else:
    if not success:
        category = _("Failed")
    
    move(dest_dir, join(dirname(dest_dir), category, name))
