"""SCons.Tool.ifort

Tool-specific initialization for newer versions of the Intel Fortran Compiler
for Linux. 

There normally shouldn't be any need to import this module directly.
It will usually be imported through the generic SCons.Tool.Tool()
selection method.

"""

#
# Copyright (c) 2001, 2002, 2003, 2004 The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

__revision__ = "/home/scons/scons/branch.0/branch.96/baseline/src/engine/SCons/Tool/ifort.py 0.96.91.D001 2005/09/08 09:14:36 knight"

import SCons.Defaults

import fortran

def generate(env):
    """Add Builders and construction variables for ifort to an Environment."""
    # ifort supports Fortran 90 and Fortran 95
    # Additionally, ifort recognizes more file extensions.
    SCons.Tool.SourceFileScanner.add_scanner('.i', fortran.FortranScan)
    SCons.Tool.SourceFileScanner.add_scanner('.i90', fortran.FortranScan)
    fortran.FortranSuffixes.extend(['.i', '.i90'])
    fortran.generate(env)

    env['_FORTRAND'] = 'ifort'

    # If files are compiled into objects, the Intel Fortran Compiler must use
    # ld to link shared libraries.
    env['SHLINK'] = 'ld'

    # Additionally, no symbols can be defined in an archive file; to use
    # Intel Fortran to create shared libraries, all external symbols must
    # be in shared libraries.
    env['SHLINKFLAGS'] = '-shared -no_archive'

def exists(env):
    return env.Detect('ifort')
