//
//  Little cms - profiler construction set
//Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//


#include <qapplication.h>
#include <qdir.h>
#include "lprofmain.h"
// #include "qtiffio.h"
#include "qstring.h"

#if !defined(__WIN32__) && (defined(_WIN32) || defined(WIN32))
#define __WIN32__
#endif

static void Create_Config_Dir(const QString a)
{
    
    // This code is not portable at this point
    // Needs to be updated to work on Windows and Mac
    
    QString path;
    QString prefix_path=a;
    QString home_path;
     char files[128], copystr[8];
     char slash[2];  // Linux Unix slash for file operations
    BOOL homeDirExists;
    
     QDir* dir = new QDir ();
     
     # ifdef __WIN32__
         strcpy(slash, "\\");    // set correct slash character for Windows files operations 
         prefix_path=QDir::convertSeparators(prefix_path);
     # else
         strcpy(slash,  "/");
     # endif /* __WIN32__ */
         path=prefix_path;
           
     // Set up path to data directory.  It is either in the build directory 
     // or in prefix/share/lprof/data.  Check for build directory first.
     // Need to do this not only for creating the users config directory
     // but also so the help system can locate the help files.
     // Otherwise it would be inside of the if below
      prefix_path.truncate(prefix_path.find((QString) slash + (QString) "build"));
      prefix_path = prefix_path + (QString) slash + (QString) "data";
       if (dir->exists(prefix_path, TRUE))
      {
           prefix_path = prefix_path + (QString) slash;
      }
      else
      {
          // not in the build directory so need to check for and remove /bin
          prefix_path = path;
          prefix_path.truncate(prefix_path.length()-3);
          prefix_path = prefix_path + (QString) "share" + (QString) slash + (QString) "lprof" + (QString) slash + (QString) "data" + (QString) slash;
      }
      // check to see if config directory exists
     // if not create it and move template files into it
     home_path = dir->convertSeparators(dir->homeDirPath());
     home_path =  home_path + (QString) slash + (QString) ".lprof";
      if (!dir->exists(home_path, TRUE)) 
     {
         homeDirExists=FALSE;
         if (!dir->exists(home_path, TRUE)) dir->mkdir(home_path, TRUE);
            
        # ifdef __WIN32__
            strcpy(copystr, "copy \"");  // copy command for Windows
            // hide the user configuration directory 
            strcpy(files, "attrib +h \"");
            strcat(files, home_path);
            strcat(files, "\"");
            system(files);
        # else
            strcpy(copystr, "cp \"");  // copy command for Linux & Unix
        # endif /* __WIN32__ */
                
        path = dir->convertSeparators(dir->homeDirPath()) + (QString) slash + (QString) ".lprof" + (QString) slash + (QString) "config";
        if (!dir->exists(path, TRUE)) dir->mkdir(path, TRUE);
        path = dir->convertSeparators(dir->homeDirPath()) + (QString) slash + (QString) ".lprof" + (QString) slash + (QString) "target_refs";
        if (!dir->exists(path, TRUE)) dir->mkdir(path, TRUE);
        path = dir->convertSeparators(dir->homeDirPath()) + (QString) slash + (QString) ".lprof" + (QString) slash + (QString) "temp";
        if (!dir->exists(path, TRUE)) dir->mkdir(path, TRUE);
        path = dir->convertSeparators(dir->homeDirPath()) +  (QString) slash + (QString) ".lprof" + (QString) slash + (QString) "templates";
        if (!dir->exists(path, TRUE)) dir->mkdir(path, TRUE); 
                      
       QDir d (prefix_path + (QString) "template" + (QString) slash);
       d.setFilter(QDir::Files | QDir::Hidden);
       const QFileInfoList *list = d.entryInfoList();
       QFileInfoListIterator it( *list );
       QFileInfo *fi;
       while ( (fi = it.current()) != 0 ) 
       {
            // printf( "%10li %s\n", fi->size(), fi->fileName().latin1() );
            ++it;
            if (fi->fileName().contains("ITX", FALSE))
            {
               // the next line is not portable fix me
               strcpy(files, copystr);
               strcat(files,prefix_path);
               strcat(files,"template");
               strcat(files, slash);
               strcat(files, fi->fileName().latin1());
               strcat(files, "\" \"");
               strcat(files, dir->convertSeparators(dir->homeDirPath()));
               strcat(files, slash);
               strcat(files,".lprof");
               strcat(files, slash);
               strcat(files, "templates");
               strcat(files, slash);
               strcat(files, fi->fileName().latin1());
               strcat(files, "\"");
               //        qDebug(files);
               system(files);  
           } 
       }
   }
     
   dir->setCurrent(prefix_path);  // used to find help files
   dir->~QDir();
   // qDebug(prefix_path);
}

int main( int argc, char ** argv )
{
    QApplication a( argc, argv );
    Create_Config_Dir(a.applicationDirPath());
    // qInitTiffIO();
    lprofMain w;
    w.show();
    a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );
    return a.exec();
}
