/*
 * dslk.h -- Solaris header file for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/* $Id: dlslk.h,v 1.9 2001/07/11 11:22:23 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 

#if	!defined(DLSLK_H_SOLARIS)
#define	DLSLK_H_SOLARIS	1

#define	_KMEMUSER	1
#include <sys/user.h>
#include <sys/proc.h>

#include <kvm.h>
#include <fcntl.h>
#include <nlist.h>
#include <setjmp.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/mnttab.h>
#include <sys/mntent.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>

# if	solaris>=70000
#include <sys/systeminfo.h>
# endif	/* solaris>=70000 */

# if	solaris==20300
#include <sys/vnode.h>
# endif	/* solaris==20300 */

#define	_KERNEL
#define	free	___free
#include <sys/fs/ufs_inode.h>
#include <sys/flock.h>
#undef	_KERNEL
#undef	free
#include <sys/vnode.h>
#undef	OWNER

# if	solaris==20300
/*
 * Sun doesn't ship the following definitions in Solaris 2.3.  These
 * are taken from Solaris 2.4.
 */

struct lock_descriptor {
	struct lock_descriptor *prev;	/* backward link */
	struct lock_descriptor *next;	/* forward link */
	vnode_t *vnode;			/* vnode that is locked */
	struct lock_owner {
		pid_t pid;		/* PID of process owning lock */
		long sysid;		/* sysid where PID is running */
	} owner;
	u_int flags;			/* lock flags */
	short type;			/* lock type */
	off_t start;			/* starting position */
	off_t end;			/* ending position */
};
#define	ACTIVE_LOCK	0x008		/* active lock flag */
# else	/* solaris!=20300 */
#include <sys/flock_impl.h>
# endif	/* solaris==20300 */


/*
 * The following definitions allows some common code for referencing the
 * lock_descriptor structure.
 */

# if	solaris<20500
#define	LOCK_END	end
#define	LOCK_FLAGS	flags
#define	LOCK_START	start
#define	LOCK_PID	owner.pid
#define	LOCK_NEXT	next
#define	LOCK_SYSID	owner.sysid
#define	LOCK_TYPE	type
#define	LOCK_VNODE	vnode
# else	/* solaris>=20500 */
#define	LOCK_FLAGS	l_state
#define	LOCK_LEN	l_flock.l_len
#define	LOCK_NEXT	l_next
#define	LOCK_PID	l_flock.l_pid
#define	LOCK_SYSID	l_flock.l_sysid
#define	LOCK_START	l_flock.l_start
#define	LOCK_TYPE	l_flock.l_type
#define	LOCK_VNODE	l_vnode
#define	LOCK_WHENCE	l_flock.l_whence
# endif	/* solaris<20500 */

# if	solaris>=20500
#include <nfs/lm.h>
# endif	/* solaris>=20500 */

# if	solaris>20500 && solaris<70000
#include <vm/as.h>
# endif	/* solaris>20500 && solaris<70000 */


/*
 * Local definitions
 */

#define	COMP_P		const void	/* qsort() compare pointer type */

# if	solaris<20700
typedef	void *		KA_T;		/* kernel address type for kread() */
# else	/* solaris>=20700 */
typedef	uintptr_t	KA_T;		/* kernel address type for kread() */
# endif	/* solaris<20700 */

#define	LMEMCPY_P	void		/* local memcpy() type */
#define	lmemcpy		memcpy		/* local memcpy() */
#define	MALLOC_P	void		/* malloc() pointer cast */
#define	MALLOC_S	size_t		/* malloc() size cast */
#define	N_UNIX		"/dev/ksyms"	/* name list path */
#define	QSORT_P		char		/* qsort() table pointer type */

/*
 * Nl indexes
 */

#define	X_IHEAD		0
#define	X_INOHSZ	1

# if	solaris>=20500
#define X_SYSIDS        2
#define	X_KERNELBASE	3
#  if	solaris>=20501
#define	X_KAS		4
#  endif	/* solaris>=20501 */
# endif	/* solaris>=20500 */


/*
 * Local structure definitions
 */

# if	solaris>=20500
struct SysIDs {				/* local sysid information */
	sysid_t id;			/* the sysid */
	char *hn;			/* the associated host name */
	ulong na;			/* the associated network address */
};
# endif	/* solaris>=20500 */


/*
 * Local global variables
 */

extern union ihead *Ihdp;
extern int Ihsz;
extern kvm_t *Kd;
extern struct nlist Nl[];

# if	solaris>=20500
extern int Nsid;
extern struct SysIDs *Sids;
# endif	/* solaris>=20500 */

# endif	/* defined(DLSLK_H_SOLARIS) */
