#
#  DellPlaylist.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from Playlist import *
import os
from utils import *
from pynjb import *

class DellMasterPlaylist(Playlist):
	def __init__(self,library):
		Playlist.__init__(self,library)
		self.master = True
		self.name = unikode(i18n("Library"))
		self.njb = None
	
	def setDevice(self,njb):
		self.njb = njb

	def setName(self,name):
		pass
	
	def uploadTrack(self,track,callback = None,data = None):
		t = self.library().findTrackLike(track)
		if t:
			#print "DellPlaylist - I already have this track!"
			return t.trackID
		else:
			song = NJBSong()
			if track.title: song.AddFrame(NJBFrame('TITLE',unikode(track.title).encode('latin-1')))
			if track.artist: song.AddFrame(NJBFrame('ARTIST',unikode(track.artist).encode('latin-1')))
			if track.album: song.AddFrame(NJBFrame('ALBUM',unikode(track.album).encode('latin-1')))
			if track.genre: song.AddFrame(NJBFrame('GENRE',unikode(track.genre).encode('latin-1')))
			if track.year: song.AddFrame(NJBFrame('YEAR',track.year))
			if track.trackNum: song.AddFrame(NJBFrame('TRACK NUM',track.trackNum))
			song.AddFrame(NJBFrame('FILE SIZE',track.size))
			song.AddFrame(NJBFrame('CODEC','MP3'))
			song.AddFrame(NJBFrame('LENGTH',track.totalTime/1000))
			(path,shortName) = os.path.split(track.location)
			#print "DellPlaylist track file name is",shortName
			#song.AddFrame(NJBFrame('FNAME',shortName))
			#print "uploading",track.location,"with callback",callback,data
			if callback: (result,trackID) = self.njb.SendTrack(str(track.location),song,callback,data)
			else: (result,trackID) = self.njb.SendTrack(str(track.location),song)
			song.Destroy()
			if result==-1:
				print "DellPlaylist: Error uploading track:",self.njb.GetError()
				return None
			else:
				#print "uploaded trackID %d " % (trackID)
				return trackID

	def uploadTracks(self,tracks,callback = None,data = None):
		#print "DellMasterPlaylist: upload tracks",tracks
		for track in tracks:
			#if track.kind == 'MP3 audio file':
			trackID = self.uploadTrack(track,callback,data)

	def downloadTrack(self,track,callback = None, data = None):
		track.download(callback,data)
	
	def downloadTrackID(self,trackID,callback = None, data = None):
		track = self.trackWithTrackID(trackID)
		if track:
			self.downloadTrack(track,callback,data)
		
	def removeDellTrackIDs(self,trackIDs):
		for trackID in trackIDs:
			if self.containsTrackID(trackID):
				#self.removeTrackID(trackID)
				self.njb.DeleteTrack(trackID)
		self.library().removeTrackIDsFromAllPlaylists(trackIDs)

	#
	# creates a dictionary of tracks keyed with title/artist/album string
	#
	def hashList(self):
		result = {}
		for track in self.getTracks():
			result[track.hashKey()] = track
		return result

	#
	# compare this playlist with another playlist to see what we need to add or remove to make it the same
	#
	def getSyncInfoWith(self,playlist):
		tracksOnPlayerNotInLsongs = self.hashList()
		tracksInLsongsNotOnPlayer = {}
		removedTracks = {}
		
		for track in playlist.getTracks():
			if track.kind in ['MPEG audio file']: #,'WAV audio file']:
				key = track.hashKey()
				if tracksOnPlayerNotInLsongs.has_key(key):
					#print "removing",key
					removedTracks[key] = track
					del tracksOnPlayerNotInLsongs[key]
				else:
					#print "adding",key
					if not tracksInLsongsNotOnPlayer.has_key(key) and not removedTracks.has_key(key): # handle dups
						tracksInLsongsNotOnPlayer[key] = track
					#else: print "duplicate!"
		return (tracksInLsongsNotOnPlayer,tracksOnPlayerNotInLsongs)

class DellPlaylist(DellMasterPlaylist):
	def __init__(self,library):
		DellMasterPlaylist.__init__(self,library)
		self.master = False
		self.playlist = None
	
	def setDevice(self,njb,playlist):
		self.njb = njb
		self.playlist = playlist

	def fromDellPlaylist(self,njb,playlist):
		self.setDevice(njb,playlist)
		self.name = unikode(playlist.GetName())
		self.playlistID = playlist.GetID()
		incomingTracks = {}
		playlist.ResetGetTrack()
		track = playlist.GetTrack()
		#
		# add tracks I don't know about
		#
		while track:
			#print "LDellPlaylist.fromDellPlaylist: track",track
			try:
				id = track.GetTrackID()
				if not self.containsTrackID(id):
					self.addTrackID(id)
				incomingTracks[id] = 1
				track = playlist.GetTrack()
			except: track = None
		#
		# remove tracks no longer there
		#
		for trackID in self.getTrackIDs():
			try: incomingTracks[trackID]
			except: self.removeTrackID(trackID)
	
	def setName(self,name):
		self.name = unikode(name)
		self.playlist.SetName(self.name.encode('latin-1'))
		self.njb.UpdatePlaylist(self.playlist)
	
	#
	#
	def uploadTrack(self,track,callback=None, data = None):
		trackID = DellMasterPlaylist.uploadTrack(self,track,callback,data)
		plt = NJBPlaylistTrack(trackID)
		self.playlist.AddTrack(plt,NJB_PL_END)
		self.njb.UpdatePlaylist(self.playlist)
		return trackID
		
	def addDellTrackIDs(self,trackIDs):
		needsUpdate = False
		for trackID in trackIDs:
			if not self.containsTrackID(trackID):
				#print "DellPlaylist: adding trackID",trackID
				self.addTrackID(trackID)
				plt = NJBPlaylistTrack(trackID)
				self.playlist.AddTrack(plt,NJB_PL_END)
				needsUpdate = True
		if needsUpdate:
			self.njb.UpdatePlaylist(self.playlist)

	def removeDellTrackIDs(self,trackIDs):
		needsUpdate = False
		for trackID in trackIDs:
			if self.containsTrackID(trackID):
				self.removeTrackID(trackID)
				self.playlist.DeleteTrack(trackID)
				needsUpdate = True
		if needsUpdate:
			self.njb.UpdatePlaylist(self.playlist)

				
