#
# "@(#) $Id: LAudioCDViewItem.py,v 1.9 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LCheckListViewItem import *
from LTrackViewItemObject import *
from LMusicRipper import *
#from kdeui import KListViewItem
from LsongsPaths import *
from human import *
import time

def _get(a,b):
	if a==None: return b
	return a

_rippingIcons = None
def rippingIcons(index):
	global _rippingIcons
	if _rippingIcons==None:
		_rippingIcons = [QPixmap(art("labelimporting0.png")),QPixmap(art("labelimporting1.png")),QPixmap(art("labelimporting2.png"))]
	return _rippingIcons[index]

_rippedIcon = None
def rippedIcon():
	global _rippedIcon
	if _rippedIcon==None:
		_rippedIcon = QPixmap(art("labelimported.png"))
	return _rippedIcon

_playingIcon = None
def playingIcon():
	global _playingIcon
	if _playingIcon==None:
		_playingIcon = QPixmap(art("labelcurrentplaying.png"))
	return _playingIcon

_pausedIcon = None
def pausedIcon():
	global _pausedIcon
	if _pausedIcon==None:
		_pausedIcon = QPixmap(art("labelcurrentpause.png"))
	return _pausedIcon

class LAudioCDViewItem(LCheckListViewItem):
	def __init__(self,container,track):
		LCheckListViewItem.__init__(self,container)
		self._track = track
		self.trackItem = LTrackViewItemObject(self)
		self.status = 'idle'
		self.trackKey = "%03d" % self._track.trackNum
		self.ripIcon = -1
		self.ripTime = -1
		self.loadTrackInfo()

	def die(self):
		self.trackItem.trackItem = None
		self.trackItem = None

	def key(self,column, ascending):
		try:
			if column==1: return self.trackKey
		except: pass
		return LCheckListViewItem.key(self,column,ascending)

	def track(self):
		return self._track

	def trackID(self):
		return self._track.trackID

	def loadTrackInfo(self):
		self.setText(1,str(self._track.trackNum))
		self.setText(2,_get(self._track.title,""))
		self.setText(3,humanDuration(self._track.totalTime))
		self.setText(4,_get(self._track.artist,""))
		self.setText(5,_get(self._track.album,""))
		self.setText(6,_get(self._track.genre,""))
		self.setOn(self._track.enabled)
		if not self.ripStatus(self._track,None):
			self.setPlayingIcon()

	def contentsMouseDoubleClickEvent(self,event):
		self.play()

	def play(self):
		if not LMusicRipper.singleton().isRipping():
			playlist = self.listView().playlist
			self._track.play(playlist)

	def doImport(self):
		self._track.doImport()
	
	def stateChange(self,value):
		self._track.enabled = bool(value)

	def changedAttribute(self,attribute,oldValue,newValue):
		if attribute in ['trackNum','title','artist','album','contentType','playStatus','enabled']:
			if attribute!='playStatus':
				self.status = 'idle'
			self.loadTrackInfo()
	
	def ripStatus(self,track,status):
		if track.ripStatus=='ripping':
			self.setNextRippingIcon()
			return True
		elif track.ripStatus=='ripped':
			self.setRippedIcon()
			return True
		self.setIdleIcon()
		return False
	
	def setIdleIcon(self):
		self.setPixmap(0,QPixmap())

	def setNextRippingIcon(self):
		now = time.time()
		if now>self.ripTime:
			self.ripIcon = (self.ripIcon+1) % 3
			self.setPixmap(0,rippingIcons(self.ripIcon))
			self.ripTime = now
	
	def setRippedIcon(self):
		self.setPixmap(0,rippedIcon())

	def setPlayingIcon(self):
		status = self._track.playStatus
		if True: #self.status!=status:
			if status=='playing':
				self.setPixmap(0,playingIcon())
			elif status=='paused':
				self.setPixmap(0,pausedIcon())
			else:
				self.setPixmap(0,QPixmap())
			self.status = status
		
	def getInfo(self):
		trackIDs = self.listView().selectedTrackIDs()
		if trackIDs and len(trackIDs)>0:
			if len(trackIDs)==1:
				self._track.getInfo()
			else:
				self.listView().getMultiInfoForTrackIDs(trackIDs)
	
	def pause(self):
		self._track.pause()
			
	def enable(self):
		self.doEnable(True)
		
	def disable(self):
		self.doEnable(False)
	
	def doEnable(self,enable):
		tracks = self.listView().selectedTracks()
		for track in tracks:
			track.enabled = enable

	def contextMenu(self,pos,col):
		menu = QPopupMenu()
		status = self._track.playStatus
		if status=='playing':
			menu.insertItem(i18n("Pause"),self.pause)
		else:
			menu.insertItem(i18n("Play"),self.play)
		menu.insertItem(i18n("Get Info..."),self.getInfo)
		menu.insertItem(i18n("Enable"),self.enable)
		menu.insertItem(i18n("Disable"),self.disable)
		item = menu.exec_loop(pos)
	
