#
# LDellInfoDialog.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from human import *

class LDellInfoDialog(KDialogBase):
	def __init__(self,library):
		KDialogBase.__init__( self, None, "dellinfodialog", True, library.name, KDialogBase.Ok, KDialogBase.Ok, True )
		self.library = library
		self.build()
		self.setMinimumWidth(250)
		self.adjustSize()
		self.setFixedSize(self.size())

	def build(self):
		page = QWidget(self)
		self.setMainWidget(page)
		layout = QVBoxLayout(page)
		self.buildItems(page,layout)
	
	def buildItems(self,container,containerLayout):
		containerLayout.addWidget(QLabel("<b>Owner Name:</b>&nbsp;%s" % self.library.owner,container))
		containerLayout.addWidget(QLabel("<b>Type:</b>&nbsp;%s" % self.library.name,container))
		hw = self.library.hardwareRevision
		containerLayout.addWidget(QLabel("<b>Hardware Version:</b>&nbsp;%d.%d.%d" % (hw[0],hw[1],hw[2]),container))
		fw = self.library.firmwareRevision
		containerLayout.addWidget(QLabel("<b>Firmware Version:</b>&nbsp;%d.%d.%d" % (fw[0],fw[1],fw[2]),container))
		#containerLayout.addWidget(QLabel("<b>SDMI:</b>&nbsp;%s" % (self.library.sdmi),container))
		containerLayout.addWidget(QLabel("<b>Total:</b>&nbsp;%s KB " % humanComma(self.library.diskTotal),container))
		containerLayout.addWidget(QLabel("<b>Free:</b>&nbsp;%s KB " % humanComma(self.library.diskFree),container))
