#
# " LDeviceTrackView.py"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LDellTrackDrag import *
from LDellTrackViewItem import *
from DellLibrary import *
from DellNJB import *
from LPlaylistView import *
from LSettings import *
#from LMusicRipper import *

class LDeviceTrackView(LPlaylistView):
	def __init__(self,container):
		LPlaylistView.__init__(self,container)
	
	def setCurrentPlaylist(self):
		pass

	def loadHeaders(self):
		headers = [" ",i18n("Song Name"),i18n("Time"),i18n("Artist"),i18n("Album"),i18n("Genre")]
		widths = [25,220,40,120,180,80]
		for index in xrange(0,len(headers)):
			self.addColumn(headers[index],widths[index])
		self.setShowSortIndicator(True)
		self.setFullWidth(True)
		self.indexColumn = 100
		self.ratingColumn = 100
		self.loadSortInfo()
		QObject.connect(self.header(),SIGNAL("indexChange(int,int,int)"),self.columnIndexChanged)
		QObject.connect(self.header(),SIGNAL("sizeChange(int,int,int)"),self.columnSizeChanged)
		self.loadHeaderInfo()
	
	def loadSortInfo(self):
		pass
		#sortColumn = self.settings.get('DDJ Library Sort Column',3)
		#sortAscending = self.settings.get('DDJ Library Sort Ascending',True)
		#self.setSorting(sortColumn,sortAscending)

	def loadHeaderInfo(self):
		pass
		#self.loadHeaderSizes('DDJ Library Header Widths')
		#self.loadHeaderOrdering('DDJ Library Header Map')

	def loadTracks(self):
		pass

	def setPlaylist(self,playlist):
		self.playlistName = playlist.name
		self.playlist = playlist
		self.library = playlist._library
		#self.playlist.fetchTracks()
		self.playlist.connect(PYSIGNAL("addedTrack"),self.addedTrack)
		self.playlist.connect(PYSIGNAL("aboutToRemoveTrack"),self.aboutToRemoveTrack)
		self.loadPlaylistItems()

	def xloadPlaylistItems(self):
		self.clear()
		index = 1
		tracks = self.playlist._tracks.values()
		for track in tracks:
			self.loadTrackItemForIndex(track,index)
			index = index+1
		self.emitCurrentEnabledSortedTracks()

	def loadTrackItemForIndex(self,track,index):
		pass
		#item = LDellTrackViewItem(self,track,index)

	def canBurn(self):
		return False
	
	def canPlay(self):
		return False

	def canShowLocation(self):
		return False
	
	def canGetInfo(self):
		return False

	def refresh(self):
		self.loadPlaylistItems()

	def doSelectionChanged(self):
		LLibraryView.doSelectionChanged(self)
		self.emit(PYSIGNAL("selectionChanged"),(self,None))

	def removeSelectedItems(self):
		#trackIDs = self.selectedTrackIDs()
		#self.library.removeTrackIDsFromTrash(trackIDs)
		pass

	def xcontextMenu(self,item,pos,col):
		pass
	
	def contentsDragEnterEvent(self,event):
		pass
	
	def contentsDropEvent(self,event):
		pass

	def acceptDrag(self,event):
		return False

	def dragObject(self):
		pass

##		print "dragging Dell tracks"
##		selectedTrackIDs = self.selectedTrackIDs()
##		#print "selected",selectedTrackIDs
##		#tracks = self.library.tracksWithTrackIDs(selectedTrackIDs)
##		#print tracks
##		if selectedTrackIDs and len(selectedTrackIDs)>0:
##			drag = LDellTrackDrag(selectedTrackIDs,self.playlist,self)
##			drag.dragCopy()

	def canSync(self):
		return False
	
	def xsync(self):
		pass
		#print "syncing"
		#if self.library.allowWrites:
		#	self.library.syncWith(Library.mainLibrary())

	def setSorting(self,column,ascending):
		pass
		#KListView.setSorting(self,column,ascending)
		#self.settings['DDJ Library Sort Column'] = column
		#self.settings['DDJ Library Sort Ascending'] = not not ascending

	def columnIndexChanged(self,section,fromIndex,toIndex):
		pass
		#self.saveHeaderOrdering('DDJ Library Header Map')
	
	def columnSizeChanged(self,section,oldSize,newSize):
		pass
		#self.saveHeaderSizes('DDJ Library Header Widths')

	def setSearchType(self,searchType):
		self.searchType = searchType
		self.loadPlaylistItems()

	def setSearchText(self,searchText):
		self.searchText = searchText
		self.loadPlaylistItems()
