#
# LEncoderProcess.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from LsongsProcess import *
from LSettings import *
from utils import *
import crushToAscii
import os,re

class LEncoderProcess(LsongsProcess):
	def __init__(self,track,index,total):
		self.index = index
		self.total = total
		self.track = track
		self.settings = LSettings.settings()
		#tmpPath = os.environ.get('TMP','/tmp')
		#print "LEncoderProcess",track.originalLocation
		(tmpPath,shortFileName) = os.path.split(self.track.originalLocation)
		(shortFileName,ext) = os.path.splitext(shortFileName)
		#print "shortFileName",shortFileName
		self.track.shortFileName = shortFileName
		title = crushToAscii.crush(self.track.shortFileName)
		title = self.cleanup(title)
		self.wavPath = os.path.join(tmpPath,title+'.wav')
		self.destPath = os.path.join(tmpPath,title+'.'+self.extension())
		#print "Encoding",self.wavPath,"->",self.destPath
		LsongsProcess.__init__(self)

	def extension(self):
		return '???'

	def cleanup(self,s):
		return re.sub(r"/",r"-",s)

	def processLines(self,lines):
		pass

	def endProcess(self,process):
		#try: os.remove(self.wavPath)
		#except: pass
		self.emitEvent({'Source':'Encoder','Status':'EndTrack','Track':self.track,'FilePath':self.destPath,'Index':self.index,'Count':self.total})
		LsongsProcess.endProcess(self,process)

	def abortProcess(self,process):
		#try: os.remove(self.wavPath)
		#except: pass
		try: os.remove(self.destPath)
		except: pass
		self.emitEvent({'Source':'Encoder','Status':'EndTrack','Track':self.track,'Interrupted':True,'Index':self.index,'Count':self.total})
		LsongsProcess.abortProcess(self,process)
