#
# "@(#) $Id: LMusicDellImporter.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
import os,re
from LsongsProcess import *
import crushToAscii

#
# nuke any slashes that might confuse the OS
#
def cleanup(s):
	return re.sub(r"/",r"-",s)

class LMusicDellImporterProcess(LsongsProcess):
	def __init__(self,track,playlist,index,count):
		self.track = track
		self.playlist = playlist
		self.index = index
		self.count = count
		self.pattern = re.compile(r"\|(\d+)\|(\d+)\|")
		path = os.environ.get('TMP','/tmp')
		title = crushToAscii.crush(self.track.title)
		title = cleanup(title)
		# XXX DSM handle WAV, WMA here
		mp3Name = title+'.mp3'
		self.mp3Path = os.path.join(path,mp3Name)
		LsongsProcess.__init__(self)

	def buildCommand(self):
		self.setExecutable("nice")
		args = ["njbgettrack",str(self.track.trackID),self.mp3Path]
		self.setArguments(args)
		self.emitEvent({'Source':'DellImporter','Status':'BeginTrack','Track':self.track,'Playlist':self.playlist})

	def processLines(self,lines):
		line = lines[-1]
		mo = self.pattern.match(line)
		if mo:
			currentTime = long(mo.group(1))
			totalTime = long(mo.group(2))
			fraction = (currentTime*1.0)/totalTime
			self.maybeEmitEvent({'Source':'DellImporter','Status':'Importing','currentTime':(self.index+fraction),'totalTime':self.count,'Track':self.track})
	
	def endProcess(self,process):
		self.emitEvent({'Source':'DellImporter','Status':'EndTrack','Track':self.track,'filePath':self.mp3Path})
		LsongsProcess.endProcess(self,process)

	def abortProcess(self,process):
		os.remove(self.mp3Path)
		self.emitEvent({'Source':'DellImporter','Status':'EndTrack','Track':self.track,'Interrupted':True})
		LsongsProcess.abortProcess(self,process)

class LMusicDellImporter(QObject):
	def __init__(self):
		QObject.__init__(self)
		self.tracksToImport = []
		self.index = 0
		self.count = 0
		self.process = None
	
	def importNextTrack(self):
		if (self.process==None or not self.process.isRunning()):
			if len(self.tracksToImport)>0:
				if self.index==0:
					self.gotStatus(None,{'Source':'DellImporter','Status':'Begin'})
				(track,playlist) = self.tracksToImport[0]
				self.tracksToImport = self.tracksToImport[1:]
				self.process = LMusicDellImporterProcess(track,playlist,self.index,self.count)
				QObject.connect(self.process,PYSIGNAL("done"),self.endImportTrack)
				QObject.connect(self.process,PYSIGNAL("status"),self.gotStatus)
				self.process.run()
				self.index = self.index+1
			else:
				self.gotStatus(None,{'Source':'DellImporter','Status':'End'})
		else:
			print "importing is busy!"

	def gotStatus(self,process,status):
		self.emit(PYSIGNAL('status'),(status,None))

	def endImportTrack(self,process):
		if not process.interrupted:
			self.importNextTrack()

	def importTracks(self,tracks,playlist):
		if tracks and len(tracks)>0:
			if len(self.tracksToImport)==0:
				self.index = 0
				self.count = 0
			for track in tracks:
				self.tracksToImport.append([track,playlist])
			self.count = self.count+len(tracks)
			self.importNextTrack()
	
	def kill(self):
		self.tracksToImport = []
		if self.process:
			self.process.kill()
			self.process = None
			self.gotStatus(None,{'Source':'DellImporter','Status':'End'})

	def static_killCurrentDellImporter():
		LMusicDellImporter.singleton.kill()
	killCurrentDellImporter = staticmethod(static_killCurrentDellImporter)

	def static_singleton():
		global _dellImporterSingleton
		return _dellImporterSingleton

	singleton = staticmethod(static_singleton)

_dellImporterSingleton = LMusicDellImporter()
