#
# LPlaylistSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from LSourceViewItem import *
from LPlaylistWindow import *
from LTrackDrag import *
from LDellTrackDrag import *
from LPodTrackDrag import *
from LRemoteTrackDrag import *
from LMusicDownloader import *

#
# Standard playlist
#
class LPlaylistSourceViewItem(LSourceViewItem):
	def __init__(self,container,source):
		LSourceViewItem.__init__(self,container,source.name)
		self.source = source
		self.setDragEnabled(True)
		self.setRenameEnabled(0,True)
		self.setDropEnabled(True)
		self.wantsTrackDrags = True
		self.wantsFileDrags = True
		self.canExport = True
		self.canBurn = True
		self.canBeRemoved = True

	def makeKey(self):
		return u'F%s' % unikode(self.name)

	def changeName(self,newName):
		self.doSourceChangeName(newName)
		try:
			lib = self.source._library
			lib.markDirty()
		except: pass

	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		self.popup.setCheckable(True)
		self.renameID = self.popup.insertItem(i18n("Rename Playlist"),self.renamePlaylist)
		self.deleteID = self.popup.insertItem(i18n("Delete Playlist"),self.deletePlaylist)
		self.trashID = self.popup.insertItem(i18n("Move Contents to Trash"),self.trashPlaylist)
		self.exportID = self.popup.insertItem(i18n("Export Song List"),self.exportSongList)
		self.burnID = self.popup.insertItem(i18n("Burn Playlist to Disc"),self.burnPlaylistToDisc)
		self.shareID = self.popup.insertItem(i18n("Share Playlist"),self.sharePlaylist)

	def loadPopup(self):
		self.popup.setItemEnabled(self.burnID,CDROMS.singleton().canBurn())
		self.popup.setItemChecked(self.shareID,self.source.shared)

	def sharePlaylist(self):
		self.source.shared = not self.source.shared
		self.popup.setItemChecked(self.shareID,self.source.shared)
		
	def exportSongList(self):
		self.source.exportSongList()
	
	def burnPlaylistToDisc(self):
		self.source.burnPlaylistToDisc()
	
	def renamePlaylist(self):
		self.startRename(0)

	def deletePlaylist(self):
		self.library.removePlaylist(self.source)
	
	def trashPlaylist(self):
		self.source.moveTracksToTrash()
		
	def doubleClick(self):
		LPlaylistWindow.openOnPlaylist(self.source)

	#
	# allow file system drags
	# allow track drags from anywhere except self
	#
	def acceptDrag(self,event):
		if not self.wantsTrackDrags: return False
		elif self.wantsFileDrags and QUriDrag.canDecode(event): return True
		elif LTrackDrag.canDecode(event):
			drag = LTrackDrag.decode(event)
			playlist = self.library.playlistWithName(drag['Playlist'])
			if playlist!=self.source: return True
		elif LDellTrackDrag.canDecode(event):
			return True
		elif LPodTrackDrag.canDecode(event):
			return True
		elif LRemoteTrackDrag.canDecode(event):
			return True
		return False

	#
	# handle file system drags, add to both library and self
	# handle track drags
	# if from trash, add to library and remove from trash
	#
	def dropped(self,event):
		if LTrackDrag.canDecode(event):
			drag = LTrackDrag.decode(event)
			#print "playlist got",drag
			playlist = self.library.playlistWithName(drag['Playlist'])
			trackIDs = drag['TrackIDs']
			self.source.addTrackIDs(trackIDs)
			if playlist == self.trash:
				self.libraryPlaylist.addTrackIDs(trackIDs)
				self.trash.removeTrackIDs(trackIDs)
		elif LDellTrackDrag.canDecode(event):
			from DellLibrary import DellLibrary
			from LMusicDellManager import LMusicDellManager
			drag = LDellTrackDrag.decode(event)
			trackIDs = drag['TrackIDs']
			tracks = DellLibrary.singleton().tracksWithTrackIDs(trackIDs)
			#print "accepting Dell",tracks
			LMusicDellManager.singleton().downloadTracksToPlaylist(self.source,tracks)
		elif LPodTrackDrag.canDecode(event):
			from PodLibrary import PodLibrary
			from LMusicPodManager import LMusicPodManager
			drag = LPodTrackDrag.decode(event)
			trackIDs = drag['TrackIDs']
			tracks = PodLibrary.singleton().tracksWithTrackIDs(trackIDs)
			#print "accepting iPod",tracks
			LMusicPodManager.singleton().downloadTracksToPlaylist(self.source,tracks)
		elif LRemoteTrackDrag.canDecode(event):
			drag = LRemoteTrackDrag.decode(event)
			tracks = []
			for trackplist in drag['Tracks']:
				track = Track()
				track.setPList(trackplist)
				tracks.append(track)
			LMusicDownloader.singleton().downloadTracks(tracks,self.source,self.library)
		elif QUriDrag.canDecode(event):
			uris = QStringList()
			if QUriDrag.decodeLocalFiles(event,uris):
				self.library.importFiles(removeDuplicates(uris),self.source)
		
	def iconFileName(self): return "sourceplaylist.png"

	def select(self,container):
		container.emit(PYSIGNAL("selectPlaylist"),(self.source,None))

	def createDrag(self,container):
		return LPlaylistDrag(self.source,container)
