#
# "@(#) $Id: LPrefsDialog.py,v 1.8 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LSettings import *
from utils import *
import socket
from LsongsSharing import *
from Library import *
from LsongsPaths import *

class LPrefsPlaylistItem(QCheckListItem):
	def __init__(self,listView,playlist):
		self.playlist = playlist
		QCheckListItem.__init__(self,listView,playlist.name,QCheckListItem.CheckBox)
		if playlist.master:
			self.sortKey = "A"
			self.setText(0,i18n("Media Library"))
			iconFileName = "sourcelibrary.png"
		else:
			self.sortKey = u"B%s" % playlist.name
			iconFileName = "sourceplaylist.png"
		iconPath = art(iconFileName)
		pixmap = QPixmap(iconPath)
		self.setPixmap(0,pixmap)

	def key(self,column,ascending):
		return self.sortKey

class LPrefsDialog(KDialogBase):
	def __init__(self):
		KDialogBase.__init__(self,KDialogBase.Tabbed,i18n("Preferences"),KDialogBase.Ok+KDialogBase.Cancel,\
			KDialogBase.Ok,None,"preferences",True)
		self.settings = LSettings.settings()
		self.qualities = {128000:unikode(i18n("Good Quality (128 kbps)")),160000:unikode(i18n("High Quality (160 kbps)")),192000:unikode(i18n("Higher Quality (192 kbps)")),256000:unikode(i18n("Best Quality (256 kbps)"))}
		self.qualitiesKeys = self.qualities.keys()
		self.qualitiesKeys.sort()
		#self.encoders = {'mp3':'MP3 Encoder','aiff':'AIFF Encoder','ogg':'Ogg Encoder','wav':'WAV Encoder'}
		self.encoders = {'mp3':unikode(i18n('MP3 Encoder')),'ogg':unikode(i18n('Ogg Encoder')),'wav':unikode(i18n('WAV Encoder'))}
		self.encodersKeys = self.encoders.keys()
		self.encodersKeys.sort()
		self.insertActions = {'show':unikode(i18n("Show Songs")),'play':unikode(i18n("Begin Playing")),'import':unikode(i18n("Import Songs")),'importAndEject':unikode(i18n("Import Songs and Eject"))}
		self.insertActionsKeys = self.insertActions.keys()
		self.insertActionsKeys.sort()
		self.burnDiscTypes = {'audio':unikode(i18n("Audio CD")),'mp3':unikode(i18n("MP3 CD")),'data':unikode(i18n("Data CD"))}
		self.burnDiscTypesKeys = self.burnDiscTypes.keys()
		self.burnDiscTypesKeys.sort()
		self.add()
		self.load()
		self.adjustSize()
		self.setMinimumSize(QSize(200,200))

	def add(self):
		self.addGeneralItems()
		self.addImportingItems()
		self.addCDItems()
		self.addSharingItems()
		self.addPlayerItems()
		#self.addLookingItems()
		#self.addStoreItems()
		#self.addAdvancedItems()
	
	def addGeneralItems(self):
		return
		#page = self.addPage(i18n("General"))

	def addImportingItems(self):
		page = self.addPage(i18n("Importing"))
		hlayout = QHBoxLayout(page)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		layout = QVBoxLayout()
		hlayout.addLayout(layout)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))		
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		self.addImportOptionsItems(page,layout)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))

	def addImportOptionsItems(self,container,containerLayout):
		containerLayout.addWidget(QLabel(i18n("Media Library Directory:"),container))
		hlayout = QHBoxLayout()
		containerLayout.addLayout(hlayout)
		self.pathItem = QTextEdit(container)
		self.pathItem.setMinimumWidth(250)
		self.pathItem.setFixedHeight(60)
		self.pathItem.setReadOnly(True)
		hlayout.addWidget(self.pathItem)
		hlayout.addItem(QSpacerItem(10,1,QSizePolicy.Fixed,QSizePolicy.Fixed))				
		vlayout = QVBoxLayout()
		hlayout.addLayout(vlayout)
		
		self.changePathItem = QPushButton(container)
		self.changePathItem.setText(i18n("Change..."))
		QObject.connect(self.changePathItem,SIGNAL("released()"),self.hitChangePath)
		vlayout.addWidget(self.changePathItem)
		self.resetPathItem = QPushButton(container)
		self.resetPathItem.setText(i18n("Reset"))
		QObject.connect(self.resetPathItem,SIGNAL("released()"),self.hitResetPath)
		vlayout.addWidget(self.resetPathItem)

		containerLayout.addItem(QSpacerItem(1,10,QSizePolicy.Fixed,QSizePolicy.Fixed))				
		self.manageRadio = QRadioButton(i18n("Copy files on Import"),container,"manage")
		containerLayout.addWidget(self.manageRadio)
		self.unmanageRadio = QRadioButton(i18n("Use source files on Import"),container,"unmanage")
		containerLayout.addWidget(self.unmanageRadio)
		hlayout = QHBoxLayout()
		containerLayout.addLayout(hlayout)
		hlayout.addItem(QSpacerItem(10,1,QSizePolicy.Fixed,QSizePolicy.Fixed))
		self.modifyTagsCheckbox = QCheckBox(i18n("Allow tag modifications"),container,"modifiyTags")
		hlayout.addWidget(self.modifyTagsCheckbox)
		QObject.connect(self.manageRadio,SIGNAL("stateChanged(int)"),self.hitManaged)
		QObject.connect(self.unmanageRadio,SIGNAL("stateChanged(int)"),self.hitUnmanaged)

	def hitChangePath(self):
		fileName = KFileDialog.getExistingDirectory(Library.mainLibrary().musicPath(), self, i18n("Select Music Directory"))
		if fileName:
			self.pathItem.setText(fileName)
	
	def hitResetPath(self):
		self.pathItem.setText(Library.mainLibrary().defaultMusicPath())

	def hitManaged(self,state):
		if state==QButton.On:
			self.unmanageRadio.setState(QButton.Off)
			self.modifyTagsCheckbox.setEnabled(False)
		else:
			self.unmanageRadio.setState(QButton.On)
	
	def hitUnmanaged(self,state):
		if state==QButton.On:
			self.manageRadio.setState(QButton.Off)
			self.modifyTagsCheckbox.setEnabled(True)
		else:
			self.manageRadio.setState(QButton.On)
		
	def addCDItems(self):
		page = self.addPage(i18n("CD"))
		# center horizontally
		hlayout = QHBoxLayout(page)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		layout = QVBoxLayout()
		layout.setSpacing(5)
		hlayout.addLayout(layout)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		self.addCDInsertionItems(page,layout)
		self.addCDImportItems(page,layout)
		self.addCDBurnItems(page,layout)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
	
	def addCDInsertionItems(self,container,containerLayout):
		layout = QHBoxLayout()
		containerLayout.addLayout(layout)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		
		label = QLabel(i18n("On CD Insert:"),container)
		label.setAlignment(Qt.AlignRight)
		layout.addWidget(label)
	
		self.onCDInsertItem = KComboBox(False,container)
		for action in self.insertActionsKeys:
			self.onCDInsertItem.insertItem(self.insertActions[action])
		layout.addWidget(self.onCDInsertItem)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))

	def addCDImportItems(self,container,containerLayout):
		layout = QGridLayout(6,2)
		containerLayout.addLayout(layout)
		layout.setSpacing(5)
		
		label = QLabel(i18n("Import Using:"),container)
		label.setAlignment(Qt.AlignRight)
		layout.addWidget(label,0,0)

		self.importUsingItem = KComboBox(False,container)
		for encoder in self.encodersKeys:
			self.importUsingItem.insertItem(self.encoders[encoder])
		layout.addWidget(self.importUsingItem,0,1)
		QObject.connect(self.importUsingItem,SIGNAL("highlighted(int)"),self.hitImportUsingItem)

		label = QLabel(i18n("Setting:"),container)
		label.setAlignment(Qt.AlignRight)
		layout.addWidget(label,1,0)

		self.importSettingsItem = KComboBox(False,container)
		for bitrate in self.qualitiesKeys:
			self.importSettingsItem.insertItem(self.qualities[bitrate])
		layout.addWidget(self.importSettingsItem,1,1)

		self.useVBRItem = QCheckBox(i18n("Variable Bit Rate"),container)
		layout.addWidget(self.useVBRItem,2,1)

		self.useErrorCorrectionItem = QCheckBox(i18n("Use error correction"),container)
		layout.addWidget(self.useErrorCorrectionItem,3,1)
		
		label = QLabel(i18n("Copy Performance:"),container)
		label.setAlignment(Qt.AlignRight)
		layout.addWidget(label,4,0)
		
		self.ripNiceItem = QSlider(Qt.Horizontal,container)
		self.ripNiceItem.setRange(-20,20)
		self.ripNiceItem.setTickmarks(QSlider.Below)
		self.ripNiceItem.setTickInterval(5)
		layout.addWidget(self.ripNiceItem,4,1)
		
		label = QLabel(i18n("Encode Performance:"),container)
		label.setAlignment(Qt.AlignRight)
		layout.addWidget(label,5,0)
		
		self.encodeNiceItem = QSlider(Qt.Horizontal,container)
		self.encodeNiceItem.setRange(-20,20)
		self.encodeNiceItem.setTickmarks(QSlider.Below)
		self.encodeNiceItem.setTickInterval(5)
		layout.addWidget(self.encodeNiceItem,5,1)
	
	def hitImportUsingItem(self,index):
		self.importSettingsItem.setEnabled(index!=2)
		self.useVBRItem.setEnabled(index==0)

	def addCDBurnItems(self,container,containerLayout):
		layout = QGridLayout(1,2)
		containerLayout.addLayout(layout)
		layout.setSpacing(3)

		label = QLabel(i18n("Burn Disc Format:"),container)
		label.setAlignment(Qt.AlignRight)
		layout.addWidget(label,0,0)
		
		self.burnDiscTypeItem = KComboBox(False,container)
		for action in self.burnDiscTypesKeys:
			self.burnDiscTypeItem.insertItem(self.burnDiscTypes[action])
		layout.addWidget(self.burnDiscTypeItem,0,1)
		#layout.addItem(QSpacerItem(0,1,QSizePolicy.Expanding,QSizePolicy.Fixed))

	def addSharingItems(self):
		page = self.addPage(i18n("Sharing"))
		# center horizontally
		hlayout = QHBoxLayout(page)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		layout = QVBoxLayout()
		layout.setSpacing(5)
		hlayout.addLayout(layout)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		self.addSharingItemsAux(page,layout)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		
	def addSharingItemsAux(self,container,containerLayout):		
		hlayout = QHBoxLayout()
		containerLayout.addLayout(hlayout)
		label = QLabel(i18n("Name to display on network:"),container)
		hlayout.addWidget(label)
		self.shareNameEdit = KRestrictedLine(container)
		self.shareNameEdit.setValidChars("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-")
		hlayout.addWidget(self.shareNameEdit)

		self.lookForOtherProgramsItem = QCheckBox(i18n("Look for other programs (Lsongs, etc)"),container)
		containerLayout.addWidget(self.lookForOtherProgramsItem)
	
		#self.lookForDevicesItem = QCheckBox(i18n("Look for music device servers"),container)
		#containerLayout.addWidget(self.lookForDevicesItem)

		self.shareWithOtherProgramsItem = QCheckBox(i18n('Share with other programs (Lsongs, iTunes, etc)'),container)
		containerLayout.addWidget(self.shareWithOtherProgramsItem)
		QObject.connect(self.shareWithOtherProgramsItem,SIGNAL("stateChanged(int)"),self.hitSharingItem)

		self.shareWithDevicesItem = QCheckBox(i18n("Share with music devices"),container)
		containerLayout.addWidget(self.shareWithDevicesItem)
		QObject.connect(self.shareWithDevicesItem,SIGNAL("stateChanged(int)"),self.hitSharingItem)
	
		hlayout = QHBoxLayout()
		containerLayout.addLayout(hlayout)
		hlayout.addItem(QSpacerItem(20,1,QSizePolicy.Fixed,QSizePolicy.Fixed))
		vlayout = QVBoxLayout()
		hlayout.addLayout(vlayout)
		self.shareAllItem = QRadioButton(i18n("Share all"),container)
		vlayout.addWidget(self.shareAllItem)
		QObject.connect(self.shareAllItem,SIGNAL("stateChanged(int)"),self.hitShareAllItem)
		
		self.sharePlaylistsItem =QRadioButton(i18n("Share these playlists"),container)
		vlayout.addWidget(self.sharePlaylistsItem)
		QObject.connect(self.sharePlaylistsItem,SIGNAL("stateChanged(int)"),self.hitSharePlaylistsItem)
		
		zlayout = QHBoxLayout()
		vlayout.addLayout(zlayout)
		zlayout.addItem(QSpacerItem(20,1,QSizePolicy.Fixed,QSizePolicy.Fixed))

		self.sharedPlaylists = KListView(container)
		self.sharedPlaylists.addColumn(i18n("Playlists"))
		self.sharedPlaylists.setFullWidth(True)
		zlayout.addWidget(self.sharedPlaylists)
		
		self.addHDivider(container,vlayout)

		self.shareAllowWritesItem = QCheckBox(i18n("Allow Remote Management"),container)
		vlayout.addWidget(self.shareAllowWritesItem)
		self.shareStatusItem = QLabel("",container)
		vlayout.addWidget(self.shareStatusItem)
		
	def hitSharingItem(self,state):
		on = self.shareWithOtherProgramsItem.isOn() or self.shareWithDevicesItem.isOn()
		self.shareAllItem.setEnabled(on)
		self.sharePlaylistsItem.setEnabled(on)
		self.sharedPlaylists.setEnabled(on and self.sharePlaylistsItem.isOn())
		#self.shareNameEdit.setEnabled(on)
		#self.sharedPlaylists.setEnabled(on)
		self.shareAllowWritesItem.setEnabled(on)

	def hitShareAllItem(self,state):
		#print "hit share all",state
		on = state!=0
		if self.sharePlaylistsItem.isOn()==on:
			self.sharePlaylistsItem.setOn(not on)
	
	def hitSharePlaylistsItem(self,state):
		#print "hit share playlists",state
		on = state!=0
		if self.shareAllItem.isOn()==on:
			self.shareAllItem.setOn(not on)
		self.sharedPlaylists.setEnabled(on)

	def addPlayerItems(self):
		page = self.addPage(i18n("Players"))
		# center horizontally
		hlayout = QHBoxLayout(page)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		layout = QVBoxLayout()
		layout.setSpacing(5)
		hlayout.addLayout(layout)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		self.addPlayerItemsAux(page,layout)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))

	def addPlayerItemsAux(self,container,containerLayout):
		music = QVButtonGroup(i18n('Music'),container)
		containerLayout.addWidget(music)
		self.musicUnionItem = QRadioButton(i18n("Synchronize all tracks between Lsongs and the music player"),music)
		self.musicAddItem = QRadioButton(i18n("Add tracks to the music player that have been added to Lsongs"),music)
		self.musicSyncItem = QRadioButton(i18n("Add and delete tracks on the music player to match Lsongs"),music)
		playlists = QVButtonGroup(i18n('Playlists'),container)
		self.playlistUnionItem = QRadioButton(i18n("Synchronize all playlists between Lsongs and the music player"),playlists)
		self.playlistAddItem = QRadioButton(i18n("Add playlists to the music player that have been added to Lsongs"),playlists)
		self.playlistSyncItem = QRadioButton(i18n("Add and delete playlists on the music player to match Lsongs"),playlists)
		containerLayout.addWidget(playlists)

	#def addStoreItems(self):
	#	pass
	#	page = self.addPage(i18n("Store"))

	#def addAdvancedItems(self):
	#	pass
	#	page = self.addPage(i18n("Advanced"))

	def addHDivider(self,container,containerLayout):
		containerLayout.addItem(QSpacerItem(1,2,QSizePolicy.Expanding,QSizePolicy.Fixed))
		w = QWidget(container)
		w.setPaletteBackgroundColor(QColor(0,0,0))
		w.setFixedHeight(1)
		w.setSizePolicy(QSizePolicy.Expanding,QSizePolicy.Fixed)
		containerLayout.addWidget(w)
		containerLayout.addItem(QSpacerItem(1,2,QSizePolicy.Expanding,QSizePolicy.Fixed))

	def load(self):
		self.loadGeneralItems()
		self.loadImportingItems()
		self.loadCDItems()
		self.loadSharingItems()
		self.loadPlayerItems()
		#self.loadStoreItems()
		#self.loadAdvancedItems()
	
	def loadGeneralItems(self):
		pass
	
	def loadImportingItems(self):
		self.pathItem.setText(Library.mainLibrary().musicPath())
		if self.settings.get('Managed',True):
			self.manageRadio.setOn(True)
		else:
			self.unmanageRadio.setOn(True)
		self.modifyTagsCheckbox.setOn(self.settings.get('Modify Tags',False))

	def loadCDItems(self):
		self.onCDInsertItem.setCurrentText(self.insertActions.get(self.settings.get("CD Insertion Action",'show'),"<Unknown>"))
		self.importUsingItem.setCurrentText(self.encoders.get(self.settings.get("Encoder","mp3"),"<Unknown>"))
		self.importSettingsItem.setCurrentText(self.qualities.get(self.settings.get("Encoder Bit Rate",128000),"<Unknown>"))
		self.useErrorCorrectionItem.setOn(self.settings.get("CD Error Correction",False))
		self.useVBRItem.setOn(self.settings.get("Encoder VBR",False))
		self.burnDiscTypeItem.setCurrentText(self.burnDiscTypes.get(self.settings.get("Burn Disc Type",'audio'),"<Unknown>"))
		self.ripNiceItem.setValue(-self.settings.get("Ripper Nice",10))
		self.encodeNiceItem.setValue(-self.settings.get("Encoder Nice",10))

	def loadSharingItems(self):
		self.lookForOtherProgramsItem.setOn(self.settings.get("Look For Lsongs",True))
		#self.lookForDevicesItem.setOn(self.settings.get("Look For Devices",False))
		self.shareWithOtherProgramsItem.setOn(self.settings.get("Share With Lsongs",False) or self.settings.get("Share With DAAP",False))
		self.shareWithDevicesItem.setOn(self.settings.get("Share With SliMP3",False) or self.settings.get("Share With Twonky",False))
		playlists = Library.mainLibrary().getShareablePlaylists()
		for playlist in playlists:
			item = LPrefsPlaylistItem(self.sharedPlaylists,playlist)
			item.setOn(playlist.shared)
		self.shareNameEdit.setText(self.settings.get("Share Name",socket.gethostname()))
		self.shareAllowWritesItem.setOn(self.settings.get("Share Allow Writes",False))
		self.shareAllItem.setOn(self.settings.get("Share All",False))
		self.sharePlaylistsItem.setOn(not self.settings.get("Share All",False))
		self.sharedPlaylists.setEnabled(self.sharePlaylistsItem.isOn())
		self.hitSharingItem(QButton.On)
		if self.settings.get('Share With Lsongs',False) or self.settings.get('Share With DAAP',False) or self.settings.get("Share With SliMP3",False) or self.settings.get("Share With Twonky",False):
			self.shareStatusItem.setText(i18n('Status: Sharing on'))
		else:
			self.shareStatusItem.setText(i18n('Status: Sharing off'))
	
	def loadPlayerItems(self):
		playerMusic = self.settings.get("Player Music Sync","union")
		self.musicUnionItem.setOn(playerMusic=='union')
		self.musicAddItem.setOn(playerMusic=='add')
		self.musicSyncItem.setOn(playerMusic=='sync')
		playerPlaylist = self.settings.get("Player Playlist Sync","union")
		self.playlistUnionItem.setOn(playerPlaylist=='union')
		self.playlistAddItem.setOn(playerPlaylist=='add')
		self.playlistSyncItem.setOn(playerPlaylist=='sync')

	#def loadLookingItems(self):
	#	pass

	#def loadStoreItems(self):
	#	pass
		
	#def loadAdvancedItems(self):
	#	pass

	def unload(self):
		self.unloadGeneralItems()
		self.unloadImportingItems()
		self.unloadCDItems()
		self.unloadSharingItems()
		self.unloadPlayerItems()
		#self.unloadStoreItems()
		#self.unloadAdvancedItems()
		LSettings.singleton().writeXMLFile()
		lib = Library.mainLibrary()
		lib.markDirty()
		LsongsSharing.singleton().fromSettings()
		
	def unloadGeneralItems(self):
		pass
	
	def unloadImportingItems(self):
		self.settings['Managed'] = self.manageRadio.isOn()
		self.settings['Modify Tags'] = self.modifyTagsCheckbox.isOn()
		self.settings['Main Library Path'] = unikode(self.pathItem.text())
	
	def unloadCDItems(self):
		self.settings['CD Insertion Action'] = self.insertActionsKeys[self.onCDInsertItem.currentItem()]
		self.settings['Encoder'] = self.encodersKeys[self.importUsingItem.currentItem()]
		self.settings['Encoder Bit Rate'] = self.qualitiesKeys[self.importSettingsItem.currentItem()]
		self.settings['CD Error Correction'] = self.useErrorCorrectionItem.isOn()
		self.settings['Encoder VBR'] = self.useVBRItem.isOn()
		self.settings['Burn Disc Type'] = self.burnDiscTypesKeys[self.burnDiscTypeItem.currentItem()]
		self.settings['Ripper Nice'] = -self.ripNiceItem.value()
		self.settings['Encoder Nice'] = -self.encodeNiceItem.value()

	def unloadSharingItems(self):
		self.settings['Look For Lsongs'] = self.lookForOtherProgramsItem.isOn()
		#self.settings['Look For Devices'] = self.lookForDevicesItem.isOn()
		shareWithOthers = self.shareWithOtherProgramsItem.isOn()
		shareWithDevices = self.shareWithDevicesItem.isOn()
		self.settings['Share With Lsongs'] = shareWithOthers
		self.settings['Share With DAAP'] = shareWithOthers
		self.settings['Share With SliMP3']= shareWithDevices
		self.settings['Share With Twonky']= shareWithDevices
		if shareWithOthers or shareWithDevices:
			item = self.sharedPlaylists.firstChild()
			while item:
				item.playlist.shared = item.isOn()
				item = item.nextSibling()
			self.settings['Share Allow Writes'] = self.shareAllowWritesItem.isOn()
		self.settings["Share Name"] = unikode(self.shareNameEdit.text())
		self.settings['Share All'] = self.shareAllItem.isOn()

	def unloadPlayerItems(self):
		if self.musicUnionItem.isOn(): self.settings['Player Music Sync'] = 'union'
		if self.musicAddItem.isOn(): self.settings['Player Music Sync'] = 'add'
		if self.musicSyncItem.isOn(): self.settings['Player Music Sync'] = 'sync'
		if self.playlistUnionItem.isOn(): self.settings['Player Playlist Sync'] = 'union'
		if self.playlistAddItem.isOn(): self.settings['Player Playlist Sync'] = 'add'
		if self.playlistSyncItem.isOn(): self.settings['Player Playlist Sync'] = 'sync'

	#def unloadStoreItems(self):
	#	pass
		
	#def unloadAdvancedItems(self):
	#	pass

