#
# LRemoteTrackDrag.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import QStoredDrag

_remotetrackmimetype = 'application/x-remotetrack'

#
# this class encapsulates a drag from a track list - all that's transferred
# is a list of trackIDs
#
class LRemoteTrackDrag(QStoredDrag):
	def __init__(self,tracks,playlist,widget):
		QStoredDrag.__init__(self,_remotetrackmimetype,widget)
		tracks = map(lambda track:track.getPList(),tracks)
		packet = {'Tracks':tracks}
		#print packet
		self.setEncodedData(str(packet))
		#print "encoded drag"

	def trackIDs(self):
		packet = eval(self,encodedData(_remotetrackmimetype))
		return packet['TrackIDs']

	def playlistName(self):
		packet = eval(self,encodedData(_remotetrackmimetype))
		return packet['Playlist']
	
	def class_canDecode(cls,event):
		return event.provides(_remotetrackmimetype)

	canDecode = classmethod(class_canDecode)

	def class_decode(cls,event):
		return eval(str(event.encodedData(_remotetrackmimetype)))

	decode = classmethod(class_decode)
