#
# LSharedPlaylistsSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from kdeui import *
from Library import *
from LSourceViewItem import *
from LRemoteLibrary import *
from LServiceInfoDialog import *
from LSharedPlaylistSourceViewItem import *
from LPlaylistDrag import *
from LMusicUploader import *
from utils import *

#
# Shared playlists (group)
#
class LSharedPlaylistsSourceViewItem(LSourceViewItem):
	def __init__(self,container,name,type,address,port):
		LSourceViewItem.__init__(self,container,name)
		self.name = name
		self.type = type
		self.address = address
		self.port = port
		self.hasContextMenu = True
		self.library = LRemoteLibrary(name,address,port)
		self.library.connect(PYSIGNAL("addedPlaylist"),self.addedPlaylist)
		self.library.connect(PYSIGNAL("removedPlaylist"),self.removedPlaylist)
		self.library.connect(PYSIGNAL("fetchedPlaylists"),self.didFetch)
		self.library.connect(PYSIGNAL("unmount"),self.unmount)
		self.setDropEnabled(True)

	def makeKey(self):
		return 'D'+str(self.name)

	def iconFileName(self): return "sourcesharedmusic.png"

	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		id = self.popup.insertItem(i18n("Get Info"),self.getInfo)
		self.syncID = self.popup.insertItem(i18n("Sync"),self.sync)
		self.addPlaylistID = self.popup.insertItem(i18n("Add Playlist"),self.addPlaylist)
		self.unmountID = self.popup.insertItem(i18n("Unmount"),self.unmount)
		self.updatePopup()

	def unmount(self):
		list = self.listView()
		if list:
			list.removeSharedLsongs(self.name)
			self.library = None

	def didFetch(self):
		self.updatePopup()

	def updatePopup(self):
		if self.popup:
			self.popup.setItemEnabled(self.syncID,self.library.allowWrites)
			self.popup.setItemEnabled(self.addPlaylistID,self.library.allowWrites)

	def getInfo(self):
		dialog = LServiceInfoDialog(self.name,self.type,self.address,self.port)
		dialog.exec_loop()
	
	def sync(self):
		#print "syncing"
		self.library.syncWith(Library.mainLibrary())

	def addPlaylist(self):
		(name,ok) =  KInputDialog.getText(i18n("Add Shared Playlist"),i18n("Name of new playlist:"),"untitled Playlist")
		if ok:
			name = unikode(name)
			if len(name)>0:
				self.library.addNewPlaylist(name)
				#self.library.fetchPlaylists()  # XXX DSM should we force this?
		
	def select(self,container):
		self.setOpen(not self.isOpen())
		if self.isOpen():
			self.library.getPlaylists() # force fetch if not loaded yet

	def acceptDrag(self,event):
		if self.library.allowWrites:
			if LPlaylistDrag.canDecode(event): return True
		return False
	
	def dropped(self,event):
		if LPlaylistDrag.canDecode(event):
			drag = LPlaylistDrag.decode(event)
			library = Library.mainLibrary()
			playlist = library.playlistWithName(drag['Playlist'])
			if playlist:
				tracks = playlist.getTracks()
				LMusicUploader.singleton().uploadTracks(tracks,playlist,self.library)

	def addedPlaylist(self,library,playlist):
		#print "remote source item added remote playlist",playlist.name
		LSharedPlaylistSourceViewItem(self,playlist)
	
	def removedPlaylist(self,library,playlist):
		#print "remote source item removed remote playlist",playlist.name
		item = self.firstChild()
		while item:
			#print "checking",item.playlist.name
			if item.playlist==playlist:
				if item.isSelected():
					#print item.playlist.name,"is selected!"
					list = self.listView()
					if list:
						list.setSelected(list.master,True)
						list.master.select(list)
				self.takeItem(item)
				del item
				break
			item = item.nextSibling()

	def isChildSelected(self):
		item = self.firstChild()
		while item:
			if item.isSelected: return True
			item = item.nextSibling()
		return False
