from qt import *
from kdeemul import i18n
from human import *
from LStatusProgressBar import *
from LMusicDellSyncer import *
from LPixmapPushButton import *
from LsongsPaths import *

_backColor = QColor(172,191,238)

class LStatusDellSyncerProgressView(QWidget):
	def __init__(self,container,statusView):
		global _backColor
		QWidget.__init__(self,container)
		self.statusView = statusView
		self.setPaletteBackgroundColor(_backColor)
		self.buildViews()
		QObject.connect(LMusicDellSyncer.singleton(),PYSIGNAL("status"),self.progress)
	
	def buildViews(self):
		#f = QFont("fixed",6)
		hlayout = QHBoxLayout(self)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		vlayout = QVBoxLayout()
		vlayout.setSpacing(-5)
		hlayout.addLayout(vlayout,100)
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		#self.title = QLabel(i18n("Song Name"),self)
		self.title = KSqueezedTextLabel(self)
		self.title.setText("Song Name")
		#self.title.setFont(f)
		self.title.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.title)
		self.elapsed = QLabel(i18n("Completion"),self)
		#self.elapsed.setFont(f)
		self.elapsed.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.elapsed)
		playout = QHBoxLayout()
		vlayout.addLayout(playout)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		self.progressView = LStatusProgressBar(self)
		playout.addWidget(self.progressView,100)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		#vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		cancelIcon = QIconSet(QPixmap(art("buttonstatuscancel.png")))
		self.cancelButton = LSmallPixmapPushButton(cancelIcon,"",self)
		QToolTip.add(self.cancelButton,i18n("Cancel the current sync"))
		QObject.connect(self.cancelButton,SIGNAL("clicked()"),self.cancelSync)
		hlayout.addWidget(self.cancelButton)
		
	def progress(self,status):
		#print "status view got progress"
		self.progressView.progress(status)
		state = status['Status']
		if state=='Begin':
			self.title.setText(i18n("Preparing Sync"))
			self.elapsed.setText('')
			self.statusView.showStatus(self)
		elif state=='Removing':
			self.title.setText(i18n("Removing Tracks"))
			self.elapsed.setText('')
		elif state=='Exporting':
			self.title.setText(state+': '+status['Track'].title)
			self.elapsed.setText(unikode(i18n("%d of %d")) % (int(status['currentTime'])+1,status['totalTime']))
		elif state=='End':
			self.statusView.hideStatus(self)

	def cancelSync(self):
		LMusicDellSyncer.killCurrentDellSyncer()
