#
# "@(#) $Id: LStatusPlayerProgressView.py,v 1.13 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from human import *
from LStatusSeekableProgressBar import *
from LPixmapPushButton import *
from LMusicPlayer import *
from utils import *

_backColor = QColor(172,191,238)

class LTimeLabel(QLabel):
	def __init__(self,text,parent):
		QLabel.__init__(self,text,parent)
		self.mode = "elapsed"
		self.current = 0
		self.total = 0
		self.isStream = False
		self.modes = {'elapsed':'remaining','remaining':'total','total':'elapsed'}
	
	def reset(self):
		self.mode = 'elapsed'
		self.load()

	def mouseReleaseEvent(self,event):
		if self.isStream:
			self.mode = 'elapsed'
		else:
			self.mode = self.modes[self.mode]
		self.load()
		
	def progress(self,current,total,isStream):
		self.current = current
		self.total = total
		self.isStream = isStream
		self.load()
	
	def load(self):
		if self.mode=='elapsed':
			self.doSetText(unikode(i18n('Elapsed Time: %s')) % humanDuration(self.current))
		elif self.mode=='remaining':
			self.doSetText(unikode(i18n('Remaining Time: %s')) % humanDuration(self.total-self.current))
		elif self.mode=='total':
			self.doSetText(unikode(i18n('Total Time: %s')) % humanDuration(self.total))
		else:
			self.doSetText('')
	
	def doSetText(self,text):
		if text!=unikode(self.text()):
			self.setText(text)

class LNameLabel(KSqueezedTextLabel):
	def __init__(self,parent):
		KSqueezedTextLabel.__init__(self,parent)
		self.lastText = ""
		self.mode = 'title'
		self.track = None
		self.timerDuration = 8000
		self.startTimer(self.timerDuration)
	
	def reset(self):
		self.mode = 'title'
		self.load()
		self.killTimers()
		self.startTimer(self.timerDuration)

	def timerEvent(self,event):
		self.advanceMode()
	
	def mouseReleaseEvent(self,event):
		self.advanceMode()
		self.killTimers()
		self.startTimer(self.timerDuration)
	
	def advanceMode(self):
		if self.track:
			if self.track.isStream and not self.track.lsongs:
				self.mode=='title'
			else:
				if self.mode=='title':
					if self.track.artist:
						self.mode = 'artist'
					elif self.track.album:
						self.mode = 'album'
				elif self.mode=='artist':
					if self.track.album:
						self.mode = 'album'
					else:
						self.mode = 'title'
				elif self.mode=='album':
					self.mode = 'title'
				pass
			self.load()

	def setTrack(self,track):
		self.track = track
		self.load()
	
	def load(self):
		text = ''
		if self.track:
			if self.mode=='title': text = self.track.title
			elif self.mode=='artist': text = self.track.artist
			elif self.mode=='album': text = self.track.album
		if text==None or text=='':
			text = i18n('Connecting')
		self.doSetText(text)

	def doSetText(self,text):
		if text!=self.lastText:
			self.setText(text)
			self.lastText = text

class LStatusPlayerProgressView(QWidget):
	def __init__(self,container,statusView):
		global _backColor
		QWidget.__init__(self,container)
		self.statusView = statusView
		self.setPaletteBackgroundColor(_backColor)
		self.track = None
		self.buildViews()
		QObject.connect(LMusicPlayer.singleton(),PYSIGNAL("status"),self.progress)
	
	def buildViews(self):
		#f = QFont("fixed",9)
		hlayout = QHBoxLayout(self)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		vlayout = QVBoxLayout()
		vlayout.setSpacing(-5)
		hlayout.addLayout(vlayout,100)
		self.title = LNameLabel(self)
		self.title.setText("Song Name")
		self.title.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.title)
		self.elapsed = LTimeLabel(i18n("Elapsed Time"),self)
		self.elapsed.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.elapsed)
		playout = QHBoxLayout()
		vlayout.addLayout(playout)
		self.progressBar = LSeekableStatusProgressBar(self)
		QObject.connect(self.progressBar,PYSIGNAL("seeked"),self.doSeek)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		playout.addWidget(self.progressBar,100)
		playout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		self.currentSong = KSqueezedTextLabel(self)
		self.currentSong.setText("")
		self.currentSong.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.currentSong)
		self.currentSong.hide()
		bookmarkIcon = QIconSet(QPixmap(art("buttonstatusbookmark.png")))
		self.bookmarkButton = LSmallPixmapPushButton(bookmarkIcon,"",self)
		QToolTip.add(self.bookmarkButton,i18n("Bookmark the current station"))
		QObject.connect(self.bookmarkButton,SIGNAL("clicked()"),self.bookmarkStream)
		hlayout.addWidget(self.bookmarkButton)
	
	def bookmarkStream(self):
		if self.track:
			self.track.bookmark()
			QMessageBox.information(None,i18n("Station Bookmarked"),i18n("The currently playing station has been bookmarked"))

	def progress(self,status):
		#return
		self.progressBar.progress(status)
		state = status['Status']
		if state=='Begin':
			#print "player status got begin"
			self.elapsed.reset()
			self.elapsed.setText('')
			self.statusView.showStatus(self)
			track = status['Track']
			self.track = track
			self.title.reset()
			self.title.setTrack(track)
			self.progressBar.setHidden(track.isStream)
			self.currentSong.setHidden(not track.isStream or track.lsongs)
			self.bookmarkButton.setHidden(True)
		elif state=='Connecting':
			#print "player status got connecting"
			track = status['Track']
			self.currentSong.setText(track.location)
			self.statusView.showStatus(self)
			self.title.text = 'Connecting'
		elif state=='Playing':
			track = status['Track']
			self.title.setTrack(track)
			if track.isStream and not track.lsongs:
				self.currentSong.setText(status['Current Title'])
			self.elapsed.progress(status['currentTime'],track.totalTime,track.isStream and not track.lsongs)
			self.bookmarkButton.setHidden(not track.isStream or track.genre==None or track.lsongs)
		elif state=='End':
			self.statusView.hideStatus(self)

	def doSeek(self,fraction,newTime,totalTime):
		#print "seeking to",newTime,"of",totalTime,"(",int(fraction*1000/10.0),"%)"
		LMusicPlayer.seek(newTime)
