#
# "@(#) $Id: LTrackDrag.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import QStoredDrag

_trackmimetype = 'application/x-trackid'

#
# this class encapsulates a drag from a track list - all that's transferred
# is a list of trackIDs
#
class LTrackDrag(QStoredDrag):
	def __init__(self,trackIDs,playlist,widget):
		QStoredDrag.__init__(self,_trackmimetype,widget)
		packet = {'Playlist':playlist.name,'TrackIDs':trackIDs}
		self.setEncodedData(str(packet))
		#print "encoded drag"

	def trackIDs(self):
		packet = eval(self,encodedData(_trackmimetype))
		return packet['TrackIDs']

	def playlistName(self):
		packet = eval(self,encodedData(_trackmimetype))
		return packet['Playlist']
	
	def class_canDecode(cls,event):
		return event.provides(_trackmimetype)

	canDecode = classmethod(class_canDecode)

	def class_decode(cls,event):
		return eval(str(event.encodedData(_trackmimetype)))

	decode = classmethod(class_decode)
