#
# "@(#) $Id: LTrackViewItemObject.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
import weakref

class LTrackViewItemObject(QObject):
	def __init__(self,trackItem):
		self.trackItem = weakref.ref(trackItem)
		try:
			self.track = self.trackItem().track()
			self.track.connect(PYSIGNAL("changedAttribute"),self.changedAttribute)
			self.track.connect(PYSIGNAL("ripStatus"),self.ripStatus)
		except: pass
	
	def changedAttribute(self,track,attribute,oldValue,newValue):
		#print track,": (",attribute,") changed from (",oldValue,") to (",newValue,")"
		self.trackItem().changedAttribute(attribute,oldValue,newValue)
	
	def ripStatus(self,track,status):
		self.trackItem().ripStatus(track,status)
