#
# LTrashSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from LSourceView import *
from LPlaylistDrag import *
from LTrackDrag import *
from LDellTrackDrag import *
from LDellPlaylistDrag import *
from LPodTrackDrag import *
from LPodPlaylistDrag import *
from DellLibrary import *

#
# "Trash"
#
class LTrashSourceViewItem(LSourceViewItem):
	def __init__(self,container):
		LSourceViewItem.__init__(self,container,i18n('Trash'))
		self.wantsTrackDrags = True
		self.wantsPlaylistDrags = True
		self.wantsDellPlaylistDrags = True
		self.wantsDellTrackDrags = True
		self.wantsPodPlaylistDrags = True
		self.wantsPodTrackDrags = True
		self.wantsEncoderDrags = True
		self.canEmpty = True

	def makeKey(self):
		return 'L'

	def iconFileName(self): return "sourcetrash.png"
	
	def select(self,container):
		container.emit(PYSIGNAL('selectTrash'),(None,None))
	
	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		self.emptyid = self.popup.insertItem(i18n("Empty &Trash"),mainWindow.slotEmptyTrash)
	
	def loadPopup(self):
		self.popup.setItemEnabled(self.emptyid,self.trash.hasTracks())

	#
	# handle drags to the trash
	#
	# if drag is playlist, remove the playlist
	# if drag is tracks:
	#    if source is playlist, remove tracks from playlist
	#    if source is library, remove tracks from all playlists and put in trash
	#    if source is MP3 player, remove tracks or playlists from player
	#
	def dropped(self,event):
		if LPlaylistDrag.canDecode(event):
			drag  = LPlaylistDrag.decode(event)
			playlist = self.library.playlistWithName(drag['Playlist'])
			if playlist:
				self.library.removePlaylist(playlist)
		elif LTrackDrag.canDecode(event):
			drag = LTrackDrag.decode(event)
			#print "trash got",drag
			playlist = self.library.playlistWithName(drag['Playlist'])
			trackIDs = drag['TrackIDs']
			if not playlist == self.trash:
				if playlist == self.libraryPlaylist:
					self.trash.addTrackIDs(trackIDs)
					self.library.removeTrackIDsFromAllPlaylists(trackIDs)
				else:
					playlist.removeTrackIDs(trackIDs)
		elif LDellPlaylistDrag.canDecode(event):
			drag = LDellPlaylistDrag.decode(event)
			lib = DellLibrary().singleton()
			playlist = lib.playlistWithName(drag['Playlist'])
			if playlist:
				from LMusicDellManager import LMusicDellManager
				LMusicDellManager.singleton().removePlaylist(playlist)
		elif LDellTrackDrag.canDecode(event):
			drag = LDellTrackDrag.decode(event)
			lib = DellLibrary.singleton()
			playlist = lib.playlistWithName(drag['Playlist'])
			trackIDs = drag['TrackIDs']
			if playlist:
				from LMusicDellManager import LMusicDellManager
				LMusicDellManager.singleton().removeTrackIDsFromPlaylist(playlist,trackIDs)
		elif LPodPlaylistDrag.canDecode(event):
			drag = LPodPlaylistDrag.decode(event)
			lib = PodLibrary().singleton()
			playlist = lib.playlistWithName(drag['Playlist'])
			if playlist:
				from LMusicPodManager import LMusicPodManager
				LMusicPodManager.singleton().removePlaylist(playlist)
		elif LPodTrackDrag.canDecode(event):
			drag = LPodTrackDrag.decode(event)
			lib = PodLibrary.singleton()
			playlist = lib.playlistWithName(drag['Playlist'])
			trackIDs = drag['TrackIDs']
			if playlist:
				from LMusicPodManager import LMusicPodManager
				LMusicPodManager.singleton().removeTrackIDsFromPlaylist(playlist,trackIDs)
		elif LEncoderTrackDrag.canDecode(event):
			drag = LEncoderTrackDrag.decode(event)
			trackIDs = drag['TrackIDs']
			e = EncoderLibrary.singleton()
			e.removeTrackIDsFromAllPlaylists(trackIDs)
			e.killTrackIDs(trackIDs)
