#!/usr/bin/python

from musicgenres import *

exceptions = {'talk':'Speech','music':'Other','world':'Ethnic','70s':'Oldies','80s':'Oldies','90s':'Oldies','eclectic':'Alternative',\
	'sports':'Speech', 'christian':'Contemporary Christian','greek':'Ethnic','floyd':'Classic Rock',\
	'mixed':'Other','top40':'Top 40','funkjazztechnoporn':'Funk','news':'Speech','russian':'Ethnic',\
	'koreamusic':'Ethnic','all':'Other','francais':'Ethnic','indian':'Ethnic','koreapop':'Pop',
	'iranian':'Ethnic','kpop':'Pop','various':'Other','senegal':'Ethnic','unknown':'Other',
	'autopilot':'Other','live':'Other','downtempo':'Ambient','hyva':'Ethnic','nanpasun':'Pop',\
	'automusic':'Other','idm':'Other','hop':'Hip-Hop','nederland':'Ethnic','nederlands':'Ethnic','spiritual':'Other',\
	'easy':'Easy Listening','grateful':'Classic Rock','praise':'Contemporary Christian','eastern':'Ethnic',\
	'hungary':'Ethnic','africa':'Ethnic','tamil':'Ethnic','hits':'Top 40','electropunk':'Electronic',\
	'40':'Top 40','college':'Indie','npr':'Speech','rnb':'R&B','party':'Club','urdu':'Ethnic','everything':'Other',\
	'death':'Death Metal','varied':'Other','hindi':'Other','gong':'Ethnic','greenpeace':'Speech',\
	'time':'Oldies','wicked':'Trash Metal','dj':'Club','bouncy':'Pop','mix':'Other','mystic':'Dream',\
	'top20':'Top 40','romanian':'Ethnic','soft':'Easy Listening','americana':'Country','railraod':'Speech',\
	'vietnamese':'Ethnic','hardtrance':'Trance','80':'Oldies','japanese':'Ethnic','progressive':'Progressive Rock',\
	'madagascar':'Ethnic','scanner':'Speech','indonesia':'Ethnic','ham':'Speech','african':'Ethnic','irish':'Ethnic',\
	'kurdish':'Ethnic','upbeat':'Pop','chillout':'Ambient','police':'Speech','mexico':'Ethnic',\
	'jewish':'Ethnic','punkrock':'Punk','turkish':'Ethnic','persian':'Ethnic','railroad':'Speech',\
	'turkish':'Ethnic','punjabi':'Ethnic','bulgarian':'Ethnic','hawaiian':'Ethnic','catolico':'Speech',\
	'catolica':'Speech','classicrock':'Classic Rock','dancehall':'Dance','bestmusic':'Top 40',\
	'malay':'Ethnic','goth':'Gothic','radiohead':'Rock','underground':'Indie','best':'Oldies',\
	'nugs':'Trance','gaming':'Game','shock':'Avant Garde','feral':'Jungle','breakbeat':'Club',\
	'romania':'Ethnic','hollands':'Ethnic','chinese':'Ethnic','turkce':'Ethnic','chansons':'Vocal',\
	'zikler':'Ethnic','esports':'Ethnic','random':'Other','community':'Speech','najjaca':'Ethnic',\
	'noshmim':'Ethnic','narodna':'Ethnic','netg':'Ethnic','musikk':'Other','blabla':'Speech',\
	'n':'Other','blackbeats':'House','nederlandstalig':'Other','zouk':'Ethnic','c64':'Game',\
	'schl':'House','komercja':'Ethnic','nacional':'Speech','muzica':'Ethnic','dmb':'Ethnic',\
	'blandat':'Ethnic','info':'Speech','dmb':'Rock','dmbistation':'Rock','christrian':'Contemporary Christian',\
	'sinhala':'Ethnic','spanish':'Ethnic','euro':'Euro-Techno','juggalo':'Humor','charts':'Top 40',
	'hard':'Metal','power':'Metal'
	}

def guessGenre(sgenre):
	sgenre = sgenre.strip().lower()
	#
	# 0) see if there's anything to start with
	#
	if len(sgenre)==0:
		return "Other"
	#
	# 1) see if we're ok as is, but normalize!
	#
	for genre in musicGenres:
		if sgenre==genre.lower():
			return genre

	#
	# 2) split into words, check them in list
	#
	genres = sgenre.split()
	for g in genres:
		for genre in musicGenres:
			if g==genre.lower():
				return genre
	#
	# 3) check in exception list
	#
	for g in genres:
		if exceptions.has_key(g):
			return exceptions[g]

	#
	# 4) no found, return "Other"
	#
	return "Other"
