clc; clear; close all;

pkg load signal;
pkg load control;

sampleRate      = 48000;
faustDSPtarget  = fullfile(                             ...
                            '..',                       ...
                            '..',                       ...
                            'Faust',                    ...
                            'testBeds',                 ...
                            'hammerstein2.dsp'     ...
                            );
dataTarget      = fullfile(                             ...
                            '..',                       ...
                            '..',                       ...
                            'Faust',                    ...
                            'testBeds',                 ...
                            'hammerstein2.mat'     ...
                            );
permission      = 'w';
precision       = '%.18f';
nBranches       = 6;

[z, p, k]   = butter(2, 2 * 1000 / sampleRate, 'high');
[b, a]      = zp2tf(z, p, k);
[SOS, G]    = zp2sos(z, p, k);

orders      = 1:nBranches;

fileID = fopen(faustDSPtarget, permission);

fprintf(fileID, ...
            'fi = library("filters.lib");\nba = library("basics.lib");\nsi = library("signals.lib");\n\n' ...
            );
            
for n = 1:nBranches
    
    fprintf(fileID, ...
        ['br' num2str(n) '(brG, stG) = ^(_, ' num2str(n) ') : fi.tf22t(' ...
        num2str(SOS(1), precision) ', ' ...
        num2str(SOS(2), precision) ', ' ...
        num2str(SOS(3), precision) ', ' ...
        num2str(SOS(5), precision) ', ' ...
        num2str(SOS(6), precision) ') : ' ...
        ' *(_, ' num2str(G, precision) ') : ' ...
        '*(_, brG) : *(_, stG);\n'
        ] ...
        );
        
    fprintf(fileID,                                                         ...
            [ ...
            '\nbranch' num2str(n) ' = hgroup("[' num2str(n - 1) ']Branch' ...
            num2str(n) '", br' num2str(n) '(branchGain, branchState))\n' ...
            'with{\n'                                                   ...
            '    branchGain= hslider(' ...
            '"[0]Gain Adjust Branch ' num2str(n) ...
            '[unit:dB][style:knob]",'   ...
            '0, -120, 120, 0.1) : ba.db2linear;\n'                      ...
            '    branchState = checkbox("[1]Active") : si.smoo;\n'     ...
            '};\n\n'                                                    ...
            ]                                                           ...
            );

endfor

fprintf(fileID, 'process = _ <: ');

for n = 1:nBranches
    
    fprintf(fileID, ['branch' num2str(n)]);
    
    if isequal(n, nBranches)
        fprintf(fileID, ' :> _;\n');
    else
        fprintf(fileID, ', ');
    endif
    
endfor

fclose(fileID);

save(dataTarget, 'b', 'a');