/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * ipcsem.h - common definitions for the IPC semaphore tests
 */

#ifndef __IPCSEM_H
#define __IPCSEM_H

#include <errno.h>
#include <sys/ipc.h>
#include <sys/sem.h>


#include "test.h"
#include "usctest.h"

void cleanup(void);
void setup(void);

#define SEM_RD	0400
#define SEM_ALT	0200
#define SEM_RA	SEM_RD | SEM_ALT

#define PSEMS	10		/* a reasonable value for the number of */
				/* "primitive semaphores" per ID 	*/

key_t semkey;			/* an IPC key generated by ftok() */

union semun {
	int val;			/* value for SETVAL */
	struct semid_ds *buf;		/* buffer for IPC_STAT & IPC_SET */
	unsigned short *array;		/* array for GETALL & SETALL */
	struct seminfo *ipc_buf;	/* buffer for IPC_INFO */
};

void rm_sema(int sem_id);
void check_root();

int getipckey();
int getuserid(char *);

#endif /* ipcsem.h */
