<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
/*
 * This MILLE-XTERM Configurateur attribute class. This object
 * make association betwen a node or computer and attribute
 * definition.
 *
 * Author: Nicolas Dufresne
 * Last Modification:
 *               05 aug 2004 Nicolas Dufresnes <nicolas@revolutionlinux.com>
 *               - Creation
 */

require_once 'Attribute.php';
require_once 'dbFunctions.php';

class AttributeDef {

	var $def_id;
	var $name;
	var $type;
	var $mask;
	var $editable;
	var $selection;
	var $lastError;
	var $isError;
	var $notFound;

	function AttributeDef($id) {
		$this->isError = false;
		$this->noFound = false;

		if (is_numeric($id)) {
			if (!$attributeDef = $this->getFromDB("*", "id=".$id)) return;
		}
		else if (is_array($id)) {
			$attributeDef = $id;
		}
		//get something like static object
		else if($id=="static"){
			//do nothing
		}
		else {
			$this->isError = true;
			$this->lastError = getMessage('bad_id')."id=".$id;
			return;
		}

		$this->def_id = $attributeDef['id'];
		$this->name = $attributeDef['name'];
		$this->type = $attributeDef['attributetype'];
		$this->mask = $attributeDef['mask'];
		$this->editable = $attributeDef['editable'];
	}

	// private
	function getFromDB($column,$where,$from="attributesDef",$isFatal=true, $multiple = false) {
		if ($multiple) {
			$result = select('SELECT '.$column.' FROM '.$from.' WHERE '.$where);
		}
		else {
			$result = singleResultSelect('SELECT '.$column.' FROM '.$from.' WHERE '.$where);
		}

		if (!$result) {
			if (($from == "attributesDef") && $isFatal) $this->lastError = getMessage('attribute_not_found')." : ".$where;
			else  $this->lastError = getMessage('not_found').'SELECT '.$column.' FROM '.$from.' WHERE '.$where;
			$this->notFound = true;
			if ($isFatal) $this->isError = true;
			return NULL;
		}
		elseif (!is_array($result)) {
			$this->lastError = getMessage('db_error').$result." : ".'SELECT '.$column.' FROM '.$from.' WHERE '.$where;
			if ($isFatal) $this->isError = true;
			return NULL;
		}
		else return $result;
	}

	// private
	function updateDB($toSet,$table="attributesDef", $where = "id") {
		if ($where == "id") $where .= "=".$this->id;
		if ($error = write("UPDATE ".$table." SET ".$toSet." WHERE id=".$this->id)) {
			$this->lastError = getMessage('db_write_error').$error." : "."UPDATE ".$table." SET ".$toSet." WHERE ".$where;
			return false;
		}
		else return true;
	}


	//////////////////////////////////////////////////////////////////
	// Getters
	//////////////////////////////////////////////////////////////////

	function getAttributeDefID() {
		return $this->def_id;
	}

	function getName() {
		return $this->name;
	}

	function getType() {
		return $this->type;
	}

	function getValue() {
		return NULL;
	}

	function getMask() {
		return $this->mask;
	}

	function getEditable() {
		return $this->editable;
	}

	// Use Lazy loading for selection
	function getSelection() {
		if (!is_array($this->selection) && ($this->type >= 1 || $this->editable)) {
			$dictionary = $this->getFromDB("value", "attributesdef_id=".$this->def_id." ORDER BY sortval,value", "attributesDefDict", true, true);
			if (is_null($dictionary)){
				if($this->notFound) $this->lastError=null;
				return;
			}
			foreach ($dictionary as $value) {
				$this->selection[$value['value']] = false;
			}
		}
		return $this->selection;
	}

	function isError() {
		return $this->isError;
	}


	function lastError() {
		return $this->lastError;
	}

	function notFound() {
		return $this->NotFound;
	}

	//////////////////////////////////////////////////////////////////
	// Setters
	//////////////////////////////////////////////////////////////////

	function buildAttribute ($node,$value) {
		if ($this->type == 0) {
			if (!ereg($this->mask,$value)) {
				$this->lastError = getMessage('invalide_value').$this->name." = ".$value;
				return false;
			}
		}
		$insertQuery = "INSERT INTO Attributes (nodes_id,attributesdef_id,value)" .
							"VALUES (".$node->getID().",".$this->def_id.",'')";
		if ($error = write($insertQuery)) {
			$this->lastError = getMessage('db_error').$error." : ".$insertQuery;
			return false;
		}
		if (!$result = $this->getFromDB("*","nodes_id=".$node->getID()." AND attributesdef_id=".$this->def_id,"attributes")) return false;
			$attr = new Attribute($result);
		if ($attr->isError()) {
			$this->lastError = $attr->lastError();
			return false;
		}
		$attr->setValue($value);
		return $attr;
	}
/**
 * This function delete a specific value from the dictionary table (attributesdefdict)
 */
	function deleteDictValue($value) {
		$error = NULL;
		delete("DELETE FROM attributesdefdict WHERE attributesdef_id=".$this->def_id." AND value=".qstr($value)."");
		if ($error) $error.= " : ";
		$error .= delete("DELETE FROM attributesdefdict WHERE attributesdef_id=".$this->def_id." AND value=".qstr($value)."");
		return $error;
	}
/**
 * This function insert a specific value to the dictionary table (attributesdefdict)
 */
	function insertDictValue($value) {
		$error = NULL;
		//Validation of value
	    if (!ereg($this->mask,$value)) {
	  	  $this->lastError = getMessage('invalide_value').$this->name." = ".$value."(".$this->mask.")";
		  return $this->lastError;
		}
		if (!(strlen($value) > 0)) {
			$this->lastError = getMessage('error_creating_def').getMessage('empty_def_name');
		return $this->lastError;
	    }
		//sortval is not managed. New attribute list is always at last position
		//$result = singleResultSelect("SELECT MAX(sortval) as nextsortval FROM attributesdefdict WHERE attributesdef_id=".$this->def_id);
		//$sortval=1+$result['nextsortval'];
		$sortval=0;
		$insertQuery ="INSERT INTO attributesdefdict (attributesdef_id,value,sortval) VALUES (".$this->def_id.",".qstr($value).",".$sortval.")";
		if ($error = write($insertQuery)) {
			$this->lastError = getMessage('db_error').$error." : ".$insertQuery;
			return $this->lastError;
		}else{
			return null;
		}

	}

/**
 * This function update the dictionary table (attributesdefdict)
 * $oldValue is one of the primary key
 */
	function updateDictValue($value,$oldValue) {
		$error = NULL;
		//Validation of value
	    if (!ereg($this->mask,$value)) {
	  	  $this->lastError = getMessage('invalide_value').$this->name." = ".$value."(".$this->mask.")";
		  return $this->lastError;
		}
	    if (!(strlen($value) > 0)) {
			$this->lastError = getMessage('error_creating_def').getMessage('empty_def_name');
		return $this->lastError;
	    }
		//sortval is not managed. New attribute list is always at last position
		$updateQuery ="UPDATE attributesdefdict SET value=".qstr($value)." WHERE attributesdef_id=".$this->def_id." AND value=".qstr($oldValue)."";
		if ($error = write($updateQuery)) {
			$this->lastError = getMessage('db_write_error').$error." : ".$updateQuery;
			return $this->lastError;
		}else{
			return $this->lastError;
		}
	}

}
?>
