#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -*- Mode: Python -*-
# vi:si:ai:et:sw=4:sts=4:ts=4
#
#
# Copyright Nicolas Bertrand (nico@inattendu.org), 2009
#
# This file is part of Luciole.
#
#    Luciole is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Luciole is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Luciole.  If not, see <http://www.gnu.org/licenses/>.
#
#
"""
luciole.py :
    Main file of application luciole
"""
import lucioLib
import sys
import gtk
import os.path
from optparse import OptionParser

try:  # Import Psyco if available
    import psyco
    psyco.full()
except ImportError:
    print "psyco Not found !!"


def main(args) :
    """ Main function of program """
    try :
        gtk.gdk.threads_init()
    except :
        print " No Threading available with pyGtk, exit !!!"
        sys.exit(1)


    #parse options
    parser = OptionParser()
    parser.add_option(  "-f", 
                        "--file",
                        dest="filename",
                        help="Xml project file to load",
                        metavar="FILE")
    (options, args2) = parser.parse_args()


    # init controller

    app_ctrller = lucioLib.Luciole_controller()

    #load of a project 
    gtk.gdk.threads_enter()
    if ( options.filename and os.path.exists(options.filename)) :
        X= app_ctrller.open_project(options.filename)
    
    gtk.main()
    gtk.gdk.threads_leave()
#import cProfile
#cProfile.run('main(None)', 'profile.out')  

if __name__ == '__main__' :
    sys.exit(main(sys.argv))
