// ---------------------------------- textDialog.cpp ---------------------------------------------------------------------------
// Class to display a simple go-noGo dialog

//===============================================================================================================================
//===============================================================================================================================
//     This file is part of "luckyBackup" project
//     Copyright 2008-2009, Loukas Avgeriou
//     luckyBackup is distributed under the terms of the GNU General Public License
//     luckyBackup is free software: you can redistribute it and/or modify
//     it under the terms of the GNU General Public License as published by
//     the Free Software Foundation, either version 3 of the License, or
//     (at your option) any later version.
// 
//     luckyBackup is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
// 
//     You should have received a copy of the GNU General Public License
//     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


// project version	: Please see "main.cpp" for project version

// developer 		: luckyb 
// last modified 	: 12 Dec 2009
//===============================================================================================================================
//===============================================================================================================================

#include "textDialog.h"

// class textDialog Constructor=================================================================================================
// Displays a simple dialog with text info, ok-cancel buttons and a lineEdit for user input
textDialog::textDialog (const QString type, const QString ReplaceInput, QWidget *parent) : QDialog (parent)
{
	uiT.setupUi(this);
	uiT.checkBox_select -> setVisible(FALSE);
	uiT.label_warning -> setVisible(FALSE);
	
	//connect okay & cancel pushButton SLOTs ----------------
	connect ( uiT.pushButton_ok, SIGNAL( clicked() ), this, SLOT( okay() ) );
 	connect ( uiT.pushButton_cancel, SIGNAL( clicked() ), this, SLOT( cancel() ) );

	GoOn = 0;
	Type = type;
	if (type == "NewProfile")
	{
		uiT.label_message 	-> setText(tr("Enter the name of the new profile :"));
		uiT.lineEdit_userInput 	-> setEchoMode (QLineEdit::Normal);
	}
	if (type == "RenameProfile")
	{
		uiT.label_message 	-> setText(tr("Enter the new name of the profile :"));
		uiT.lineEdit_userInput 	-> setEchoMode (QLineEdit::Normal);
		uiT.lineEdit_userInput 	-> setText(ReplaceInput);
		uiT.lineEdit_userInput 	-> selectAll();
	}
	if (type == "ImportProfile")
	{
		uiT.label_message 	-> setText(tr("A profile with the same name already exists") + "<br>" +
			tr("Please enter a different name"));
		uiT.lineEdit_userInput 	-> setEchoMode (QLineEdit::Normal);
		uiT.lineEdit_userInput 	-> setText(ReplaceInput);
		uiT.lineEdit_userInput 	-> selectAll();
	}
	if (type == "password")
	{
		uiT.label_message 	-> setText(tr("Enter pasword :"));
		uiT.lineEdit_userInput 	-> setEchoMode (QLineEdit::Password);
	}
	if (type == "passphrase")
	{
		uiT.label_message 	-> setText(tr("Enter passphrase :"));
		uiT.lineEdit_userInput 	-> setEchoMode (QLineEdit::Password);
	}
	if (type == "CloneWarning")
	{
		uiT.checkBox_select -> setVisible(TRUE);
		uiT.label_warning -> setVisible(TRUE);
		uiT.checkBox_select -> setText (tr("Do not show this again for this task"));
		uiT.lineEdit_userInput 	-> setVisible(FALSE);
		uiT.label_message 	-> setText(tr("You have selected to \"Backup the contents of the source directory\"<br>together with the \"delete files on the destination\" option") +"<br><br>" + tr("BEWARE, if your intention is NOT to clone source to destination !!") +"<br><br>" + 
				tr("Are you sure you wish to proceed ??") + "<br><br>");
	}
}
// SLOTS-------------------------------------------------------------------------------------
// --------------------------------okay pressed------------------------------------------------
void textDialog::okay()
{
	GoOn = 1;
	userInput = uiT.lineEdit_userInput -> text();
	if ((Type == "password") || (Type == "passphrase"))
	{
		close();
		return;
	}

	//remove trailing or starting whitespaces and invalid characters
	QStringList invalid;
	invalid << "`" << "!" << "@" << "#" << "$" << "%" << "%" << "^" << "&" << "*" << "(" << ")" << "+" << "=" << "{" << "[" << "}"
		<< "]" << ":" << ";" << "\"" << "'" << "|" << "\\" << "<" << "," << ">" << "?" << "/";
	for (int count=0; count<invalid.size(); ++count)
		userInput.replace(invalid.at(count),"");
	
	while ( (userInput.endsWith(" ")) || (userInput.endsWith(".")) )
		userInput.chop(1);
	while ( (userInput.startsWith(".")) || (userInput.startsWith(" ")) )
		userInput.remove(0,1);

	if (userInput == "")
		GoOn = 2;

	if (userInput == profileName)
		GoOn = 3;
	
	if (uiT.checkBox_select -> isChecked())		//"Do not show this again check box
		GoOn = 4;
	close();
}
// --------------------------------cancel pressed------------------------------------------------
void textDialog::cancel()
{
	//GoOn == 0
	close();
}

void textDialog::closeEvent(QCloseEvent *event)
 {
	event->accept();
 }
// --------------------------------accessors-----------------------------------
int textDialog::getGoOn()
 {
	return GoOn ;
 }
QString textDialog::getUserInput()
 {
	return userInput;
 }

// end of textDialog.cpp ---------------------------------------------------------------------------

