#! /bin/sh
# check script for Lunzip - Decompressor for lzip files
# Copyright (C) 2010, 2011 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
LZIP="${objdir}"/lunzip
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -x "${LZIP}" ] ; then
	echo "${LZIP}: cannot execute"
	exit 1
fi

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
printf "testing lunzip-%s..." "$2"
cd "${objdir}"/tmp

cat "${testdir}"/test.txt > in || framework_failure
cat in in > in2 || framework_failure
cat "${testdir}"/test_v1.lz > in.lz || framework_failure
cat in.lz in.lz > in2.lz || framework_failure
fail=0

"${LZIP}" -t "${testdir}"/test_v0.lz || fail=1
printf .
"${LZIP}" -cd "${testdir}"/test_v0.lz > copy || fail=1
cmp in copy || fail=1
printf .

"${LZIP}" -t "${testdir}"/test_v1.lz || fail=1
printf .
"${LZIP}" -cd "${testdir}"/test_v1.lz > copy || fail=1
cmp in copy || fail=1
printf .

"${LZIP}" -t in2.lz || fail=1
printf .
"${LZIP}" -cd in2.lz > copy2 || fail=1
cmp in2 copy2 || fail=1
printf .

cat in2.lz > copy2.lz || framework_failure
printf "garbage" >> copy2.lz || framework_failure
printf "to be overwritten" > copy2 || framework_failure
"${LZIP}" -t copy2.lz || fail=1
printf .
"${LZIP}" -dfk copy2.lz || fail=1
cmp in2 copy2 || fail=1
printf .

cat in.lz > out.lz || framework_failure
printf "to be overwritten" > copy || framework_failure
"${LZIP}" -df -o copy < out.lz || fail=1
cmp in copy || fail=1
printf .

cat in.lz > anyothername || framework_failure
"${LZIP}" -q anyothername || fail=1
cmp in anyothername.out || fail=1
printf .

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
