<?php
/*
    LWAT, LDAP Webbased Administration Tool
    Copyright (C) 2007  Finn-Arne Johansen <faj@bzz.no>, BzzWare AS, Norway

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

require_once ("functions.php"); 
loadConfig () ; 
session_start () ; 

require('/usr/share/php/smarty/libs/Smarty.class.php') ; 

loadLocale () ;
ob_start () ; 

$smarty = new Smarty();
$smarty->template_dir = $smarty_templ ; 
$smarty->compile_dir = $smarty_compile ; 

function autoMount ($viewbase) {
    global $smarty, $ldap, $automountbase ; 

    $filter = "(ou=auto.master)" ; 
    $want = array ("dn") ; 
    $result = ldap_search ($ldap, $automountbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $display=array() ; 
    $viewdn= $viewbase ; 
    if (empty ($viewbase)) 
        $viewbase = $entries[0]["dn"] ; 
    foreach ($entries as $key => $value) 
        if (is_array ($value))
	    $display[] = array ('level' => 0, 'base' => htmlspecialchars($value["dn"])) ; 
    for ($i = 0 ; $i < count($display) ; $i++) {
        $level = $display[$i]["level"] ; 
        $searchbase = $display[$i]["base"] ; 
        if (isset ($searchbase)) {
	    $filter = "objectClass=automount" ; 
	    $want = array ("cn", "automountInformation") ; 
	    $result = @ldap_search ($ldap, $searchbase, $filter, $want) ; 
	    if ($result) {
	        $entries = ldap_get_entries ($ldap, $result);
		$add = $i ; 
		foreach ($entries as $key => $value)
		    if (is_array ($value)) {
			$dn = ldap_explode_dn ($value["dn"],0) ; 
			array_splice($dn, 0,2) ; 
			unset ($new) ; 
			$dn = implode (",", $dn) ;
			if ($dn == $searchbase) {
			    $automountinformation = explode (" ", $value["automountinformation"][0]) ; 
			    if (substr ($automountinformation[0],0,5) == "ldap:")
				$new = array ('level' => $level + 1, 
					      'base' => substr($automountinformation[0],5), 
					      'dn' => $value["dn"],
					      'cn' => $value["cn"][0]) ; 
			    elseif ($automountinformation[0] == "-fstype=autofs")
				$new = array ('level' => $level + 1, 
					      'base' => substr($automountinformation[1],5), 
					      'dn' => $value["dn"],
					      'cn' => $value["cn"][0]) ; 
			    else 
				$new = array ('level' => $level + 1, 
					      'dn' => $value["dn"],
					      'cn' => $value["cn"][0]) ; 
			    if ($level == 0 || (is_array ($new) && (strpos($viewbase, $dn) !== false))) {
				$add++ ; 
				array_splice($display, $add, 0, array ($new)) ; 
			    }
			}
		    }
            }
	}
    }
    if (!empty($viewdn)) {
	$viewarray = ldap_explode_dn (substr($viewdn,0,strpos($viewdn, $automountbase) - 1), 1) ;
	$title = _("Automount point ") ; 
	for ($i = $viewarray[count] ; $i-- > 0 ; )
	    $title = sprintf ("%s/%s", $title, $viewarray[$i]) ;
    } else unset ($title) ; 
    $smarty->assign ('display', $display) ; 
    $smarty->assign ('viewbase', $viewbase) ; 
    $smarty->assign ('dn', $viewdn) ; 
    $smarty->assign ('title', $title) ; 
    $smarty->display ('admin_automount_browse.tpl') ; 
}

function automountdetail ($dn) {
    global $smarty, $ldap, $automountbase ; 

    $want = array ("cn", "description", "automountinformation") ;
    $filter = "objectClass=*" ; 

    $result = ldap_search ($ldap, $dn, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result) ; 
    $display = ldap_explode_dn (substr($dn,0,strpos($dn, $automountbase) - 1), 1) ;
    $displaystr = "" ; 
    for ($i = $display[count] ; $i-- > 0 ; )
	$displaystr = sprintf ("%s/%s", $displaystr, $display[$i]) ;
    $automountinformation = explode (" ", substr($entries[0]["automountinformation"][0], 1)) ; 
    $smarty->assign ('title', sprintf (_("Automount share %s"), $displaystr)); 
    $smarty->assign ('suggest', $entries[0]["cn"][0]); 
    $smarty->assign ('options', $automountinformation[0]); 
    $smarty->assign ('export', $automountinformation[1]); 
    $smarty->assign ('dn', $dn); 
    $smarty->display ('admin_automount_edit.tpl') ; 
}

function showHost ($ldap, $authenticated, $cn) {
    global $smarty, $hostbase, $base ; 
    $filter="cn=" . $cn ;
    $want = array ("cn", "associatedDomain", "ipHostNumber", "macAddress", "sambaAcctFlags") ;
    $searchbase=$hostbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $count=$entries["count"] ;
    if ($count) {
        $cn=htmlspecialchars($entries[0]["cn"][0]); 
        $domain=htmlspecialchars($entries[0]["associateddomain"][0]);
        $ipAddress=htmlspecialchars($entries[0]["iphostnumber"][0]);
        $macAddress=htmlspecialchars($entries[0]["macaddress"][0]);
        if (strpos($entries[0]["sambaacctflags"][0], 'W') === false )
            $sambaHost = "" ; 
        else
            $sambaHost = "checked" ; 
	$smarty->assign ('cn', $cn) ; 
	$smarty->assign ('domain', $domain) ; 
	$smarty->assign ('ipAddress', $ipAddress) ;
	$smarty->assign ('macAddress', $macAddress) ;
	$smarty->assign ('sambaHost', $sambaHost) ;
	$smarty->assign ('memberOf', $memberOf) ; 
	$smarty->assign ('notMemberOf', $notMemberOf) ; 
	showHostGroups ($ldap, $authenticated, $cn) ; 
	$smarty->display('admin_host_show.tpl') ;
    } else {
        printf (_("No matching objects") ."<BR>") ;
    }
}

function showHostGroups ($ldap, $authenticated, $cn) {
    global $smarty, $netgroupbase ;

    $filter="(&(objectClass=nisNetGroup)(!(memberNisNetGroup=*)))" ; 
	$want = array ("cn", "nisNetGroupTriple") ;
    $searchbase=$netgroupbase ; 
        $result = ldap_search($ldap, $searchbase, $filter, $want);
        if ($result) {
	    $entries = ldap_get_entries ($ldap, $result);
	    for ($i = 0 ; $i < $entries["count"] ; $i++) {
	    if (@in_array ('(' . $cn . ',-,-)', $entries[$i]["nisnetgrouptriple"]))
	           $memberOf[] = htmlspecialchars($entries[$i]['cn'][0]) ; 
	       else
	           $notMemberOf[] = htmlspecialchars($entries[$i]['cn'][0]) ; 
            }
        } 
    if ($authenticated) {
        $groupTarget='\'sub\'' ;
        $delAction ='\'hostDelGroup&cn=' . $cn ; 
        $delAction .= '&group=\' + member.value' ;
        $addAction ='\'hostAddGroup&cn=' . $cn ; 
        $addAction .= '&group=\' + nonmember.value';
    } else {
        $groupTarget = '\'logout\'' ; 
        $delAction = '\'loginForm\'' ; 
        $addAction = '\'loginForm\'' ; 
    }
    $smarty->assign('memberOf', $memberOf) ; 
    $smarty->assign('notMemberOf', $notMemberOf) ; 
    $smarty->assign('groupTarget', $groupTarget) ; 
    $smarty->assign('addAction', $addAction) ; 
    $smarty->assign('delAction', $delAction) ; 
}

function userDelGroup ($ldap, $uid, $gid) {
    global $groupbase, $base ; 
    $filter="(&(objectClass=posixGroup)(gidNumber=" . $gid . "))";
    $want = array ('cn'); 
    $searchbase=$groupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $groupdn=htmlspecialchars($entries[0]["dn"]) ; 
    $cn=htmlspecialchars($entries[0]["cn"][0]) ; 
    $change = array (); 
    $change["memberUid"][] = $uid ; 
    @ldap_mod_del($ldap, $groupdn, $change) ;
    $want = array ('member'); 
    $filter="(&(member=*)(cn=" . $cn . "))";
    $result = ldap_search($ldap, $base, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $groupdn=htmlspecialchars($entries[0]["dn"]) ; 
    $change = array (); 
    if ($entries[0]["member"][count]) {
        $want = array (); 
	$filter="(&(objectClass=posixAccount)(uid=" . $uid  ."))";
	$result = ldap_search($ldap, $base, $filter, $want);
	$entries = ldap_get_entries ($ldap, $result) ; 
	$change["member"][] = htmlspecialchars($entries[0]["dn"]) ; 
	ldap_mod_del($ldap, $groupdn, $change) ;
    }
}

function hostAddGroup ($ldap, $cn, $group) {
    global $netgroupbase ; 
    $filter="(&(objectClass=nisNetGroup)(cn=" . $group . "))";
    $want = array ('nisNetgroupTriple'); 
    $searchbase=$netgroupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    if (@in_array ('(' . $cn . ',-,-)', $entries[$i]["nisnetgrouptriple"]) === false ) {
	$groupdn=htmlspecialchars($entries[0]["dn"]) ; 
	$change = array () ; 
	for ($i = 0 ; $i < $entries[0]["nisnetgrouptriple"][count] ; $i++) {
	    $change[] = htmlspecialchars($entries[0]["nisnetgrouptriple"][$i]) ;
	}
	$change[] = "(" . $cn . ",-,-)" ; 
	ldap_modify($ldap, $groupdn, array ("nisNetGroupTriple" => $change)) ;
    }
}

function hostDelGroup ($ldap, $cn, $group) {
    global $netgroupbase ; 

    $filter="(&(objectClass=nisNetGroup)(cn=" . $group . "))";
    $want = array ('nisNetgroupTriple'); 
    $searchbase=$netgroupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $groupdn=htmlspecialchars($entries[0]["dn"]) ; 
    $change = array () ; 
    for ($i = 0 ; $i < $entries[0]["nisnetgrouptriple"][count] ; $i++) {
	if ($entries[0]["nisnetgrouptriple"][$i] <>  '(' . $cn . ',-,-)')
	    $change[] = htmlspecialchars($entries[0]["nisnetgrouptriple"][$i]) ;
    }
    ldap_modify($ldap, $groupdn, array ("nisNetGroupTriple" => $change)) ;
}

function changeGroup ($ldap, $gid, $cn, $description, $auth) {
    global $base, $useLisGroup, $groupbase, $authbase ; 
    $filter="(&(objectClass=posixGroup)(gidNumber=" . $gid . "))";
    $want = array ('objectClass', 'description', 'memberUid', 'cn'); 
    $searchbase=$groupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $groupdn = htmlspecialchars($entries[0]["dn"]) ; 
    $cn=htmlspecialchars($entries[0]["cn"][0]) ;
    $change = array (); 
    if ($description <> $entries[0]["description"][0]) {
	$change["description"][] = $description ; 
    }
    if (count ($change)) ldap_modify($ldap, $groupdn, $change) ;
    $change = array (); 
    if (!$useLisGroup) {
	$filter="(&(member=*)(cn=" . $cn . "))";
	$want = array ('objectClass', 'member'); 
	$result = ldap_search($ldap, $base, $filter, $want);
	$count = ldap_count_entries ($ldap, $result) ;
        if ($auth) {
            if ($count == 0) {
                $change["objectClass"] = array('top', 'groupOfNames') ; 
                $change["cn"] = $cn ; 
                $want = array ('dn') ; 
                for ($i = 0 ; $i < $entries[0]["memberuid"][count] ; $i++) {
                    $filter = '(&(objectClass=posixAccount)(uid=' . 
                               $entries[0]["memberuid"][$i] . '))' ; 
		    $result = ldap_search($ldap, $base, $filter, $want);
		    if (ldap_count_entries ($ldap, $result) == 1) {
		        $member = ldap_get_entries ($ldap, $result) ; 
		        $change["member"][] = $member[0]["dn"] ; 
		    }
		}
                if  (count($change["member"]) > 0)
                    ldap_add ($ldap, "cn=" . $cn . "," . $authbase, $change) ;
            }
        } else {
            if ($count > 0) {
		$entries = ldap_get_entries ($ldap, $result) ; 
		ldap_delete ($ldap, $entries[0]["dn"]) ;
            }
        }
    }
    showGroup ($ldap, $gid);
}

function changeHost ($ldap, $cn, $domain, $ipaddress, $macaddress, $sambaHost = false) {
    global $hostbase ; 
    $filter="cn=" . $cn ;
    $want = array ("cn", "objectClass", "associatedDomain",
		   "ipHostNumber", "macAddress", "sambaAcctFlags", "uid",
		   "uidNumber", "gidNumber", "homeDirectory", "sambaSID") ; 
    $searchbase=$hostbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    if ($entries["count"] <= 0)  {
        printf (_("Sorry, cant find a host with the name %s") . "<BR>", $cn ); 
    } else {  
	$change = array (); 
	if ($domain <> $entries[0]["associateddomain"][0]) {
	    if (in_array ('domainRelatedObject', $entries[0]["objectclass"]) === false)
		$change["objectClass"][] = "domainRelatedObject" ;
	    $change["associatedDomain"] = $domain ; 
	}
	if ($ipaddress <> $entries[0]["iphostnumber"][0]) {
	    if (in_array ('ipHost', $entries[0]["objectclass"]) === false)
		$change["objectClass"][] = "ipHost" ;
	    $change["ipHostNumber"] = $ipaddress ;
	}
	if ($macaddress <> $entries[0]["macaddress"][0]) {
	    if (in_array ('ieee802Device', $entries[0]["objectclass"]) === false)
		$change["objectClass"][] = "ieee802Device" ;
	    $change["macAddress"] = $macaddress ;
	}
	if ($sambaHost) {
	    if (in_array ('posixAccount', $entries[0]["objectclass"]) === false)
		$change["objectClass"][] = "posixAccount" ; 
	    if (in_array ('sambaSamAccount', $entries[0]["objectclass"]) === false)
		$change["objectClass"][] = "sambaSamAccount" ; 
	    if (!array_key_exists ('uid', $entries[0]))
		$change["uid"] = sprintf ("%s$", $cn) ; 
	    if (!array_key_exists ('uidnumber', $entries[0]))
		$change["uidNumber"] = getNextID ($ldap) ; 
	    if (!array_key_exists ('gidnumber', $entries[0]))
		$change["gidNumber"] = "107" ; 
	    if (!array_key_exists ('homedirectory', $entries[0]))
		$change["homeDirectory"] = "/dev/null" ; 
	    if (!array_key_exists ('sambasid', $entries[0]))
		$change["sambaSID"] = get_sambasid ($ldap, $change["uidNumber"]) ; 
	    $change["sambaAcctFlags"] = "[W          ]" ; 
	}
	if (!empty ($change)) {
	    if (!empty ($change["objectClass"]))
		for ($i = 0 ; $i < $entries[0]["objectclass"][count]; $i++)
		    $change["objectClass"][] = $entries[0]["objectclass"][$i] ; 
	    if (!ldap_modify($ldap, "cn=" . $cn . "," . $hostbase, $change))
	        debug (array('entries' => $entries, 'change' => $change)) ;
	}
    }
    showHost ($ldap, true, $cn);
}
function addHost ($ldap, $cn, $domain, $ipaddress, $macaddress) {
    global $hostbase ; 
    $filter="cn=" . $cn ;
    $want = array ("cn"); 
    $searchbase=$hostbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    if ($entries["count"] > 0)  {
        printf (_("Sorry, there is already a host with the name %s") . "<BR>", $cn ); 
    } else {  
	$add = array (); 
	$add["objectClass"] = array ("top", "organizationalRole") ; 
	$add["cn"] = $cn ; 
	if (!empty($domain)) {
	    $add["objectClass"][] = "domainRelatedObject" ; 
	    $add["associatedDomain"] = $domain ; 
	}
	if (!empty ($ipaddress)) {
	    $add["objectClass"][] = "ipHost" ; 
	    $add["ipHostNumber"] = $ipaddress ;
	}
	if (!empty ($macaddress)) {
	    $add["objectClass"][] = "ieee802Device" ; 
	    $add["macAddress"] = $macaddress ;
	}
	ldap_add($ldap, "cn=" . $cn . "," . $hostbase, $add) ;
    }
    showHost ($ldap, true, $cn);
}

function addGroup ($ldap, $cn, $description) {
    global $useLisGroup, $groupbase, $base ; 
    $filter="(|(uid=" . $cn . ")(cn=" . $cn . "))";
    $want = array ("cn","uid"); 
    $searchbase=$base ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    if ($entries["count"] > 0)  {
        printf (_("Sorry, there is already a group/user with the name %s") . "<BR>", $cn ); 
        $gidNumber = htmlspecialchars($entries[0]["gidNumber"][0]) ;
    } else {  
	$gidNumber = getnextid ($ldap) ;
	$add = array (); 
	if ($useLisGroup) {
	    $add["objectClass"] = array ("top", "posixGroup", "lisGroup") ; 
	    $add["groupType"] = "school_class" ; 
	} else
	    $add["objectClass"] = array ("top", "posixGroup") ; 
	$add["cn"] = $cn ; 
	$add["gidNumber"] = $gidNumber ;
	$add["description"] = $description ; 
	ldap_add($ldap, "cn=" . $cn . "," . $groupbase, $add) ;
    }
    showGroup ($ldap, $gidNumber);
}

function addUser ($ldap, $cn, $template, $username) {
    $userpw = pwgen () ;
    ldapAddUser ($ldap, $cn, $template, $username, $userpw, $groups) ; 
    userAddForm (true) ;
    printf ("<HR>\n") ; 
    printf(_("Added user: %s") . '<BR>', $cn) ;
    printf(_("username: ") . 
           '<A HREF="javascript:;" 
            onClick="Action(\'showUser&text=%s\', \'main\')">%s</A><BR>', 
            $username, $username) ; 
    printf (_("password: %s"), $userpw);
}

function changeUser ($ldap, $uid, $cn) {
    global $base ; 
    $filter="(&(objectClass=posixAccount)(uid=" . $uid . "))";
    $want = array (); 
    $result = ldap_search($ldap, $base, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $change = array (); 
    $change["cn"][] = $cn ; 
    ldap_modify($ldap, $entries[0]["dn"], $change) ; 
    showUser ($ldap, true, $uid); 
}

function showGroup ($ldap, $gid) {
    global $useLisGroup, $smarty, $base, $authbase, $groupbase ; 
    $filter="(&(objectClass=posixGroup)(gidNumber=" . $gid . "))";
    $want = array ("memberUid", "member", "description", "cn", "objectClass") ;
    $searchbase=$groupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $authentication= ( $entries[0]["member"]["count"] > 0 ); 
    $smarty->assign('description', $entries[0]["description"][0]); 
    $smarty->assign('cn', $entries[0]["cn"][0]); 
    $smarty->assign('gid', $gid) ; 
    if ($useLisGroup) {
        if (in_array ('lisAclGroup', $entries[0]["objectclass"]))
            $smarty->assign ('authentication', 'checked disabled'); 
        else 
            $smarty->assign ('authentication', 'disabled'); 
    } else {
        $result = ldap_search ($ldap, $authbase, 
                               'cn=' . $entries[0]["cn"][0]); 
        if (ldap_count_entries ($ldap, $result))
            $smarty->assign ('authentication', 'checked'); 
    }
    $memberUid=$entries[0]["memberuid"];
    $filter="" ; 
    for ($i=0 ; $i < $memberUid["count"] ; $i++) {
        $filter .= "(uid=" . htmlspecialchars($memberUid[$i]) . ")" ; 
    }
    $filter="(&(objectClass=posixAccount)(|" . $filter . "))" ; 
    $want = array ("uid", "cn") ;
    $searchbase=$base ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $username = array () ; 
    $display = array () ; 
    for ($i=0 ; $i < $entries["count"] ; $i++) {
        $username[] = htmlspecialchars($entries[$i]["uid"][0]) ;
        $display[] = htmlspecialchars($entries[$i]["cn"][0]) ; 
    }
    $smarty->assign('username', $username) ; 
    $smarty->assign('display', $display) ; 
    $smarty->display('admin_group_show.tpl') ;

}

function showUser ($ldap, $authenticated, $uid) {
    global $smarty, $base, $groupbase ; 
    $filter="(&(objectClass=posixAccount)(uid=" . $uid . "))";
    $want = array ("uidNumber", "uid", "cn", "gidNumber") ;
    $searchbase=$base ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $count=$entries["count"] ;
    if ($count) {
        $cn=htmlspecialchars($entries[0]["cn"][0]); 
        $uidNumber=htmlspecialchars($entries[0]["uidnumber"][0]);
        $gidNumber=htmlspecialchars($entries[0]["gidnumber"][0]);
	$filter="(&(objectClass=posixGroup)(gidNumber=" . $gidNumber . ")(!(cn=nextID))(!(cn=lastID)))";
	$want = array ("cn", "gidNumber") ;
	$searchbase=$base ; 
        $result = ldap_search($ldap, $searchbase, $filter, $want);
	$entries = ldap_get_entries ($ldap, $result);
        $userGroup=htmlspecialchars($entries[0]["cn"][0]); 
	$smarty->assign('uid', $uid) ;  
	$smarty->assign('uidNumber', $uidNumber) ;  
	$smarty->assign('cn', $cn) ;  
	$smarty->assign('userGroup', $userGroup) ;  
	showUserGroups($ldap, $authenticated, $uid) ; 
	$smarty->display ('admin_user_show.tpl') ;  
    } else {
        printf (_("No matching objects") ."<BR>") ;
    }
}

function showUserGroups ($ldap, $authenticated ,$uid) {
    global $smarty, $useLisGroup, $groupbase ;

    if ($useLisGroup) 
	$filter="(&(objectClass=posixGroup)(!(groupType=private))(memberUid=" . $uid . "))";
    else
	$filter="(&(objectClass=posixGroup)(memberUid=" . $uid . "))";
    $want = array ("cn", "gidNumber") ;
    $searchbase=$groupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    for ($i=0 ; $i < $entries["count"] ; $i++) {
        $memberValues[] = htmlspecialchars($entries[$i]["gidnumber"][0]) ;
        $memberDisplays[] = htmlspecialchars($entries[$i]["cn"][0]) ;
    }
    if ($useLisGroup) 
	$filter="(&(objectClass=posixGroup)(!(groupType=private))(!(memberUid=" . $uid . ")))";
    else
	$filter="(&(objectClass=posixGroup)(!(memberUid=" . $uid . ")))";
    $want = array ("cn", "gidNumber") ;
    $searchbase=$groupbase ; 
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    for ($i=0 ; $i < $entries["count"] ; $i++) {
        $nonMemberValues[] = htmlspecialchars($entries[$i]["gidnumber"][0]) ;
        $nonMemberDisplays[] = htmlspecialchars($entries[$i]["cn"][0]) ;
    }
    if ($authenticated) {
        $groupTarget='\'sub\'' ;
        $delAction ='\'userDelGroup&uid=' . $uid ; 
        $delAction .= '&gid=\' + member.value' ;
        $addAction ='\'userAddGroup&uid=' . $uid ; 
        $addAction .= '&gid=\' + nonmember.value';
    } else {
        $groupTarget = '\'logout\'' ; 
        $delAction = '\'loginForm\'' ; 
        $addAction = '\'loginForm\'' ; 
    }
    $smarty->assign('memberValues', $memberValues) ; 
    $smarty->assign('memberDisplays', $memberDisplays) ; 
    $smarty->assign('nonMemberValues', $nonMemberValues) ; 
    $smarty->assign('nonMemberDisplays', $nonMemberDisplays) ; 
    $smarty->assign('groupTarget', $groupTarget) ; 
    $smarty->assign('addAction', $addAction) ; 
    $smarty->assign('delAction', $delAction) ; 
}


function showResult ($ldap, $type, $text, $searchDisabled) {
    global $smarty, $useLisGroup, $base, $groupbase, $hostbase ; 

    if ($text == "*") $text="" ; 
    switch ($type) {
        case "User":
            if ($searchDisabled == 'true')
		$filter="(&(objectClass=posixAccount)(shadowFlag=1)" . 
		        "(|(cn=" . $text . "*)(uid=" . $text . "*)))";
            else
		$filter="(&(objectClass=posixAccount)" .
		        "(|(cn=" . $text . "*)(uid=" . $text . "*)))";
	    $want = array ("uidNumber", "uid", "cn") ;
	    $searchbase=$base ; 
	    $action="showUser" ; 
	    $show="uid" ; 
            break ;
        case "Group":
            if ($useLisGroup)
                $filter="(&(objectClass=posixGroup)(!(groupType=private))(cn=" . $text . "*))" ;
            else 
                $filter="(&(objectClass=posixGroup)(cn=" . $text . "*))" ;
	    $want = array ("gidNumber", "cn") ;
	    $searchbase=$groupbase ; 
	    $action="showGroup" ; 
	    $show="gidnumber" ; 
            break ;
        case "Hosts":
            $filter="cn=" . $text . "*" ;
	    $want = array ("cn") ;
	    $searchbase=$hostbase ; 
	    $action="showHost" ; 
	    $show="cn" ; 
            break ;
        default:
           return ;
    }
    $result = ldap_search($ldap, $searchbase, $filter, $want);
    $entries = ldap_get_entries ($ldap, $result);
    $count=$entries["count"] ;
    if ($count > 50)
        printf (_("Too many entries, please narrow your search") . "<BR>\n") ; 
    elseif ($count) {
	for ($i=0 ; $i < $count ; $i++) {
	    $value[]=htmlspecialchars($entries[$i][$show][0]) ; 
	    if ($type == "User") 
		$display[] = sprintf ("%s (%s)", 
		              htmlspecialchars($entries[$i]['cn'][0]),
		              htmlspecialchars($entries[$i]['uid'][0])) ; 
	    else
		$display[] = htmlspecialchars($entries[$i]['cn'][0]) ; 
	    $dn[] = htmlspecialchars($entries[$i]['dn']) ; 
	}
	$smarty->assign('searchDisabled', $searchDisabled) ; 
	$smarty->assign('action', $action) ; 
	$smarty->assign('value', $value) ; 
	$smarty->assign('dn', $dn) ; 
	$smarty->assign('display', $display) ; 
	$smarty->display('admin_result.tpl') ;
    } else {
        printf (_("No matching objects") . "<BR>") ;
    }
}

function userAddForm ($authenticated) {
    global $smarty ; 
    
    $templates = parse_ini_file ("/etc/lwat/admin.ini", true); 
    foreach ($templates as $name => $fields) 
        $templname[] = $name ; 
    $smarty->assign ('templates',$templname) ;
    if ($authenticated) {
        $target = '\'main\'' ; 
	$action = '\'addUser&cn=\' + cn.value '; 
	$action .= ' + \'&username=\' + username.value' ;
	$action .= ' + \'&template=\' + template.value' ;
    } else {
	$action = '\'loginForm\'' ; 
        $target = '\'logout\'' ; 
    }
    $smarty->assign ('target', $target) ;  
    $smarty->assign ('action', $action) ;  
    $smarty->display ('admin_user_add.tpl') ; 
}


$ldap=ldap_connect ($ldaphost); 
$authenticated = ($_COOKIE['Authenticated'] == "True") ;
$key = $_SESSION['key'] ;
if ($key == "") {
    if ($authenticated) {
        setcookie ("Authenticated", "False", time () + 1800) ;
    }
    $authenticated = false ; 
} 
ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
@ldap_start_tls($ldap) ; 
if ($authenticated) {
    $admindn = $_COOKIE['admindn'] ; 
    $xorstring = $_COOKIE['xorstring'] ; 
    if ($xorstring <> "") {
	$adminpw = xorstring ($key, $xorstring) ; 
	$authenticated = ($adminpw <> "") ;
    } else 
        $authenticated = false ; 
}
if ($authenticated) {
    $bind = @ldap_bind ($ldap, $admindn, $adminpw); 
    if ($bind) {
	setcookie ("Authenticated", "True", time () + 1800) ;
	setcookie ("admindn", $admindn, time () + 1800) ;
	setcookie ("xorstring", $xorstring, time () + 1800) ;
    } else {
	unset ($_SESSION['key']) ; 
	$bind = @ldap_bind ($ldap) ;
	$authenticated = false ; 
	setcookie ('Authenticated', 'false', time () + 1800) ;
	setcookie ('admindn', 'dummy', time() + 1800) ;
	setcookie ('xorstring', 'dummy', time() + 1800) ;
	unset ($_SESSION['key']) ; 
	$smarty->assign ('authenticated', 'false') ;
    }
} else {
    unset ($_SESSION['key']) ; 
    $bind = @ldap_bind ($ldap) ;
}

switch (readKey('action')) {
    case "userAddForm":
        userAddForm ($authenticated) ;
        break ;
    case "groupAddForm":
	if ($authenticated) {
	    $action ='\'addGroup&cn=\' + cn.value '; 
	    $action .= ' + \'&description=\' + description.value' ;
	    $target = '\'main\'' ; 
	} else {
	    $action = '\'loginForm\'' ; 
	    $target = '\'logout\'' ; 
	}
	$smarty->assign ('action', $action) ;  
	$smarty->assign ('target', $target) ;  
	$smarty->display ('admin_group_add.tpl') ; 
        break ;
    case "machineAddForm":
	if ($authenticated) {
	    $action ='\'addHost&cn=\' + cn.value '; 
	    $action .= ' + \'&domain=\' + domain.value' ;
	    $action .= ' + \'&ipaddress=\' + ipaddress.value' ;
	    $action .= ' + \'&macaddress=\' + macaddress.value' ;
	    $target = '\'main\'' ; 
	} else {
	    $action = '\'loginForm\'' ; 
	    $target = '\'logout\'' ; 
	}
	$smarty->assign ('action', $action) ;  
	$smarty->assign ('target', $target) ;  
	$smarty->display ('admin_host_add.tpl') ; 
        break ;
    case "groupSearch":
        $searchFor=readKey('Name') ;
        if ($searchFor <> "") showResult ($ldap, 'Group', $searchFor, ''); 
        break ;
    case "groupSearchForm":
        $smarty->display('admin_group_search.tpl') ;
        break ;
    case "userSearch":
        $searchFor=readKey('Name') ;
        if ($searchFor <> "") showResult ($ldap, 'User', $searchFor, readKey('searchDisabled')) ; 
        break ;
    case "userSearchForm":
        $result=ldap_search ($ldap, $base, 
                             "(&(objectClass=posixAccount)(shadowFlag=1))", 
                             array () ) ; 
        $smarty->assign ('searchDisabled', ldap_count_entries ($ldap, $result)) ; 
        $smarty->display('admin_user_search.tpl') ;
        break ;
    case "showUser":
        showUser ($ldap, $authenticated, readKey('text')); 
        break ;
    case "userDelGroup":
        $uid = readKey('uid') ;
        userDelGroup ($ldap, $uid, readKey('gid')); 
        showUserGroups ($ldap, $authenticated, $uid);
	$smarty->display('admin_user_show_group.tpl') ; 
        break ;
    case "hostDelGroup":
        $cn = readKey('cn') ;
        hostDelGroup ($ldap, $cn, readKey('group')); 
        showHostGroups ($ldap, $authenticated, $cn);
	$smarty->display('admin_host_show_group.tpl') ; 
        break ;
    case "hostAddGroup":
        $cn = readKey('cn') ;
        hostAddGroup ($ldap, $cn, readKey('group')); 
        showHostGroups ($ldap, $authenticated, $cn);
	$smarty->display('admin_host_show_group.tpl') ; 
        break ;
    case "userAddGroup":
        $uid = readKey('uid') ;
        userAddGroup ($ldap, $uid, readKey('gid')); 
        showUserGroups ($ldap, $authenticated, $uid);
	$smarty->display('admin_user_show_group.tpl') ; 
        break ;
    case "changeUser":
        changeUser ($ldap, readKey('uid'), readKey('cn')); 
        break ;
    case "changeGroup":
        changeGroup ($ldap, readKey('gid'), readKey('cn'), readKey('description'), (readKey('auth') == 'true')); 
        break ;
    case "showGroup":
        showGroup ($ldap,readKey('text')); 
        break ;
    case "addUser":
	$cn = readKey('cn') ;
	$template = readKey('template') ;
	$username = readKey ('username'); 
	addUser ($ldap, $cn, $template, $username); 
        break ; 
    case "groupDelete":
        $groupToDelete = array () ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
                $entry = ldap_explode_dn ($value, 1); 
		$groupToDelete[] = $entry[0] ; 
	    }
	if (empty ($groupToDelete)) {
	    printf (_("No groups to delete")) ;
	    break ;
	}
        $smarty->assign ('groupToDelete', $groupToDelete) ; 
        $smarty->display ('admin_group_delete.tpl') ; 
        break ; 
    case "groupDoDelete":
        $groupToDelete = array () ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 )
		$groupToDelete[] = $value ; 
	if (empty ($groupToDelete)) {
	    printf (_("No groups to delete")) ;
	    break ;
	}
        foreach ($groupToDelete as $cn ) {
            $want = array ('cn') ; 
            $filter = '(&(|(objectClass=posixGroup)(member=*))(cn=' . $cn . '))' ; ; 
	    $result = ldap_search ($ldap, $base, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result);
	    for ($i = 0 ; $i <  $entries[count] ; $i++) {
	        if (ldap_delete ($ldap, $entries[$i]["dn"]))
	            printf(_("Group %s deleted") . "<br>", $entries[$i]["dn"]) ; 
	    }
        }
        break ; 
    case "userEnable":
        $userToEnable = array () ; 
        $memberUid = '' ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
		$want = array ('memberUid') ; 
		$filter= '(&(objectClass=posixGroup))' ; 
                $result = ldap_search ($ldap, $value, $filter, $want) ; 
                $entries = ldap_get_entries ($ldap, $result) ; 
                if ($entries[count])
                    for ($group = 0 ; $group < $entries[count] ; $group++) {
                        $members = htmlspecialchars($entries[$group]['memberuid']) ; 
                        for ($member = 0 ; $member < $members[count] ; $member++) {
                            $memberUid .= '(uid=' . $members[$member] . ')' ; 
                        } 
                    }
                else {
		    $userToEnable[] = $value ; 
		}
	    }
	if (!empty ($memberUid)) {
	    $want = array () ; 
	    $filter = '(&(objectClass=posixAccount)(|' . $memberUid . '))' ; 
	    $result = ldap_search ($ldap, $base, $filter, $want) ; 
	    $entries = ldap_get_entries ($ldap, $result) ; 
	    for ($dn = 0 ; $dn < $entries[count] ; $dn++) 
		$userToEnable[] =htmlspecialchars($entries[$dn]['dn']) ; 
        }
	if (empty ($userToEnable)) {
	    printf (_("No users to enable")) ;
	    break ;
	}
        $smarty->assign ('userToEnable', $userToEnable) ; 
        $smarty->display ('admin_user_enable.tpl') ; 
        break ; 
    case "userDoEnable":
        $userToEnable = array () ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
		$userToEnable[] = $value ; 
	    }
	if (empty ($userToEnable)) {
	    printf (_("No users to enable")) ;
	    break ;
	}
        $want = array ('cn') ; 
        foreach ($userToEnable as $value ) {
            $enable['shadowFlag'] = '0' ; 
            $enable['loginShell'] = '/bin/bash' ; 
            $enable['sambaAcctFlags'] = '[U          ]' ; 
	    ldap_modify ($ldap, $value, $enable);
        }
        break ; 
    case "userDisable":
        $userToDisable = array () ; 
        $memberUid = '' ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
		$want = array ('memberUid') ; 
		$filter= '(&(objectClass=posixGroup))' ; 
                $result = ldap_search ($ldap, $value, $filter, $want) ; 
                $entries = ldap_get_entries ($ldap, $result) ; 
                if ($entries[count])
                    for ($group = 0 ; $group < $entries[count] ; $group++) {
                        $members = htmlspecialchars($entries[$group]['memberuid']) ; 
                        for ($member = 0 ; $member < $members[count] ; $member++) {
                            $memberUid .= '(uid=' . $members[$member] . ')' ; 
                        } 
                    }
                else {
		    $userToDisable[] = $value ; 
		}
	    }
	if (! empty ($memberUid)) {
	    $want = array () ; 
	    $filter = '(&(objectClass=posixAccount)(|' . $memberUid . '))' ; 
	    $result = ldap_search ($ldap, $base, $filter, $want) ; 
	    $entries = ldap_get_entries ($ldap, $result) ; 
	    for ($dn = 0 ; $dn < $entries[count] ; $dn++) 
		$userToDisable[] =htmlspecialchars($entries[$dn]['dn']) ; 
        }
	if (empty ($userToDisable)) {
	    printf (_("No users to disable")) ;
	    break ;
	}
        $smarty->assign ('userToDisable', $userToDisable) ; 
        $smarty->display ('admin_user_disable.tpl') ; 
        break ; 
    case "userDoDisable":
        $userToDisable = array () ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
		$userToDisable[] = $value ; 
	    }
	if (empty ($userToDisable)) {
	    printf (_("No users to disable")) ;
	    break ;
	}
        $want = array ('cn') ; 
        foreach ($userToDisable as $value ) {
            $disable['shadowFlag'] = '1' ; 
            $disable['loginShell'] = 'DISABLED!/bin/bash' ; 
            $disable['sambaAcctFlags'] = '[DU         ]' ; 
	    ldap_modify ($ldap, $value, $disable);
        }
        break ; 
    case "userDelete":
        $userToDelete = array () ; 
        $memberUid = '' ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
		$want = array ('memberUid') ; 
		$filter= '(&(objectClass=posixGroup))' ; 
                $result = ldap_search ($ldap, $value, $filter, $want) ; 
                $entries = ldap_get_entries ($ldap, $result) ; 
                if ($entries[count])
                    for ($group = 0 ; $group < $entries[count] ; $group++) {
                        $members = $entries[$group]['memberuid'] ; 
                        for ($member = 0 ; $member < $members[count] ; $member++) {
                            $memberUid .= '(uid=' . htmlspecialchars($members[$member]) . ')' ; 
                        } 
                    }
                else {
		    $userToDelete[] = $value ; 
		}
	    }
	if (! empty ($memberUid)) {
	    $want = array () ; 
	    $filter = '(&(objectClass=posixAccount)(|' . $memberUid . '))' ; 
	    $result = ldap_search ($ldap, $base, $filter, $want) ; 
	    $entries = ldap_get_entries ($ldap, $result) ; 
	    for ($dn = 0 ; $dn < $entries[count] ; $dn++) 
		$userToDelete[] =htmlspecialchars($entries[$dn]['dn']) ; 
        }
	if (empty ($userToDelete)) {
	    printf (_("No users to delete")) ;
	    break ;
	}
        $smarty->assign ('userToDelete', $userToDelete) ; 
        $smarty->display ('admin_user_delete.tpl') ; 
        break ; 
    case "userDoDelete":
        $userToDelete = array () ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
		$userToDelete[] = $value ; 
	    }
	if (empty ($userToDelete)) {
	    printf (_("No users to delete")) ;
	    break ;
	}
        $want = array ('cn') ; 
        foreach ($userToDelete as $value ) {
            $filter = "member=" . $value ; 
	    $result = ldap_search ($ldap, $base, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result);
	    for ($i = 0 ; $i < $entries['count']; $i++) {
	        $remove = array ("member" => $value) ; 
	        ldap_mod_del ($ldap, $entries[$i]["dn"], $remove) ; 
	    }
        }
        foreach ($userToDelete as $value ) {
            $dn = ldap_explode_dn ($value, 1) ; 
            $filter = "memberUid=" . $dn[0] ; 
	    $result = ldap_search ($ldap, $groupbase, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result);
	    for ($i = 0 ; $i < $entries[count]; $i++) {
	        $remove = array ("memberUid" => $dn[0]) ; 
	        ldap_mod_del ($ldap, $entries[$i]["dn"], $remove) ; 
	    }
        }
        foreach ($userToDelete as $value ) {
            $dn = ldap_explode_dn ($value, 0) ; 
            $want = array ('gidNumber') ; 
            $filter = $dn[0] ; 
	    $result = ldap_search ($ldap, $base, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result);
            $want = array ('memberUid') ; 
	    $filter = "(&(objectClass=posixGroup)(gidNumber=" . 
	               $entries[0]['gidnumber'][0] . "))" ; 
	    $result = ldap_search ($ldap, $base, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result);
	    if ($entries[count]) {
		if ($entries[0]["memberuid"][count] == 0)
		    ldap_delete ($ldap, $entries[0]["dn"]) ; 
		ldap_delete ($ldap, $value) ; 
	    }
        }
        break ; 
    case "addGroup":
	addGroup ($ldap, readKey('cn'), readKey('description')); 
        break ; 
    case "changeHost":
	changeHost ($ldap, readKey('cn'), readKey('domain'), 
	         readKey('ipaddress'), readKey('macaddress'), readKey ('sambaHost') == 'true'); 
        break ; 
    case "addHost":
	addHost ($ldap, readKey('cn'), readKey('domain'), 
	         readKey('ipaddress'), readKey('macaddress')); 
        break ; 
    case "getexport":
        $name=readKey('name'); 
        $root=readKey('parent'); 
        if ($name == "") 
            $export= "" ;
        else {
	    $display = ldap_explode_dn (substr($root,0,strpos($root, $automountbase) - 1), 1) ;
	    $displaystr = sprintf ("%s:", $display[$display[count] - 2 ]) ; 
            for ($i = $display[count] ; $i-- > 0 ; )
                $displaystr = sprintf ("%s/%s", $displaystr, $display[$i]) ;
            $export = sprintf ("%s/%s", $displaystr, $name) ; 
        }
        printf ('<INPUT type=text size=60 name="exportshare" value="%s">', $export) ; 
        break ; 
    case "getUsername":
        $cn=readKey('cn'); 
        if ($cn == "") {
            $username= "" ;
        } else
            $username = get_username ($ldap, $cn) ;
        printf ('<input type=text name=username maxlength=8 value="%s">', $username) ;
        break ; 
    case "getdomainandip":
        $cn=readKey('cn'); 
        $domain=readKey('domain'); 
        if ($cn == "") 
            $hostIP= "" ;
        else {
            if ($domain == "")
		$hostIP = gethostbyname ($cn) ;
            else
		$hostIP = gethostbyname ($cn . "." . $domain . ".") ;
        }
        if ($domain == "") {
	    $fullname = strtolower(gethostbyaddr ($hostIP)) ;
	    $pos = strpos ($fullname, $cn) ; 
	    if ($pos === false)
	        $domain = "" ;
	    else 
	        $domain = substr ($fullname, strlen($cn) + 1) ;
	}
	printf ('<table><tr><td>'); 
	printf ('<input type=text name="domain" value="%s"></td>', $domain) ; 
	printf ('<td><input type=text name="ipaddress" value="%s">', $hostIP) ; 
	printf ('</td></tr></table>'); 
        break ; 
    case "newPassSet":
	$filter="(&(objectClass=posixAccount)(uid=" . readKey('uid') . "))";
	$want = array ('objectClass', 'uid', 'cn') ; 
	$result= ldap_search ($ldap, $base, $filter, $want);
	$entries = ldap_get_entries ($ldap, $result);
	$newpw = readkey('newpw') ;
	$pwLower = 0 ; 
	$pwUpper = 0 ; 
	$pwNumber = 0 ; 
	foreach (count_chars($newpw, 1) as $chr => $count)
	    if ($chr >= 48 && $chr <= 57)
	       $pwNumber += $count ; 
	    elseif ($chr >= 65 && chr <= 90)
	        $pwUpper += $count ; 
	    elseif ($chr >= 97 && chr <= 122)
	        $pwLower += $count ; 
	if (strlen($newpw) < $minPwLength) 
	    printf (_("Sorry, the password must be at least %d characters long"), $minPwLength) ; 
	elseif (strlen($pwUpper) < $minPwUpper)
	    printf (_("Sorry, there must be at least %d uppercase letters in the password"), $minPwUpper) ; 
	elseif (strlen($pwLower) < $minPwLower)
	    printf (_("Sorry, there must be at least %d lowercase letters in the password"), $minPwLower) ; 
	elseif (strlen($pwNumber) < $minPwNumber)
	    printf (_("Sorry, there must be at least %d numbers in the password"), $minPwNumber) ; 
	else {
	    $cryptpw = cryptgen ($newpw); 
	    $sambahash = new smbHash () ;
	    $info = array ();
	    $info["userPassword"][] = $cryptpw ;
	    if (in_array("sambaSamAccount", $entries[0]["objectclass"]) !== false) {
		$info["sambaLMPassword"][] = $sambahash->lmhash($newpw) ; 
		$info["sambaNTPassword"][] = $sambahash->nthash($newpw);
	    }
	    $result = ldap_modify ($ldap,$entries[0]["dn"],$info) ;
	    printf(_("Changed password for %s ( %s ) to %s ."),$entries[0]['uid'][0],$entries[0]['cn'][0], $newpw );
	}
        showUser ($ldap, $authenticated, $entries[0]['uid'][0]); 
	break ;
    case "logout":
	setcookie ('Authenticated', 'false', time () + 1800) ;
	setcookie ('admindn', 'dummy', time() + 1800) ;
	setcookie ('xorstring', 'dummy', time() + 1800) ;
	unset ($_SESSION['key']) ; 
	$smarty->assign ('authenticated', 'false') ;
	$smarty-> display ('admin_login.tpl') ; 
	break ;
    case "newPassAsk":
        $uid=readKey('uid') ; 
        if ($authenticated) {
            printf ('<form method=post name=newpw>') ;
	    printf (_("Are you sure you want to set a new password?") . '<BR>') ;
	    printf (_("Suggested password: ")) ; 
	    printf ('<INPUT type=text name="newpw" value="%s" %s><BR>', 
	             pwgen(), ($allowPwSet ? "" : "readonly") ) ; 
	    printf ('<input type=button name=yes value="' . _("Yes") . 
	            '" onClick="Action(\'newPassSet&uid=%s&newpw=\' + newpw.value, \'main\');">', $uid) ;
	    printf ('<input type=button name=no value="' . _("No") . 
	            '" onClick="Action(\'showUser&text=%s\', \'main\');">', $uid) ;
	    printf ('</form>') ; 
        } else {
	    printf (_("You must log in before setting a new password") . '<BR>') ;
	    showUserGroups($ldap, $authenticated, $uid) ; 
	    $smarty->display('admin_user_show_group.tpl') ; 
	}
	break ; 
    case "login":
        $loginbase = $base ; 
        $adminUser=readKey('admindn') ;
        $filter = '(|(&(objectClass=posixAccount)(uid=' . $adminUser . '))(&(objectClass=simpleSecurityObject)(cn=' . $adminUser . ')))' ; 
        $want = array ("dn") ; 
        while (!empty ($loginbase) && !$authenticated) {
	    $result = @ldap_search($ldap, $loginbase, $filter, $want);
	    $entries = @ldap_get_entries ($ldap, $result); 
	    $admindn = htmlspecialchars($entries[0]['dn']) ; 
	    $adminpw=readKey('adminpw') ;
	    $bind = @ldap_bind ($ldap, $admindn, $adminpw); 
	    if ($bind) {
		$key = crypt(sprintf (gettimeofday (true))) ;
		$_SESSION['key'] = $key ; 
		$xorstring= xorstring ($key, $adminpw); 
		setcookie ('Authenticated', 'True', time () + 1800) ;
		setcookie ('admindn', $admindn, time () + 1800) ;
		setcookie ('xorstring', $xorstring, time () + 1800) ;
		$smarty->assign('authenticated', 'true') ; 
		$authenticated = true ; 
	    } else {
		$loginbase = ldap_explode_dn ($loginbase,0) ;
		array_splice ($loginbase, 0,2) ; 
		$loginbase = implode (",", $loginbase) ; 
            }
        }
    case "loginForm":
        $smarty->display('admin_login.tpl') ; 
        break ;
    case "machineSearchForm":
        $smarty->display('admin_machine_search.tpl') ;
        break ;
    case "machineSearch":
        $searchFor=readKey('Name') ;
        if ($searchFor <> "") showResult ($ldap, 'Hosts', $searchFor, ''); 
        break ;
    case "showHost":
        showHost ($ldap, $authenticated, readKey('text')); 
        break ;
    case "hostsDelete":
        $hostToDelete = array () ; 
        foreach ($_POST as $key => $value) {
            if (strpos($key, 'checked_') === 0 ) {
		$hostToDelete[] = $value ; 
	    }
	}
	if (empty ($hostToDelete)) {
	    printf (_("No hosts to delete")) ;
	    break ;
	}
        $smarty->assign ('hostToDelete', $hostToDelete) ; 
        $smarty->display ('admin_host_delete.tpl') ; 
        break ; 
    case "automountdetail":
        autoMountDetail (readKey ("dn")) ; 
	break ; 
    case "automount":
        autoMount (readKey ("ou")) ; 
	break ; 
    case "hostsDoDelete":
        $hostToDelete = array () ; 
        foreach ($_POST as $key => $value) 
            if (strpos($key, 'checked_') === 0 ) {
		$hostToDelete[] = $value ; 
	    }
	if (empty ($hostToDelete)) {
	    printf (_("No hosts to delete")) ;
	    break ;
	}
        $want = array ('nisNetGroupTriple', 'cn') ; 
        foreach ($hostToDelete as $value ) {
            $dn = ldap_explode_dn ($value, 1) ; 
            $filter = "nisNetGroupTriple=*" ; 
	    $result = ldap_search ($ldap, $netgroupbase, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result);
	    for ($i = 0 ; $i < $entries[count] ; $i++) {
		if (in_array ('(' . $dn[0] . ',-,-)', $entries[$i]["nisnetgrouptriple"]))
		    hostDelGroup ($ldap, $dn[0], $entries[$i]["cn"][0]) ; 
            }
            ldap_delete ($ldap, $value) ;
        }
        break ; 
    case "amountdel":
        $dn=readkey("dn") ; 
	$dnarray = ldap_explode_dn (substr($dn,0,strpos($dn, $automountbase) - 1), 1) ;
	$dnstr = "" ; 
	for ($i = $dnarray[count] ; $i-- > 0 ; )
	    $dnstr = sprintf ("%s/%s", $dnstr, $dnarray[$i]) ;
	$filter = "objectCLass=*" ; 
	$want = array ("dn", "objectClass") ; 
	$result = ldap_search ($ldap, $dn, $filter, $want);
	$entries = ldap_get_entries ($ldap, $result);
	if ($entries[count] > 1) 
	    printf (_("Sorry, you need to delete all child mountpoints and shares before deleting the mountpoint %s"), $dnstr); 
	elseif (readkey('Confirm') == "yes") {
	    ldap_delete ($ldap, $dn) ; 
	    $cn = "cn=" . substr ($dn, 3) ; 
	    @ldap_delete ($ldap, $cn) ; 
	    $viewdn=substr ($dn, strpos($cn, ',ou=') +1) ; 
	    if ($viewdn == $automountbase) {
	        $cn=sprintf ("cn=/%s,ou=auto.master,%s", 
	                     substr ($dn, 3, strpos($cn, ',ou=') - 3), $viewdn) ; 
	        @ldap_delete ($ldap, $cn) ; 
	        $viewdn = "" ; 
	    }
	    automount ($viewdn) ; 
	} else {
	    $smarty->assign ('deldn', $dn) ; 
	    $smarty->assign ('delstr', $dnstr) ; 
	    $smarty->display ('admin_automount_delete.tpl') ; 
        }
        break ; 
    case "amountpoint":
        $root=readkey("root") ; 
        $displaystr = "" ; 
        $display = ldap_explode_dn (substr($root,0,strpos($root, $automountbase) - 1), 1) ;
            for ($i = $display[count] ; $i-- > 0 ; )
                $displaystr = sprintf ("%s/%s", $displaystr, $display[$i]) ;
        $smarty->assign ('title', sprintf (_("Sharename under %s/"), $displaystr )) ; 
        $smarty->assign ('parent' , $root) ; 
	$smarty->assign ('options', 'rw,rsize=8192,wsize=8192,intr') ; 
	$smarty->display ('admin_automount_edit.tpl'); 
        break ; 
    case "amountadd":
        $root=readkey("root") ; 
        $add=readkey("name") ; 
        $export=readkey("export") ; 
	$options = readkey ('options') ; 
        if (!empty($add)) {
            if (empty($root)) {
                $add = sprintf ("/%s", $add) ; 
                $info["objectClass"] = Array("top","Automount"); 
                $info["cn"] = $add ; 
                $info["Description"] = sprintf ("%s mount point", $add) ; 
                $addou=explode("/", $add) ; 
                $newbase = $automountbase ; 
                for ($i = 0 ; $i < count ($addou); $i++) 
                    if (!empty($addou[$i])) {
			$newbase = sprintf ("ou=%s,%s", $addou[$i],$newbase) ; 
			$lastou = $addou[$i] ; 
	            }
                $info["automountInformation"] = sprintf ("ldap:%s", $newbase) ; 
                $dn = sprintf("cn=%s,ou=auto.master,%s", $add, $automountbase) ;
                ldap_add ($ldap, $dn, $info) ;
                unset ($info) ; 
                $info["objectClass"] = array ("top", "organizationalUnit") ; 
                $info["ou"] = $lastou ; 
                $info["description"] = sprintf ("holder for %s mount point", $add) ; 
                ldap_add ($ldap, $newbase, $info) ; 
                $dn = sprintf ("ou=%s,%s", substr($add,1), $automountbase) ; 
            } elseif (empty($export) && empty ($options)) {
                $info["objectClass"] = Array("top","Automount"); 
                $info["cn"] = $add ; 
                $info["automountInformation"] = sprintf ("-fstype=autofs ldap:ou=%s,%s", $add,$root) ; 
                $display = "" ; 
                $dn = sprintf("cn=%s,%s", $add, $root) ;
                $display = ldap_explode_dn (substr($dn,0,strpos($dn, $automountbase) - 1), 1) ;
                for ($i = $display[count] ; $i-- > 0 ; )
                    $displaystr = sprintf ("%s/%s", $displaystr, $display[$i]) ;
                $info["Description"] = sprintf ("%s submount point", $displaystr) ; 
		ldap_add ($ldap, $dn, $info) ; 
		unset ($info) ;
                $info["objectClass"] = Array("top","organizationalUnit"); 
                $info["ou"] = $add ; 
                $info["Description"] = sprintf ("holder for %s submount point", $displaystr) ; 
                $dn = sprintf("ou=%s,%s", $add, $root) ;
		ldap_add ($ldap, $dn, $info) ; 
            } elseif (empty($export) || empty($options))
                printf (_("Sorry, you need to enter both an exportpath and options to define a automount share")) ; 
            else {
                $dn = sprintf("cn=%s,%s", $add, $root) ;
                $info["objectClass"] = Array("top","Automount"); 
                $info["cn"] = $add ; 
                $info["automountInformation"] = sprintf ("-%s %s", $options, $export) ; 
                $display = ldap_explode_dn (substr($dn,0,strpos($dn, $automountbase) - 1), 1) ;
                for ($i = $display[count] ; $i-- > 0 ; )
                    $displaystr = sprintf ("%s/%s", $displaystr, $display[$i]) ;
                $info["Description"] = sprintf ("%s mount point", $displaystr) ; 
		ldap_add ($ldap, $dn, $info) ; 
            } 
	    autoMount ($dn) ; 
        } else {
            if (empty($root)) {
		$suggest = explode (".", $domain) ; 
		$count = count($suggest) ; 
		if ($count > 1)
		   $smarty->assign ('suggest', sprintf ("%s", $suggest[$count - 2])) ; 
		else
		   $smarty->assign ('suggest', $suggest=sprintf ("%s", $suggest[0])) ; 
		$smarty->assign ('title', _("New automount root")) ; 
	    } else {
		$displaystr = "" ; 
		$display = ldap_explode_dn (substr($root,0,strpos($root, $automountbase) - 1), 1) ;
                for ($i = $display[count] ; $i-- > 0 ; )
                    $displaystr = sprintf ("%s/%s", $displaystr, $display[$i]) ;
		$smarty->assign ('title', sprintf (_("New automount submount point under %s/"), $displaystr)) ; 
            }
	    $smarty->assign ('parent' , $root) ; 
	    $smarty->display ('admin_automount_edit.tpl'); 
	}
        break ; 
    default:
        echo "Function not implemented (yet). This is som debug info:" ;
        debug ($_POST);
        break ;
}
ldap_close ($ldap);

?>
