/*
 * $Id: async.h,v 1.1 1994/06/05 07:58:02 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * $Id: async.h,v 1.1 1994/06/05 07:58:02 linus Exp $
 *
 * This file contains the parts of the async protocol that are common
 * to the server and the client.
 */


/*
 * What does this packet contain? (See doc/com-spec)
 */
typedef enum {
	ay_new_text = 0,
	ay_i_am_off = 1,
	ay_i_am_on_obsolete = 2, /* Sends a Who_info_old. */
	ay_conf_deleted = 3,
	ay_conf_created = 4,
	ay_new_name = 5,
	ay_i_am_on = 6,		/* Sends a Who_info. */
	ay_saving = 7,
	ay_forced_leave_conf = 8,
	ay_login = 9,
	/* ay_broadcast_message = 10, */
	ay_crowded = 11,
	ay_directed_message = 12,
	ay_logout = 13
} Async;

/*
 * Parse an asynchronous message and call the appropriate function.
 */
extern Success
async(FILE *fp);
