/* $Id: commands.c,v 1.3 2001/01/15 21:35:40 linus Exp $
 * commands.c
 *
 * The format of this file is a little cryptic. That is because it was
 * previously generated automatically from a list of commands.
 */

#include <config.h>
#include <stddef.h>
#include <s-string.h>

#include <libintl.h>

#include "defaults.h"
#include "cmds.h"
#include "error.h"
#include "commands.h"

#define Export

#define MAX_NUMBER_OF_COMMANDS 89

Export  String           command_separators;
Export  Matching_info    cmd_list [MAX_NUMBER_OF_COMMANDS];
Export  Success       (* function_list [MAX_NUMBER_OF_COMMANDS]) (String argument);

static int number_of_commands = 0;

static inline
void
push_command(String name, int group, int priority,
	     Success (* function) (String argument))
{
    cmd_list[number_of_commands].name = name;
    cmd_list[number_of_commands].group = group;
    cmd_list[number_of_commands].priority = priority;
    function_list[number_of_commands] = function;

    number_of_commands ++;
}


Export  void
init_cmd_list (void)
{
#define FUNCTION "init_cmd_list()"
    int		  i;

    command_separators = s_fcrea_str(gettext(" \t"));

    number_of_commands = 0;

    push_command(s_fcrea_str(gettext("(Lsa) nsta inlgg")), 
		 1, 5, cmd_read_next_text);
    push_command(s_fcrea_str(gettext("(Lsa) nsta kommentar")),
		 1, 1, cmd_read_next_comment);
    push_command(s_fcrea_str(gettext("(Lsa) nsta fotnot")),
		 1, 1, cmd_read_next_footnote);
    push_command(s_fcrea_str(gettext("Markera (inlgget)")),
		 1, 5, cmd_mark_permanently);
    push_command(s_fcrea_str(gettext("terse")),
		 1, 5, cmd_review);
    push_command(s_fcrea_str(gettext("terse nsta")),
		 1, 4, cmd_review_next);
    push_command(s_fcrea_str(gettext("(Se inlgg) igen")),
		 1, 4, cmd_review_again);
    push_command(s_fcrea_str(gettext("terse (det) kommenterade")),
		 1, 4, cmd_read_commented_text);
    push_command(s_fcrea_str(gettext("Endast (lsa senaste)")),
		 1, 5, cmd_only);
    push_command(s_fcrea_str(gettext("Hoppa ver (alla kommentarer)")),
		 1, 1, cmd_jump_tree);
    push_command(s_fcrea_str(gettext("Lista (alla) nyheter")),
		 1, 5, cmd_list_news);
    push_command(s_fcrea_str(gettext("Lista renden")),
		 1, 5, cmd_list_texts);
    push_command(s_fcrea_str(gettext("Vnta (p) nyheter")),
		 1, 4, cmd_wait_for_text);
    push_command(s_fcrea_str(gettext("Alla (olsta inlgg)")),
		 1, 5, cmd_all);
    push_command(s_fcrea_str(gettext("(Skriva eget) inlgg")),
		 2, 5, cmd_write_new_text);
    push_command(s_fcrea_str(gettext("Kommentera (inlgget)")),
		 2, 5, cmd_comment_text);
    push_command(s_fcrea_str(gettext("Fotnot (till inlgg)")),
		 2, 5, cmd_footnote_text);
    push_command(s_fcrea_str(gettext("(Skicka) brev (till)")),
		 2, 6, cmd_write_letter);
    push_command(s_fcrea_str(gettext("Personligt (svar)")),
		 2, 5, cmd_private_comment);
    push_command(s_fcrea_str(gettext("Radera inlgg")),
		 3, 1, cmd_delete_text);
    push_command(s_fcrea_str(gettext("(Skicka) kopia (till)")),
		 3, 4, cmd_copy_recipient);
    push_command(s_fcrea_str(gettext("Addera (mottagare)")),
		 3, 5, cmd_add_recipient);
    push_command(s_fcrea_str(gettext("Subtrahera (mottagare)")),
		 3, 5, cmd_sub_recipient);
    push_command(s_fcrea_str(gettext("Flytta (text till)")),
		 3, 5, cmd_change_recipient);
    push_command(s_fcrea_str(gettext("Var (r) jag")),
		 4, 5, cmd_where_am_i);
    push_command(s_fcrea_str(gettext("G (till mte)")),
		 4, 5, cmd_goto_named_conference);
    push_command(s_fcrea_str(gettext("(G till) nsta mte")),
		 4, 5, cmd_goto_next_conf);
    push_command(s_fcrea_str(gettext("Lista mten")),
		 4, 5, cmd_list_confs);
    push_command(s_fcrea_str(gettext("(Bli) medlem (i)")),
		 4, 5, cmd_join_conference);
    push_command(s_fcrea_str(gettext("Uttrda (ur)")),
		 4, 5, cmd_leave_conference);
    push_command(s_fcrea_str(gettext("Skapa mte")),
		 4, 5, cmd_create_new_conference);
    push_command(s_fcrea_str(gettext("Utplna mte")),
		 4, 5, cmd_remove_conference);
    push_command(s_fcrea_str(gettext("Fortstta (skriva)")),
		 5, 5, cmd_continue_writing);
    push_command(s_fcrea_str(gettext("(Ta) bort (den)")),
		 5, 5, cmd_remove_text);
    push_command(s_fcrea_str(gettext("(Ta bort sista) ordet")),
		 5, 5, cmd_remove_last_word);
    push_command(s_fcrea_str(gettext("Radera (raden ovanfr)")),
		 5, 5, cmd_remove_last_line);
    push_command(s_fcrea_str(gettext("Upp")),
		 5, 5, cmd_previous_line);
    push_command(s_fcrea_str(gettext("Ner")),
		 5, 5, cmd_next_line);
    push_command(s_fcrea_str(gettext("(Lsa) hela (texten)")),
		 5, 5, cmd_look_at_text_and_header);
    push_command(s_fcrea_str(gettext("Lgga (in den)")),
		 5, 4, cmd_enter_text);
    push_command(s_fcrea_str(gettext("Skicka (in) texten")),
		 5, 4, cmd_enter_text);
    push_command(s_fcrea_str(gettext("Mottagare:")),
		 5, 4, cmd_add_recipient_to_edited_text);
    push_command(s_fcrea_str(gettext("Kommentar till:")),
		 5, 4, cmd_add_comment_to_to_edited_text);
    push_command(s_fcrea_str(gettext("rende:")),
		 5, 1, cmd_new_subject);
    push_command(s_fcrea_str(gettext("Redigera (med) editor")),
		 5, 4, cmd_edit_using_editor);
    push_command(s_fcrea_str(gettext("Vilka (r nrvarande)")),
		 6, 7, cmd_show_who_is_on);
    push_command(s_fcrea_str(gettext("Sg (ngot till)")),
		 6, 3, cmd_send_personal);
    push_command(s_fcrea_str(gettext("Snd alarmmeddelande (till alla)")),
		 6, 1, cmd_send_alarm);
    push_command(s_fcrea_str(gettext("?")),
		 7, 1, cmd_list_commands);
    push_command(s_fcrea_str(gettext("Hjlp")),
		 7, 1, cmd_list_commands);
    push_command(s_fcrea_str(gettext("Lista kommandon")),
		 7, 5, cmd_list_commands);
    push_command(s_fcrea_str(gettext("Status (fr)")),
		 7, 5, cmd_status);
    push_command(s_fcrea_str(gettext("Verifiera namn")),
		 7, 5, cmd_show_matching_names);
    push_command(s_fcrea_str(gettext("(Se) tiden")),
		 8, 5, cmd_show_current_time);
    push_command(s_fcrea_str(gettext("F uppmuntran")),
		 8, 5, cmd_get_encouragement);
    push_command(s_fcrea_str(gettext("(Vilken r) mnens (nuvarande) fas")),
		 8, 5, cmd_show_moon_phase);
    push_command(s_fcrea_str(gettext("verg (i) administratrslge")),
		 8, 5, cmd_enable_user);
    push_command(s_fcrea_str(gettext("(Stt) sidstorlek (till)")),
		 8, 5, cmd_set_height);
    push_command(s_fcrea_str(gettext("(ndra) teckenuppsttning")),
		 8, 5, cmd_set_character);
    push_command(s_fcrea_str(gettext("Brja (med nytt) namn")),
		 8, 5, cmd_start_anew);
    push_command(s_fcrea_str(gettext("Sluta")),
		 8, 5, cmd_quit_LysKOM);
    push_command(s_fcrea_str(gettext("Ladda ner data fr offlinelsning")),
		 9, 1, cmd_download);
    push_command(s_fcrea_str(gettext("Ladda upp data frn offlinelsning")),
		 9, 1, cmd_upload);

    push_command(EMPTY_STRING, 0, 0, NULL);

    for ( i = 0 ;  i < MAX_NUMBER_OF_COMMANDS ;  i++ )
    {
	cmd_list[i].tokens = tokenize(cmd_list[i].name,
				      command_separators);
	if (cmd_list[i].tokens == NULL)
	    fatal3 (CLIENT_OUT_OF_MEMORY,
	            "tokenizing command no=%d name=%s failed",
	            i,cmd_list[i].name.string);
    }
#undef FUNCTION
}



Export  String
command_name (Success (* function) (String  argument))
{
    int		r;

    for ( r = 0 ; r < MAX_NUMBER_OF_COMMANDS ; r++ )
    {
	if (function_list[r] == function)
	    return cmd_list[r].name;
    }
    return EMPTY_STRING;
}
