#! /bin/sh

# This script aims to do averything necessary to automate the packaging
# of LyX/Win ready for an Windows Installer to be built.

# It copies these files into the appropriate places in the LyX tree.
#   qt-mt3.dll
#   libiconv-2.dll
#   mingw10.dll
#   clean_dvi.py
#   dv2dt.exe
#   dt2dv.exe

# It strips the executables.

# It adds formats and converters to the Resources/lyx/configure script to
# ensure that the generated .dvi file is usable.

# It removes all stuff generated by running configure:
#   xfonts/
#   doc/LaTeXConfig.lyx
#   lyxrc.defaults
#   packages.lst
#   textclass.lst

# The installee should regenerate them by running configure on his machine.

QT_DLL="$HOME/qt3/bin/qt-mt3.dll"
LIBICONV_DLL="/j/MinGW/bin/libiconv-2.dll"
MINGW_DLL="/j/MinGW/bin/mingwm10.dll"
CLEAN_DVI_PY="clean_dvi.py"
DTL_DIR=dtl
DT2DV="$DTL_DIR/dt2dv.exe"
DV2DT="$DTL_DIR/dv2dt.exe"

LYX_INSTALL_DIR="../../../build/installprefix"

# Change this to 'mv -f' when you are confident that
# the various sed scripts are working correctly.
MV='mv -f'

windows_packaging()
{
    # Install the necessary .dlls and clean_dvi stuff.
    for file in "${QT_DLL}" "${LIBICONV_DLL}" "${MINGW_DLL}" "${DT2DV}" "${DV2DT}"
    do
      cp "${file}" "$LYX_INSTALL_DIR"/bin/. || {
	  echo "Failed to copy ${file} to the LyX package" >&2
	  exit 1
      }
    done

    cp "${CLEAN_DVI_PY}" "$LYX_INSTALL_DIR"/Resources/lyx/scripts/. || {
	echo "Failed to copy ${CLEAN_DVI_PY} to the LyX package" >&2
	exit 1
    }

    # Strip the executables
    (
	cd "${LYX_INSTALL_DIR}/bin"
	for file in *.exe
	do
	  strip $file
	done
    )

    # Modify the configure script,
    # * add a dvi2 format
    # * change the latex->dvi converter to latex->dvi2
    # * add a dvi2->dvi converter
    # * fix the generated chkconfig.sed so that it works with versions of
    #   sed that get confused by sed scripts with DOS line endings.
    TMP=tmp.$$
    CONFIGURE="${LYX_INSTALL_DIR}"/Resources/lyx/configure
    # Do this to make it easy to compare the before and after files.
    dos2unix "${CONFIGURE}"
    sed '
# (Note that this sed script contains TAB characters.)
# Append the dvi2 format after the dvi format.
/^ *\\\\Format[	 ]\{1,\}dvi[	 ]\{1,\}/a\
\\\\Format dvi2	  dvi	DraftDVI	""

# Change the latex->dvi converter to latex->dvi2
# and append the dvi2->dvi converter
/^ *\\\\converter[	 ]\{1,\}latex[	 ]\{1,\}dvi[	 ]\{1,\}/{
s/dvi/dvi2/
a\
\\\\converter dvi2 dvi "python \\\$\\\$s/scripts/clean_dvi.py \\\$\\\$i \\\$\\\$o" ""
}
' "${CONFIGURE}" > "${TMP}"
    cmp -s "${CONFIGURE}" "${TMP}" || {
	diff -u "${CONFIGURE}" "${TMP}"
	${MV} "${TMP}" "${CONFIGURE}"
    }
    rm -f "${TMP}"

    # Strip the executables
    (
	cd "${LYX_INSTALL_DIR}/Resources/lyx"
	rm -rf xfonts
	for file in doc/LaTeXConfig.lyx lyxrc.defaults packages.lst textclass.lst
	do
	  rm -f $file
	done
    )
}


windows_packaging || exit 1

# The end
