/**
 * \file insetmarginal.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Jrgen Vigna
 * \author Lars Gullik Bjnnes
 *
 * Full author contact details are available in file CREDITS
 */

#include <config.h>

#include "insetmarginal.h"
#include "gettext.h"
#include "lyxfont.h"
#include "BufferView.h"
#include "lyxtext.h"
#include "insets/insettext.h"
#include "support/LOstream.h"
#include "debug.h"


using std::ostream;


InsetMarginal::InsetMarginal(BufferParams const & bp)
	: InsetFootlike(bp)
{
	setLabel(_("margin"));
	setInsetName("Marginal");
}


InsetMarginal::InsetMarginal(InsetMarginal const & in, bool same_id)
	: InsetFootlike(in, same_id)
{
	setLabel(_("margin"));
	setInsetName("Marginal");
}


Inset * InsetMarginal::clone(Buffer const &, bool same_id) const
{
	return new InsetMarginal(*const_cast<InsetMarginal *>(this), same_id);
}


string const InsetMarginal::editMessage() const
{
	return _("Opened Marginal Note Inset");
}


int InsetMarginal::latex(Buffer const * buf,
			 ostream & os, bool fragile, bool fp) const
{
	os << "%\n\\marginpar{";

	int const i = inset.latex(buf, os, fragile, fp);
	os << "%\n}";

	return i + 2;
}
