// -*- C++ -*-
/**
 * \file FormFiledialog.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author unknown
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef FORMFILEDIALOG_H
#define FORMFILEDIALOG_H

#include "LString.h"

#include "forms_fwd.h"

#include "frontends/FileDialog.h"

#include <boost/signals/connection.hpp>
#include <boost/signals/trackable.hpp>

#include <vector>

class Dialogs;

/// DirEntry internal structure definition
class DirEntry {
public:
	///
	string name_;
	///
	string displayed_;
	///
	string ls_entry_;
};


//extern "C" {
//	void C_LyXFileDlg_FileDlgCB(FL_OBJECT * ob, long data);
//	void C_LyXFileDlg_DoubleClickCB(FL_OBJECT * ob, long data);
//	int C_LyXFileDlg_CancelCB(FL_FORM *fl, void *xev);
//}


class FD_filedialog;

class FileDialog::Private : public boost::signals::trackable {
public:
	///
	Private(Dialogs &);
	///
	~Private();

	/// sets file selector user button action
	void SetButton(int iIndex, string const & pszName = string(),
		       string const & pszPath = string());
	/// gets last dialog directory
	string const GetDirectory() const;
	/// launches dialog and returns selected file
	string const Select(string const & pszTitle = string(),
		       string const & pszPath = string(),
		       string const & pszMask = string(),
		       string const & pszSuggested = string());
	/// launches dialog and returns selected directory
	string const SelectDir(string const & pszTitle = string(),
		       string const & pszPath = string(),
		       string const & pszSuggested = string());
	/// XForms objects callback (static)
	static void FileDlgCB(FL_OBJECT *, long);
	/// Callback for double click in list
	static void DoubleClickCB(FL_OBJECT *, long);
	/// Handle Cancel CB from WM close
	static int CancelCB(FL_FORM *, void *);

private:
	/// data
	static FD_filedialog * file_dlg_form_;
	///
	static FileDialog::Private * current_dlg_;
	///
	static int minw_;
	///
	static int minh_;
	///
	string user_path1_;
	///
	string user_path2_;
	///
	string directory_;
	///
	string mask_;
	///
	string file_name_;
	///
	int depth_;
	///
	int last_sel_;
	///
	long last_time_;
	///
	string info_line_;
	///
	typedef std::vector<DirEntry> DirEntries;
	///
	DirEntries dir_entries_;
	///
	bool force_cancel_;
	///
	bool force_ok_;

	/** Redraw the form (on receipt of a Signal indicating, for example,
	    that the xform colors have been re-mapped).
	*/
	void redraw();
	/// updates dialog list to match class directory
	void Reread();
	/// sets dialog current directory
	void SetDirectory(string const & pszPath);
	/// sets dialog file mask
	void SetMask(string const & pszNewMask);
	/// sets dialog information line
	void SetInfoLine(string const & pszLine);
	/// handle dialog during file selection
	bool RunDialog();
	/// Handle callback from list
	void HandleListHit();
	/// Handle double click from list
	bool HandleDoubleClick();
	/// Handle OK button call
	bool HandleOK();
	/// Simulates a click on OK/Cancel
	void Force(bool);
	/// Redraw connection.
	boost::signals::connection r_;
};

#endif // FORMFILEDIALOG_H
