#ifndef ABZ_TMP_H
#define ABZ_TMP_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>

/*
 * Create a temporary directory (only accessible by current process)
 * for use by tmp_name() function. You have to specify a temporary
 * directory ``tmpdir'' and a program name ``progname''. These strings
 * are used to create a directory of the form <tmpdir>/<progname><hash>.
 * Return 0 if successful, -1 if not. Check errno to see what error
 * occurred.
 */
#define tmp_open(tmpdir,progname) tmp_open_stub(__FILE__,__LINE__,__FUNCTION__,tmpdir,progname)
extern int tmp_open_stub (const char *filename,int line,const char *function,const char *tmpdir,const char *progname);

/*
 * Remove the directory created by tmp_open(). It is the responsibility
 * of the programmer to ensure that the directory is empty (i.e. all
 * file/directories created with names generated by tmp_name() were
 * removed) by the time this function is called.
 */
extern void tmp_close ();

/*
 * Create a name for a temporary file which is safe to use. Return
 * the filename if successful, NULL if not. Check errno to see what
 * error occurred. Remember to remove the file and free the returned
 * string when you're done.
 */
#define tmp_name() tmp_name_stub(__FILE__,__LINE__,__FUNCTION__)
extern char *tmp_name_stub (const char *filename,int line,const char *function)
  __attribute_malloc__;

#endif	/* #ifndef ABZ_TMP_H */
