-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--
-------------------------------------------------------------------------------

with X_Lib.Tasking,
     X_Strings,
     X_Toolkit,
     Xm_Widgets.Primitive.Label.Push_Button,
     Actions_Global;
use  X_Strings,
     X_Toolkit,
     Xm_Widgets,
     Xm_Widgets.Primitive.Label.Push_Button,
     Actions_Global;

procedure Actions is


   Action_List : Xt_Action_List (1 .. 2) :=
      (1 => (To_X_String ("ActionOne"), Actions_Global.Action_One'Access),
       2 => (To_X_String ("ActionTwo"), Actions_Global.Action_Two'Access));

begin
   X_Lib.Tasking.Resource.Seize;
   Xt_App_Initialize (Appshell, App_Con, "Actions");

   Xt_App_Add_Actions (App_Con, Action_List);

   The_Button := Xm_Create_Push_Button (Appshell, "button");
   Xt_Manage_Child (The_Button);

   Xt_Realize_Widget (Appshell);

   Xt_App_Main_Loop (App_Con);

end Actions;
