with Ada.Numerics.Discrete_Random,
     Quick_Sort,
     Text_Io;
use  Text_Io;
procedure TestQSort is

   package Rand is new Ada.Numerics.Discrete_Random (Integer);

   type Integer_Array is array (Natural range <>) of Integer;

   procedure Int_Qsort is new Quick_Sort (Natural, Integer, Integer_Array);

   Int_Array : Integer_Array (1 .. 10);

   Gen       : Rand.Generator;

begin
   Put_Line ("Generate Random Numbers");
   Rand.Reset (Gen);
   for I in Int_Array'Range loop
      Int_Array (I) := Rand.Random (Gen);
   end loop;
   Put_Line ("Starting with:");
   for I in Int_Array'Range loop
      Put_Line (Integer'Image (Int_Array (I)));
   end loop;

   Put_Line ("Now sorting Random Numbers");
   Int_Qsort (Int_Array);

   Put_Line ("Result:");
   for I in Int_Array'Range loop
      Put_Line (Integer'Image (Int_Array (I)));
   end loop;
end TestQSort;
