-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
-- originally written in C by Christian Kirsch (german magazine iX 1/1996
-- pp. 106-110)
--
-- adapted to adabindx and slightly modified by Hans-Frieder Vogt 1997
--
-------------------------------------------------------------------------------

-- demo program that shows the use of different charsets in a single
-- CSText widget
--
with System,
     Ada.Characters.Latin_1,
     X_Strings,
     X_Lib,
     X_Toolkit,
     Xm_Widgets.Primitive.CS_Text;
procedure I18n is

   
   package Latin_1 renames Ada.Characters.Latin_1;
   package CS_Text renames Xm_Widgets.Primitive.CS_Text;


   Display     : X_Lib.Display_Pointer;
   Toplevel,
   Text        : X_Toolkit.Widget;
   App_Context : X_Toolkit.Xt_App_Context;

   Render_Table : Xm_Widgets.Xm_Render_Table;
   S1, S2, S3, S4, S5   : Xm_Widgets.Xm_String;

   Args         : X_Toolkit.Arg_List;


   Tag1 : constant Xm_Widgets.Xm_String_Tag
        := Xm_Widgets.Xm_String_Tag (X_Strings.To_X_String ("redRendition"));
   Tag2 : constant Xm_Widgets.Xm_String_Tag
        := Xm_Widgets.Xm_String_Tag (X_Strings.To_X_String ("blueRendition"));
   Tag3 : constant Xm_Widgets.Xm_String_Tag
        := Xm_Widgets.Xm_String_Tag (X_Strings.To_X_String ("cyrillicRendition"));


   function Create_Render_Table return Xm_Widgets.Xm_Render_Table is
      Cmap                    : X_Lib.Colormap_ID;
      Red, Green, Blue, Exact : X_Lib.X_Color;
      Rends : Xm_Widgets.Xm_Rendition_Array (1 .. 3);
   begin
      Args := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Get (Args, Xm_Widgets.Xm_N_Colormap, Cmap);
      X_Toolkit.Xt_Get_Values (Toplevel, Args);

      X_Lib.X_Alloc_Named_Color (Display, Cmap, "blue", Blue, Exact);
      X_Lib.X_Alloc_Named_Color (Display, Cmap, "green", Green, Exact);
      X_Lib.X_Alloc_Named_Color (Display, Cmap, "red", Red, Exact);

      Args := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Set (Args, Xm_Widgets.Xm_N_Rendition_Foreground, Red.Pix);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Font_Name, "-*-times-bold-r-normal-*-20-180-*-*-*-*-iso8859-1");
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Font_Type, Xm_Widgets.Font_Is_Font);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Underline_Type, Xm_Widgets.Single_Line);
      Rends (1) := Xm_Widgets.Xm_Rendition_Create (Toplevel, Tag1, Args);

      Args := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Set (Args, Xm_Widgets.Xm_N_Rendition_Foreground, Blue.Pix);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Font_Name, "-*-times-bold-i-normal-*-20-180-*-*-*-*-iso8859-1");
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Font_Type, Xm_Widgets.Font_Is_Font);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Strikethru_Type, Xm_Widgets.Double_Line);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Underline_Type, Xm_Widgets.No_Line);
      Rends (2) := Xm_Widgets.Xm_Rendition_Create (Toplevel, Tag2, Args);

      Args := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Set (Args, Xm_Widgets.Xm_N_Rendition_Foreground, Green.Pix);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Font_Name, "-*-times-bold-r-normal-*-20-180-*-*-*-*-koi8-r");
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Font_Type, Xm_Widgets.Font_Is_Font);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Underline_Type, Xm_Widgets.No_Line);
      Xm_Widgets.Append_Set (Args, Xm_Widgets.Xm_N_Strikethru_Type, Xm_Widgets.No_Line);
      Rends (3) := Xm_Widgets.Xm_Rendition_Create (Toplevel, Tag3, Args);

      return Xm_Widgets.Xm_Render_Table_Add_Renditions (Xm_Widgets.Null_Render_Table, Rends, Xm_Widgets.Replace);
   end Create_Render_Table;

begin
   X_Toolkit.Xt_App_Initialize (Toplevel, App_Context, "I18n");

   Display := X_Toolkit.Xt_Display (Toplevel);

   Render_Table := Create_Render_Table;
   S1           := Xm_Widgets.Xm_String_Generate ("Red Text" & Latin_1.LF,
                                                  Xm_Widgets.Null_String_Tag,
				                  Tag1);
   S2           := Xm_Widgets.Xm_String_Generate ("Blue Text" & Latin_1.LF,
                                       Xm_Widgets.Null_String_Tag,
				       Tag2);
   S3		:= Xm_Widgets.Xm_String_Generate (String'("̣ "),
--   S3		:= Xm_Widgets.Xm_String_Generate (Character'Val (16#FA#) &
--						  Character'Val (16#C5#) &
--						  Character'Val (16#CC#) &
--						  Character'Val (16#A3#) &
--						  Character'Val (16#CE#) &
--						  Character'Val (16#D9#) &
--						  Character'Val (16#CA#) &
--						  " " &
--						  Character'Val (16#D4#) &
--						  Character'Val (16#C5#) &
--						  Character'Val (16#CB#) &
--						  Character'Val (16#D3#) &
--						  Character'Val (16#D4#),
						  Xm_Widgets.Null_String_Tag,
						  Tag3);
   S4           := Xm_Widgets.Xm_String_Concat (S1, S2);
   S5           := Xm_Widgets.Xm_String_Concat (S4, S3);
   Args := X_Toolkit.Null_Arg_List;
   Xm_Widgets.Append_Set (Args, CS_Text.Xm_N_Render_Table,    Render_Table);
   CS_Text.Append_Set    (Args, CS_Text.Xm_N_Edit_Mode,       CS_Text.Multi_Line_Edit);
   Xm_Widgets.Append_Set (Args, CS_Text.Xm_N_CS_Text_Value,   S5);
   X_Toolkit.Append_Set  (Args, CS_Text.Xm_N_Rows,            Natural'(3));
   Text := CS_Text.Xm_Create_CS_Text (Toplevel, "text", Args);
   X_Toolkit.Xt_Manage_Child (Text);

   Xm_Widgets.Xm_String_Free (S1);
   Xm_Widgets.Xm_String_Free (S2);
   Xm_Widgets.Xm_String_Free (S3);
   Xm_Widgets.Xm_String_Free (S4);
   Xm_Widgets.Xm_String_Free (S5);

   X_Toolkit.Xt_Realize_Widget (Toplevel);

   X_Toolkit.Xt_App_Main_Loop (App_Context);
end I18n;
