-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--
-------------------------------------------------------------------------------

with Ada.Text_Io,
     Interfaces.C.Strings,
     System,
     X_Strings,
     X_Toolkit;
procedure Testpath is

   Buffer : String (1 .. 1024);
   Last   : Natural;

   -- just to get the home directory
   --
   function Get_Environment_Value (Variable : in String) return String is
      function getenv (Variable : in System.Address) return Interfaces.C.Strings.chars_ptr;
      pragma Import (C, getenv, "getenv");

      Variable_String : constant Interfaces.C.Char_Array
                      := Interfaces.C.To_C (Variable, Append_Nul => True);
   begin
      -- I think it is ok not to free the string afterwards
      return Interfaces.C.Strings.Value (getenv (Variable_String'Address));
   end Get_Environment_Value;

   -- define the substitution patterns
   --
   Subs : X_Toolkit.Substitution_List_Type (1 .. 3)
        := (1 => (Match        => 'H',
	          Substitution => X_Strings.To_X_String (Get_Environment_Value ("HOME"))),
            2 => (Match        => 'X',
	          Substitution => X_Strings.To_X_String ("/usr/X11R6")),
            3 => (Match        => 'P',
	          Substitution => X_Strings.To_X_String ("include/pixmaps")));
   function Test_Filename (Filename : in X_Strings.X_String)
      return X_Toolkit.Xt_Boolean;
   pragma Convention (C, Test_Filename);


   function Test_Filename (Filename : in X_Strings.X_String)
      return X_Toolkit.Xt_Boolean is
   begin
      Ada.Text_Io.Put_Line ("testing: """ &
                            X_Strings.To_String (Filename) &
                            """");
      return X_Toolkit.To_Xt_Boolean (False); -- I want all components to be tested
   end Test_Filename;

begin
   Ada.Text_Io.Put ("path to test: ");
   Ada.Text_Io.Get_Line (Buffer, Last);
   Ada.Text_Io.Put_Line ("found: """ &
            X_Toolkit.Xt_Find_File (Buffer (1 .. Last), Subs,
	    Test_Filename'Unrestricted_Access) &
			 """");
end Testpath;
