/*
 *  playlist-ogg.c
 *  mod_musicindex
 *
 *  $Id: playlist-ogg.c,v 1.2 2004/02/09 01:04:10 varenet Exp $
 *
 *  Created by Regis BOUDIN on Thu Jan 22 2004.
 *  Copyright (c) 2003-2004 Regis BOUDIN
 *  Copyright (c) 2003-2004 Thibaut VARENE
 *   
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1, or (at your option)
 *  any later version.
 *
 */

/**
 * @file 
 * Ogg files management system.
 *
 * @author Regis Boudin
 * @version $Revision: 1.2 $
 * @date 2003-2004
 *
 * This file contains everything needed to produce music entries from
 * Ogg Vorbis files.
 */

#include "playlist.h"
#include "playlist-ogg.h"

/**
 * Fills in the information fields about OGG data.
 *
 * This function reads the ogg tags (using libvorbisfile) from the ogg file
 * and fills in the struct mu_ent fields accordingly. If the file is not an
 * ogg one, the function returns p = head.
 * 
 * @param pool Pool
 * @param head Head
 * @param in ogg file to parse (closed on normal exit)
 * @param conf MusicIndex configuration paramaters struct
 * @param names Names
 * @param r Apache request_rec struct to handle log writings (debugging)
 *
 * @return When possible, struct mu_ent correctly set up, file stream closed.
 */
mu_ent *make_ogg_entry(apr_pool_t *pool, mu_ent *head,
	FILE *in, mu_config *conf, mu_ent_names *names, request_rec *r)
{
	mu_ent			*p = head;
	OggVorbis_File		vf;
	vorbis_comment		*comment = NULL;
	char 			*t;
		
	if (!(ov_open(in, &vf, NULL, 0))) {
		p = new_ent(pool, head);
		p->filetype = FT_OGG;
	
		if ((comment = ov_comment(&vf, -1))) {
			if ((t = vorbis_comment_query(comment, "album", 0)))
				p->album = ap_pstrdup(pool, t);
			if ((t = vorbis_comment_query(comment, "artist", 0)))
				p->artist = ap_pstrdup(pool, t);
			if ((t = vorbis_comment_query(comment, "title", 0)))
				p->title = ap_pstrdup(pool, t);
			if ((t = vorbis_comment_query(comment, "tracknumber", 0)))
				p->track = atoi(t);
			if ((t = vorbis_comment_query(comment, "date", 0)))
				p->date = atoi(t);
			if ((t = vorbis_comment_query(comment, "tpos", 0)))	/* XXX does it exist? */
				p->posn = atoi(t);
			if ((t = vorbis_comment_query(comment, "genre", 0)))
				p->genre = ap_pstrdup(pool, t);
		}

		if (conf->options & (MI_QUICKPL)) {
			p->bitrate = p->length = 0;
		}
		else {
			p->bitrate = (long)ov_bitrate(&vf, -1);
			p->length = (long)ov_time_total(&vf, -1);
		}

		ov_clear(&vf);
	}
	return p;
}
